/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.security.externalAuth.cas;

import com.jaspersoft.jasperserver.api.security.externalAuth.cas.JSCasProcessingFilter;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.springframework.security.AuthenticationException;
import org.springframework.security.ui.rememberme.NullRememberMeServices;
import org.springframework.security.ui.rememberme.RememberMeServices;
import org.springframework.util.Assert;

public class JSSoapProcessingFilter
extends JSCasProcessingFilter {
    private String authorizationHeaderKeyName = "Authorization";
    private String encryptionKeyName = "Basic";
    private String credentialsDelimiter = ":";
    private String userName;
    private String password;
    private String ticket;
    private FilterChain chain;

    @Override
    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.getAuthenticationManager(), (String)"authenticationManager must be specified");
        Assert.notNull((Object)this.getExternalDataSynchronizer(), (String)"externalDataSynchronizer cannot be null");
        if (this.getRememberMeServices() == null) {
            this.setRememberMeServices((RememberMeServices)new NullRememberMeServices());
        }
    }

    public void doFilterHttp(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        this.chain = chain;
        super.doFilterHttp(request, response, chain);
    }

    protected boolean requiresAuthentication(HttpServletRequest request, HttpServletResponse response) {
        String uri = request.getRequestURI();
        int pathParamIndex = uri.indexOf(59);
        if (pathParamIndex > 0) {
            uri = uri.substring(0, pathParamIndex);
        }
        if ("".equals(request.getContextPath())) {
            return uri.endsWith(this.getFilterProcessesUrl());
        }
        return uri.startsWith(request.getContextPath() + this.getFilterProcessesUrl());
    }

    protected void onPreAuthentication(HttpServletRequest request, HttpServletResponse response) throws AuthenticationException, IOException {
        String base64Token;
        String token;
        int delim;
        String header = request.getHeader("Authorization");
        if (header != null && this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Authorization header: " + header));
        }
        if (header != null && header.startsWith(this.encryptionKeyName) && (delim = (token = new String(Base64.decodeBase64((byte[])(base64Token = header.substring(6)).getBytes()))).indexOf(":")) != -1) {
            String tempHeader = token.substring(0, delim);
            if (tempHeader.equalsIgnoreCase(this.encryptionKeyName)) {
                this.ticket = token.substring(delim + 1);
            } else {
                this.userName = tempHeader;
                this.password = token.substring(delim + 1);
            }
        }
    }

    protected void sendRedirect(HttpServletRequest request, HttpServletResponse response, String url) throws IOException {
        try {
            this.chain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        catch (ServletException e) {
            this.logger.error((Object)("ServletException: " + e.getMessage()));
            throw new IllegalStateException(e);
        }
    }

    public String getAuthorizationHeaderKeyName() {
        return this.authorizationHeaderKeyName;
    }

    public void setAuthorizationHeaderKeyName(String authorizationHeaderKeyName) {
        this.authorizationHeaderKeyName = authorizationHeaderKeyName;
    }

    public String getEncryptionKeyName() {
        return this.encryptionKeyName;
    }

    @Override
    protected String obtainTicket(HttpServletRequest request) {
        return this.ticket;
    }

    public void setEncryptionKeyName(String encryptionKeyName) {
        this.encryptionKeyName = encryptionKeyName;
    }

    public String getCredentialsDelimiter() {
        return this.credentialsDelimiter;
    }

    public void setCredentialsDelimiter(String credentialsDelimiter) {
        this.credentialsDelimiter = credentialsDelimiter;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getTicket() {
        return this.ticket;
    }

    public void setTicket(String ticket) {
        this.ticket = ticket;
    }

    public FilterChain getChain() {
        return this.chain;
    }

    public void setChain(FilterChain chain) {
        this.chain = chain;
    }
}

