/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.security.externalAuth.cas;

import com.jaspersoft.jasperserver.api.security.externalAuth.ExternalDataSynchronizer;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.Authentication;
import org.springframework.security.AuthenticationException;
import org.springframework.security.context.SecurityContextHolder;
import org.springframework.security.providers.UsernamePasswordAuthenticationToken;
import org.springframework.security.providers.cas.CasAuthenticationToken;
import org.springframework.security.ui.cas.CasProcessingFilter;
import org.springframework.util.Assert;

public class JSCasProcessingFilter
extends CasProcessingFilter {
    private String usernameParameter = "j_username";
    private String passwordParameter = "j_password";
    private ExternalDataSynchronizer externalDataSynchronizer;
    private String internalAuthenticationFailureUrl;

    public Authentication attemptAuthentication(HttpServletRequest request) throws AuthenticationException {
        String password = this.obtainTicket(request);
        if (password != null && password.trim().length() > 0) {
            String username = "_cas_stateful_";
            UsernamePasswordAuthenticationToken authRequest = new UsernamePasswordAuthenticationToken((Object)"_cas_stateful_", (Object)password);
            authRequest.setDetails(this.authenticationDetailsSource.buildDetails((Object)request));
            return this.getAuthenticationManager().authenticate((Authentication)authRequest);
        }
        String username = this.obtainUsername(request);
        password = this.obtainPassword(request);
        UsernamePasswordAuthenticationToken authRequest = new UsernamePasswordAuthenticationToken((Object)(username != null ? username.trim() : ""), (Object)(password != null ? password : ""));
        this.setDetails(request, authRequest);
        return this.getAuthenticationManager().authenticate((Authentication)authRequest);
    }

    protected void onSuccessfulAuthentication(HttpServletRequest request, HttpServletResponse response, Authentication authResult) throws IOException {
        try {
            if (authResult instanceof CasAuthenticationToken) {
                SecurityContextHolder.getContext().setAuthentication(authResult);
                this.externalDataSynchronizer.synchronize();
            }
        }
        catch (RuntimeException e) {
            SecurityContextHolder.getContext().setAuthentication(null);
            throw e;
        }
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.externalDataSynchronizer, (String)"externalDataSynchronizer must not be null.");
        super.afterPropertiesSet();
    }

    protected String obtainUsername(HttpServletRequest request) {
        return request.getParameter(this.usernameParameter);
    }

    protected String obtainTicket(HttpServletRequest request) {
        return request.getParameter("ticket");
    }

    protected String obtainPassword(HttpServletRequest request) {
        return request.getParameter(this.passwordParameter);
    }

    String getUsernameParameter() {
        return this.usernameParameter;
    }

    public void setUsernameParameter(String usernameParameter) {
        Assert.hasText((String)usernameParameter, (String)"Username parameter must not be empty or null");
        this.usernameParameter = usernameParameter;
    }

    String getPasswordParameter() {
        return this.passwordParameter;
    }

    public void setPasswordParameter(String passwordParameter) {
        Assert.hasText((String)passwordParameter, (String)"Password parameter must not be empty or null");
        this.passwordParameter = passwordParameter;
    }

    protected void setDetails(HttpServletRequest request, UsernamePasswordAuthenticationToken authRequest) {
        authRequest.setDetails(this.authenticationDetailsSource.buildDetails((Object)request));
    }

    public ExternalDataSynchronizer getExternalDataSynchronizer() {
        return this.externalDataSynchronizer;
    }

    public void setExternalDataSynchronizer(ExternalDataSynchronizer externalDataSynchronizer) {
        this.externalDataSynchronizer = externalDataSynchronizer;
    }

    public void setInternalAuthenticationFailureUrl(String internalAuthenticationFailureUrl) {
        this.setAuthenticationFailureUrl(internalAuthenticationFailureUrl);
    }
}

