var Manager = Class.create({
    initialize: function(viewer, editor, creator, dataRetriever, messageSource) {

        this.messageSource = messageSource;
        this.minHeigth = 350;

        this.messageDialog = new Manager.MessageDialog();

        this.dataRetriever = dataRetriever;
        this.userDataUpdater = new UserDataUpdater(Manager.State.flowExecutionKey);

        // init components
        this.nothingSelected = $('nothingSelected');

        this.searchNameInput = new SearchTextBox("searchNameInput", this.messageSource.getMessage('defaultUserSearchText'));
        this.searchItemBtn = $('searchBtn');
        this.addItemBtn = new LinkButton('addItemBtn', 'toolbarLink', 'toolbarLinkHover', 'toolbarLinkDisabled')


        this.itemList = new PaginatedListBox("items", null, 100);

        this.viewer = viewer;
        this.editor = editor;
        this.creator = creator;

        this.setUpErrorHandling()
        this.setUpCreator();
        this.setUpItemList();
        this.setUpViewer();
        this.setUpEditor();
        this.setUpUserDetailsLoad()

        if (Manager.isProVersion()) {

            this.tenantTree = new TenantTreePro('tenantTree');
        } else {

            this.tenantTree = new TenantTreeOS();
        }

        this.setUpUserSearch();
        
        if(!Manager.isProVersion()) {
            
            this.loadItems(0);
        }

        this.resize();
    },

    resize : function () {
        var managerTable = $('managerTable');
        managerTable.hide();

//        var h = $('decoratedBody').clientHeight - 80 - 35 - (2 * 4) - 30;
        var h = $('managerBody').clientHeight - ((isIE()) ? 75 : 40);

        if (h < this.minHeigth) {

            h = this.minHeigth;
        }
        var elements = [$('tenantTree'), $(this.itemList.id), $(this.nothingSelected.id), $(this.viewer.id), $(this.editor.id)];
        var heights = [h, h, h, (isIE()) ? h : h + 2, (isIE()) ? h : h + 2];

        for (var i = 0; i < elements.length; i ++) {
            if (elements[i]) {

                elements[i].style.height = heights[i] + 'px';
            }
        }

        managerTable.show();
        this.itemList.resize();
    },

    setUpCreator: function() {
        var managerInstance = this;


        this.addItemBtn.onclick = function () {

            var tenantId = managerInstance.tenantTree.getSelectedTenant();
            if (tenantId == Manager.State.organizations) {

                tenantId = null;
            }
            managerInstance.creator.setTenantId(tenantId);

            managerInstance.creator.show();
        }

        managerInstance.creator.onsubmit = function (user) {

            managerInstance.createItem(user);
        }
    },

//    setUpItemList: function() {
//        this.itemList.setSelectedClassName('listItemSelected listItem');
//        this.itemList.setOptionClassName('list_default listItem');
//
//        var managerInstance = this;
//
//        var updateItemList = function(firstResult) {
//
//            managerInstance.loadItems(firstResult);
//        }
//
//        this.itemList.onreload = updateItemList;
//
//        this.itemList.onnext = updateItemList;
//
//        this.itemList.onprev = updateItemList;
//    },

//    setUpViewer: function() {
//        var managerInstance = this;
//
//        this.viewer.onedit = function (item) {
//
////            var userCopy = UserUtil.clone(user);
//            managerInstance.editor.setUser(item);
//
//            managerInstance.editor.show();
//        }
//
//        this.viewer.onlogin = function (userName) {
//
//            document.location="j_acegi_switch_user?j_username=" + userName;
//        }
//
//        this.viewer.ondelete = function (userName) {
//
//            return managerInstance.deleteItem(userName);
//        }
//
//        this.viewer.onbeforeshow = function () {
//
//            managerInstance.nothingSelected.hide();
//
//            if (managerInstance.editor.isEdit()) {
//
//                managerInstance.editor.cancelEdit();
//                return false;
//            }
//
//            return true;
//        }
//
//    },

//    setUpEditor: function() {
//        var managerInstance = this;
//
//        this.editor.onsave = function (user) {
//
//            managerInstance.updateItem(user);
//        }
//
//        this.editor.oncancel = function () {
//
//            managerInstance.viewer.show();
//        }
//
//        this.editor.onbeforeshow = function () {
//
//            managerInstance.viewer.hide();
//
//            return true;
//        }
//    },
//
//    setUpUserSearch: function() {
//        var managerInstance = this;
//
//        this.searchItemBtn.observe('click', function() {
//
//            managerInstance.loadItems(0);
//        });
//
//        this.searchNameInput.onclear = function () {
//
//            managerInstance.loadItems(0);
//        }
//
//        this.searchNameInput.getInput().observe('keyup', function(e) {
//
//            if (enterKeyHit(e)) {
//
//                managerInstance.loadItems(0);
//            }
//        });
//
//        this.tenantTree.onTenantSelect = function(tenantId) {
//
//            managerInstance.loadItems(0);
//        }
//    },

    setUpUserDetailsLoad: function() {
        var managerInstance = this;

//        this.itemList.onclick = function (l) {
//
//            var selectedValues = managerInstance.itemList.getSelectedValues();
//
//            if (selectedValues.length > 0) {
//
//                if (selectedValues[0] && !selectedValues[0].blank()) {
//
//                    var userName = selectedValues[0];
//                    managerInstance.loadUserDetails(userName);
//                } else {
//
//                    managerInstance.itemList.getList().deselectAll();
//                }
//            }
//        }

//        this.dataRetriever.onUserDetailsRetrieved = function (data) {
//
//            managerInstance.viewer.show();
//            managerInstance.viewer.setItem(data);
//        }
    },

    setUpErrorHandling : function () {

        var errorHandler = function (error) {

            var msgBox = new MsgBox("", error.message);
            msgBox.show();
        }

        this.dataRetriever.onErrorRetrieved = errorHandler;

        this.userDataUpdater.onCreateUserError = errorHandler;
        this.userDataUpdater.onUpdateUserError = errorHandler;
        this.userDataUpdater.onDeleteUserError = errorHandler;
    },

//    loadItems: function(firstResult) {
//
//        var editorCanceled = true;
//        if (this.editor.isEdit()) {
//
//            editorCanceled = this.editor.cancelEdit();
//        }
//
//        if (editorCanceled) {
//            this.viewer.hide();
//            this.nothingSelected.show();
//
//            var itemName = this.searchNameInput.getValue();
//            var tenantId = this.tenantTree.getSelectedTenant();
//
//            this.searchNameInput.setClearImage(itemName.blank() ? Manager.emptyImg : Manager.clearSearchImg);
//
//            this.dataRetriever.getItems(tenantId, itemName, firstResult);
//        }
//    },

    reloadItems: function(firstResult) {

        var itemListModel = this.itemList.getModel();

        if (itemListModel) {

            var firstResult = itemListModel.getFirstResult();
            this.loadItems(firstResult);
        }
    },

//    loadUserDetails: function(userName) {
//
//        this.dataRetriever.getUserDetails(userName);
//    },

//    deleteItem: function(itemName) {
//
//        if (!itemName) {
//            return;
//        }
//
//        var managerInstance = this;
//
//        var hideViewer = this.viewer.isItemViewed(itemName);
//        var reloadList = this.itemList.getModel().containsValue(itemName);
//
//        this.userDataUpdater.onDeleteUserSuccess = function () {
//
//            if (hideViewer) {
//
//                managerInstance.viewer.hide();
//            }
//            if (reloadList) {
//
//                managerInstance.itemList.reload();
//            }
//        }
//
//        this.userDataUpdater.deleteItem(userName);
//
//        return true;
//    },

    createItem: function(user) {

        if (!user) {
            return;
        }

        var managerInstance = this;


        this.userDataUpdater.onCreateUserSuccess = function () {

            managerInstance.reloadItems()

            managerInstance.viewer.setItem(user);
            managerInstance.viewer.show();
        }

        this.userDataUpdater.createItem(user);
    },

//    updateItem: function(user) {
//
//        if (!user) {
//            return;
//        }
//
//        var managerInstance = this;
//
//        this.userDataUpdater.onUpdateUserSuccess = function () {
//
////            managerInstance.editor.hide();
//
//            var editedUser = managerInstance.editor.getUser();
//            delete editedUser.password;
//
//            var itemListModel = managerInstance.itemList.getModel();
//
//            if (itemListModel && itemListModel.containsUser(editedUser.userName)) {
//
//                var users = itemListModel.getUsers();
//
//                for (var i = 0; i < users.length; i ++) {
//                    var user = users[i];
//
//                    if (user.userName == editedUser.userName) {
//
//                        user.enabled = editedUser.enabled;
//
//                        managerInstance.itemList.refresh();
//                        managerInstance.itemList.getList().selectOption(i);
//
//                        break;
//                    }
//                }
//
//                managerInstance.editor.hide();
//                managerInstance.viewer.show();
//            } else {
//
//                managerInstance.loadUserDetails(editedUser.userName);
//            }
//        }
//
//        this.userDataUpdater.updateItem(user);
//    }

});

Manager.messages = {};
Manager.clearSearchImg = 'images/clearValue.gif';
Manager.emptyImg = 'images/pixel.gif';

Manager.isProVersion = function () {

    return js_edition && js_edition == 'PRO';
}

Manager.encodeUriComponent = function(string) {
    return encodeURIComponent(encodeURIComponent(string));
}

Manager.State = {};
Manager.State.organizations = 'organizations';
Manager.State.flowExecutionKey = '';
Manager.State.tenantId = null;

Manager.Configuration = {
    userNameSeparator : "|",
    userDefaultRole : "ROLE_USER",
    userNameNotSupportedSymbols : "[\|]"
}

Manager.MessageDialog = Class.create({

    initialize: function() {
    },

    showMessage: function(message) {
        showMessageDialog(message);
    }

});

Manager.getBaseErrorHandler = function() {
    return function (ajaxAgent) {

        var sessionTimeout = ajaxAgent.getResponseHeader("LoginRequested");
        if (sessionTimeout) {
            var newloc = '.';
            document.location = newloc;
            return true;
        }

        var isErrorPage = ajaxAgent.getResponseHeader("JasperServerError");
        if (isErrorPage) {

            var msgBox = new MsgBox("", "Unknown error.");
            msgBox.show();
            
            return true;
        }

        return false;
    }
}

//var ItemViewer = Class.create({
//    initialize : function (id, messageSource) {
//
//        this.id = id;
//        this.messageSource = messageSource;
//
//        this.viewer = $(this.id);
//        this.item = null;
//    },
//
//    setItem : function(item) {
//        this.item = item;
//
//        this.refresh();
//    },
//
//    refresh : function() { /* Do Nothing*/ },
//
//    show : function() {
//
//        var show = this.onbeforeshow();
//        if (show) {
//
//            this.viewer.show();
//        }
//    },
//
//    hide : function() {
//
//        this.viewer.hide();
//    },
//
//    isItemViewed : function(itemName) { /* Do Nothing*/ },
//
//    _createLink : function(container, text) {
//
//        var a = document.createElement('a');
//        a.id = text;
//        a.href = '#null';
//        a.innerHTML = text;
//
////        Element.extend(a);
//        container.appendChild(a);
//
//        var link = new LinkButton(a.id, 'editorLink', 'editorLinkHover', 'editorLinkDisabled');
//
////        link.onclick = function () {
////            alert('Manage Roles. Default is {' + role.roleName + '}');
////        }
//
//        return link;
//    },
//
//    onbeforeshow : function() { /* Do Nothing*/ },
//
//    onedit : function(item) { /* Do Nothing*/ },
//
//    ondelete : function(itemName) { /* Do Nothing*/ }
//});
//
//var ItemEditor = Class.create({
//    initialize : function (id, messageSource) {
//        this.id = id;
//        this.messageSource = messageSource;
//
//        this.originalItem = null;
//        this.item = null;
//
//        this.edit = false;
//        this.saveBtn = null;
//        this.cancelBtn = null;
//
//        this.editor = $(this.id);
//    },
//
//    allowSave : function () {
//        var editorInstance = this;
//
//        function enableSave () {
//
//            editorInstance.saveBtn.setDisabled(false);
//        }
//
//        setTimeout(enableSave, 500);
//    },
//
//    isEdit : function(user) {
//
//        return this.edit;
//    },
//
//    setItem : function(item) {
//        this.item = item;
//        this.originalUser = this.cloneItem(item);
//
//        this.resetValidationState();
//        this.refresh();
//    },
//
//    getItem : function() { },
//
//    show : function() {
//
//        var show = this.onbeforeshow();
//        if (show) {
//
//            this.edit = true;
//
//            this.editor.show();
//        }
//
//    },
//
//    hide : function() {
//        this.originalItem = null;
//        this.item = null;
//
//        this.edit = false;
//
//        this.editor.hide();
//    },
//
//    cancelEdit : function() {
//
//        var editorInstance = this;
//
//        var doCancel = function () {
//
//            editorInstance.hide();
//            editorInstance.oncancel();
//
//            return true;
//         }
//
//         if (this.equals(this.originalItem, editorInstance.getItem())) {
//
//             return doCancel();
//         } else {
//
//             this.cancelConfirm.onok = doCancel;
//             this.cancelConfirm.oncancel = function() {return true};
//             this.cancelConfirm.show();
//
//             return false;
//         }
//    },
//
//    onbeforeshow : function() { /* Do Nothing*/ },
//
//    onsave : function(user) { /* Do Nothing*/ },
//
//    oncancel : function() { /* Do Nothing*/ },
//
//    resetValidationState : function () { },
//
//    cloneItem : function () { },
//
//    equals : function () { }
//});
