////////////////////////////////////////////////
// Generic toolbar button utils
////////////////////////////////////////////////

    var toolbarButtonModule = {};

    toolbarButtonModule.DISABLED = "disabled";
    toolbarButtonModule.REACTIVE = "reactive";
    toolbarButtonModule.OVER = "over";
    toolbarButtonModule.PRESSED = "pressed";
    toolbarButtonModule.UP = "up";
    toolbarButtonModule.DOWN = "down";
    toolbarButtonModule.SHOW = "show";
    toolbarButtonModule.HIDE = "hide";

    //menus
    toolbarButtonModule.CONTENT_PREFIX = "toolbar_"

    //temporarily hold on to name of highlighted button if we can't unhighlight it immediately
    //eg a complex button where user is now hovering over menu
    toolbarButtonModule.highlightedButton;

/////////////////////////////////////////////////////////////////////
// Set up
/////////////////////////////////////////////////////////////////////

    function initToolbar(){
        //toolbar simple
        var simpleButtons = $$('.toolbar .simple');
        for (var i = 0; i < simpleButtons.length; i++) {
            simpleButtons[i].onmouseover = function(event){
                if (!toolbarButtonModule.isDisabled(this) && !toolbarButtonModule.isMouseoverStyle(this)) {
                    this.className += (' ' + toolbarButtonModule.OVER);
                    toolbarButtonModule.handleTooltip(this, toolbarButtonModule.SHOW, event?event:window.event);
                }
            };
            simpleButtons[i].onmouseout = function(event){
                if (!toolbarButtonModule.isDisabled(this)) {
                    this.className = this.className.sub(toolbarButtonModule.OVER, '');
                    toolbarButtonModule.handleTooltip(this, toolbarButtonModule.HIDE, event?event:window.event);
                }
            };
            simpleButtons[i].onmousedown = function(event){
                if (!toolbarButtonModule.isDisabled(this)) {
                    this.className = this.className.sub(toolbarButtonModule.OVER, toolbarButtonModule.PRESSED);
                    toolbarButtonModule.handleTooltip(this, toolbarButtonModule.HIDE, event?event:window.event);
                }
            };
            simpleButtons[i].onmouseup = function(event){
                if (!toolbarButtonModule.isDisabled(this)) {
                    this.className = this.className.sub(toolbarButtonModule.PRESSED, toolbarButtonModule.OVER);
                }
            };
        }

        //toolbar sticky
        var stickyButtons = $$('.toolbar .sticky');
        for (var i = 0; i < stickyButtons.length; i++) {
            stickyButtons[i].onmouseover = function(event){
                if (!toolbarButtonModule.isDisabled(this) && !toolbarButtonModule.isMouseoverStyle(this)) {
                    this.className += (' ' + toolbarButtonModule.OVER);
                    toolbarButtonModule.handleTooltip(this, toolbarButtonModule.SHOW, event?event:window.event);
                }
            };
            stickyButtons[i].onmouseout = function(event){
                if (!toolbarButtonModule.isDisabled(this)) {
                    this.className = this.className.sub(' ' + toolbarButtonModule.OVER, '');
                    toolbarButtonModule.handleTooltip(this, toolbarButtonModule.HIDE, event?event:window.event);
                }
            };
            stickyButtons[i].onmousedown = function(event){
                if (!toolbarButtonModule.isDisabled(this)) {
                    this.className = this.className.sub(toolbarButtonModule.OVER, toolbarButtonModule.PRESSED);
                    toolbarButtonModule.handleTooltip(this, toolbarButtonModule.HIDE, event?event:window.event);
                }
            };
            stickyButtons[i].onmouseup = function(event){
                if (!toolbarButtonModule.isDisabled(this)) {
                    this.className = this.className.sub(' ' + toolbarButtonModule.PRESSED, '');
                    if (toolbarButtonModule.isReactive(this)) {
                        toolbarButtonModule.toggle(this);
                    }
                }
            };
        }

        //complex button (drop down)
        var complexButtons = $$('.toolbar .complex');
        for (var i=0;i<complexButtons.length;i++) {
            complexButtons[i].onmouseover = function(event){
                if (!toolbarButtonModule.isDisabled(this) && !toolbarButtonModule.isMouseoverStyle(this)) {
                    this.className += (' ' + toolbarButtonModule.OVER);
                    toolbarButtonModule.showMenu(this, event);
                }
                cancelEventBubbling(event);
            };
            complexButtons[i].onmousedown = function(event){
                cancelEventBubbling(event);
            };       
            complexButtons[i].onmouseup = function(event){
                cancelEventBubbling(event);
            };                 
            complexButtons[i].onmouseout = function(){
                if (!toolbarButtonModule.isDisabled(this)) {
                    toolbarButtonModule.highlightedButton = this;
                }
            };
        }
   }

    toolbarButtonModule.showMenu = function(complexButton, event) {
        unselectAll();
        //use action model if there is one
        if (actionModel) {
            var leftScrollAdjust = isIE() ? complexButton.cumulativeScrollOffset()[0] : 0;
            menuLeft = getBoxOffsets(complexButton)[0] + leftScrollAdjust - 1;
            var topScrollAdjust = isIE() ? complexButton.cumulativeScrollOffset()[1] : 0;
            menuTop = getBoxOffsets(complexButton)[1] + parseInt($(complexButton).getStyle('height'))+1 + topScrollAdjust;
            showDynamicMenu(
                toolbarButtonModule.CONTENT_PREFIX + complexButton.getAttribute('id') + actionModel.CONTEXT_SUFFIX, event,
                'toolbarMenu',
                menuLeft,
                menuTop
             );
        }
        theBody.onmouseover = toolbarButtonModule.mouseoutComplexButton;
        hideCustomTooltip(event); //just in case
    }

    toolbarButtonModule.mouseoutComplexButton = function(event) {
        window.status = new Date();
        if ($('theMenu').className==='toolbarMenu') {
            var e = window.event ? window.event : event;
            var hovered = window.event? e.srcElement : e.target;
            hoveredDiv = getParentDiv(hovered);
            if ($('theMenu') !== hoveredDiv) {
                if (toolbarButtonModule.highlightedButton) {
                    toolbarButtonModule.highlightedButton.className = toolbarButtonModule.highlightedButton.className.sub(toolbarButtonModule.OVER, "");
                    toolbarButtonModule.highlightedButton = null;
                }
                hideMenu();
                unselectAll();
                theBody.onmouseover = "";
            }
        }
    }


/////////////////////////////////////////////////////////////////////
// Tests
/////////////////////////////////////////////////////////////////////


    toolbarButtonModule.isDisabled = function(button){
        return button.className.include(toolbarButtonModule.DISABLED);
    }

    toolbarButtonModule.isReactive = function(button){
        return button.className.include(toolbarButtonModule.REACTIVE);
    }


    toolbarButtonModule.isMouseoverStyle = function(button){
        return button.className.include(toolbarButtonModule.OVER);
    }

/////////////////////////////////////////////////////////////////////
// Actions
/////////////////////////////////////////////////////////////////////

    toolbarButtonModule.enable = function(button, enable){
        if (button) {
            if (enable && toolbarButtonModule.isDisabled(button)) {
                button.className = button.className.sub(toolbarButtonModule.DISABLED, '');
            } else if (!enable && !toolbarButtonModule.isDisabled(button)) {
                button.className += (' ' + toolbarButtonModule.DISABLED);
            }
        }
    }

    /**
     * for sticky buttons only
     * @param {Object} button
     */
    toolbarButtonModule.toggle = function(button){
        if (button) {
            if (button.className.include(toolbarButtonModule.UP)) {
                toolbarButtonModule.pushDown(button);
            } else {
                toolbarButtonModule.pullUp(button);
            }
        }
    }

    /**
     * for sticky buttons only
     * @param {Object} button
     */
    toolbarButtonModule.pullUp = function(button){
        if (button) {
            if (button.className.include(toolbarButtonModule.DOWN)) {
                button.className = button.className.replace(toolbarButtonModule.DOWN, toolbarButtonModule.UP);
            }
        }
    }

    /**
     * for sticky buttons only
     * @param {Object} button
     */
    toolbarButtonModule.pushDown = function(button){
        if (button) {
            if (button.className.include(toolbarButtonModule.UP)) {
                button.className = button.className.replace(toolbarButtonModule.UP, toolbarButtonModule.DOWN);
            }
        }
    }



    toolbarButtonModule.handleTooltip = function(button,what,event) {

            var tooltipArray = $(button).select('.tooltip') //need to do $(button) for IE6
            if (tooltipArray.length == 0) {
                return;
            }
            var theTooltip = tooltipArray[0];

            if (what == toolbarButtonModule.SHOW) {
                var buttonOffsets = getBoxOffsets(button);
                var tipTop = buttonOffsets[1] + button.clientHeight + 5;
                var showTooltip = function(){
                    if (toolbarButtonModule.isMouseoverStyle(button)) {
                        showCustomTooltipBelowObject(event, theTooltip.innerHTML, null, "toolButtonInfoTip", button);
                    }    
                };
                setTimeout(showTooltip, 1000);
            }
            else if (what == toolbarButtonModule.HIDE) {
                hideCustomTooltip(event);
            }
    }

    toolbarButtonModule.clicked = function(button, myFunction, myArgs) {
        if (!toolbarButtonModule.isDisabled(button)) {
            if (myArgs && isArray(myArgs)) {
                myFunction.apply(this, myArgs);
            } else {
                myFunction(myArgs);
            }
        }
    }


/////////////////////////////////////////////////////////////////////
// On load
/////////////////////////////////////////////////////////////////////

    initToolbar();

