////////////////////////////////////////////////
// Generic tab utils
// author: Angus Croll
////////////////////////////////////////////////    

    var tabModule = {};
    
    tabModule.OVER = "over";
    tabModule.SELECTED = "selected";
    
    tabModule.mouseEnters = function(tab) {
        if (!tabModule.isSelected(tab)) {
            tab.className += (tabModule.OVER);            
        }   
    }
    
    tabModule.mouseLeaves = function(tab) {
        tab.className = tab.className.sub(tabModule.OVER , '');       
    }    

    tabModule.isSelected = function(tab) {
        if (tab) {
            return tab.className.include(tabModule.SELECTED);
        }    
    }

    tabModule.setSelected = function(tab) {
        if (!tabModule.isSelected(tab)) {
            tab.className = tabModule.SELECTED;  
        }    
    }
    
    tabModule.setUnselected = function(tab) {
        if (tabModule.isSelected(tab)) {
            tab.className = tab.className.sub(tabModule.SELECTED , '');     
        }    
    }   
    
    tabModule.unselectAll = function(tabArray) {
        for (var i = 0; i < tabArray.length; i++) {
            tabModule.setUnselected(tabArray[i]);
        }        
    }      
		
