/*
 * Copyright (C) 2005 - 2007 JasperSoft Corporation.  All rights reserved.
 * http://www.jaspersoft.com.
 *
 * Unless you have purchased a commercial license agreement from JasperSoft,
 * the following license terms apply:
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as published by
 * the Free Software Foundation.
 *
 * This program is distributed WITHOUT ANY WARRANTY; and without the
 * implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see http://www.gnu.org/licenses/gpl.txt
 * or write to:
 *
 * Free Software Foundation, Inc.,
 * 59 Temple Place - Suite 330,
 * Boston, MA  USA  02111-1307
 */
package com.jaspersoft.jasperserver.war.common;

import java.io.Serializable;


/**
 * @author Teodor Danciu (teodord@users.sourceforge.net)
 * @version $Id: HibernateLoggingService.java 8408 2007-05-29 23:29:12Z melih $
 */
public abstract class HeartbeatInfo implements HeartbeatContributor, Serializable
{
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	
	private int count = 0;

	/**
	 * 
	 */
	public int getCount() 
	{
		return count;
	}
	
	/**
	 * 
	 */
	public void incrementCount() {
		count++;
	}
	
	/**
	 * 
	 */
	public abstract String getKey();
	
	/**
	 * 
	 */
	public int hashCode()
	{
		return getKey().hashCode();
	}
	
	/**
	 * 
	 */
	public boolean equals(Object obj) 
	{
		HeartbeatInfo info = obj instanceof HeartbeatInfo ? (HeartbeatInfo)obj : null;
		return (info != null && getKey().equals(info.getKey()));
	}
}
