/*
 * Copyright (C) 2005 - 2007 JasperSoft Corporation.  All rights reserved.
 * http://www.jaspersoft.com.
 *
 * Unless you have purchased a commercial license agreement from JasperSoft,
 * the following license terms apply:
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as published by
 * the Free Software Foundation.
 *
 * This program is distributed WITHOUT ANY WARRANTY; and without the
 * implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see http://www.gnu.org/licenses/gpl.txt
 * or write to:
 *
 * Free Software Foundation, Inc.,
 * 59 Temple Place - Suite 330,
 * Boston, MA  USA  02111-1307
 */
package com.jaspersoft.jasperserver.api.metadata.view.service.impl;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

import javax.naming.NamingException;

import org.springframework.test.AbstractDependencyInjectionSpringContextTests;

import com.jaspersoft.jasperserver.api.metadata.common.service.impl.hibernate.HibernateRepositoryService;
import com.jaspersoft.jasperserver.api.metadata.user.domain.ProfileAttribute;
import com.jaspersoft.jasperserver.api.metadata.user.domain.Role;
import com.jaspersoft.jasperserver.api.metadata.user.domain.User;
import com.jaspersoft.jasperserver.api.metadata.user.service.ProfileAttributeService;
import com.jaspersoft.jasperserver.api.metadata.user.service.UserAuthorityService;

/**
 * @author sbirney
 *
 */
public class ProfileAttributeTest extends AbstractDependencyInjectionSpringContextTests {

	Properties jdbcProps;
    HibernateRepositoryService repositoryService;
    UserAuthorityService userAuthorityService;
    ProfileAttributeService profileAttributeService;

    boolean error = false;

    public HibernateRepositoryService getRepositoryService() {
		return repositoryService;
	}

	public void setRepositoryService(HibernateRepositoryService repositoryService) {
		this.repositoryService = repositoryService;
	}

	public UserAuthorityService getUserAuthorityService() {
		return userAuthorityService;
	}

	public void setUserAuthorityService(UserAuthorityService userAuthorityService) {
		this.userAuthorityService = userAuthorityService;
	}

	public ProfileAttributeService getProfileAttributeService() {
		return profileAttributeService;
	}

	public void setProfileAttributeService(
			ProfileAttributeService profileAttributeService) {
		this.profileAttributeService = profileAttributeService;
	}

	public ProfileAttributeTest(String name) {
    	super(name);
    	setAutowireMode(AUTOWIRE_BY_NAME);
    }
    
    protected Properties loadJdbcProps() throws IOException, FileNotFoundException, NamingException {
        jdbcProps = new Properties();
        String jdbcPropFile = System.getProperty("test.hibernate.jdbc.properties");
        BufferedInputStream is = new BufferedInputStream(new FileInputStream(jdbcPropFile));
        jdbcProps.load(is);
        is.close();
        return jdbcProps;
    }

    protected String[] getConfigLocations() {
		try {
			loadJdbcProps();
		} catch (Exception e) {
			throw new RuntimeException(e);
		}

		// metadata.additionalSettings=hibernateRepositoryAdditionalSettings.xml

		if (jdbcProps.getProperty("metadata.additionalSettings") == null) {
			return
					new String[] {"hibernateConfig.xml", "userAuthorityService.xml", "viewService.xml"};
		} else {
			return
					new String[] {"hibernateConfig.xml", jdbcProps.getProperty("metadata.additionalSettings"), "userAuthorityService.xml", "viewService.xml"};
		}
    }

    /* from ObjectPermissionServiceTest */
    private Role getOrCreateRole(String roleName) {
	Role r = userAuthorityService.getRole(null, roleName);
	if (r == null) {
	    r = userAuthorityService.newRole(null);
	    r.setRoleName(roleName);
	    r.setExternallyDefined(false);
	    userAuthorityService.putRole(null, r);
	}
	return r;
    }

    /* from ObjectPermissionServiceTest */
    private User findOrCreateUser(String username, String fullName) {
	User workingUser = userAuthorityService.getUser(null, username);
	if (workingUser == null) {
	    workingUser = userAuthorityService.newUser(null);
	    workingUser.setUsername(username);
	    workingUser.setPassword(username);
	    workingUser.setFullName(fullName);
	    workingUser.setEnabled(true);

	    userAuthorityService.putUser(null, workingUser);
	}

	return workingUser;
    }

    public void testProfileAttributeService() {
	User caluser = findOrCreateUser("CaliforniaUser", "California User");
	ProfileAttribute attr = createTestAttr( caluser, "State", "CA" );
	profileAttributeService.putProfileAttribute( null, attr );
	attr = createTestAttr( caluser, "Cities", "San Francisco, Oakland, San Jose, Los Angeles, Sacramento, Fresno" );
	profileAttributeService.putProfileAttribute( null, attr );
	List attrList =
	    profileAttributeService.getProfileAttributesForPrincipal( null,
								      caluser );

	assertTrue( "ProfileAttribute list was empty", attrList.size() > 0 );
	for (Iterator it = attrList.iterator(); !attrList.isEmpty() && it.hasNext();) {
	    ProfileAttribute elem = (ProfileAttribute) it.next();
	    if ("State".equals(elem.getAttrName())) {
		assertTrue( "Test attribute did not match expected value",
			    "CA".equals(elem.getAttrValue()) );
	    }
	}
    }

    private ProfileAttribute createTestAttr(Object principal,
					    String name,
					    String value) {
	ProfileAttribute attr = profileAttributeService.newProfileAttribute( null );
	attr.setPrincipal( principal );
	attr.setAttrName( name );
	attr.setAttrValue( value );
	return attr;
    }

}
