/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package com.jaspersoft.jasperserver.api.metadata.view.service.impl;

import org.acegisecurity.Authentication;
import org.acegisecurity.AuthenticationException;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.providers.AuthenticationProvider;
import org.acegisecurity.providers.UsernamePasswordAuthenticationToken;
import org.acegisecurity.userdetails.UserDetails;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 *
 * @author swood
 */
        
public class MockStringAuthenticationProvider implements AuthenticationProvider {
    
    private static Log log = LogFactory.getLog(MockStringAuthenticationProvider.class);

    private GrantedAuthority[] grantedAuthorities;
    
    public Authentication authenticate(Authentication auth) throws AuthenticationException {

        log.debug("Initial authentication is: " + auth);
        
        // Only the password "password" is valid

        if (!(auth.getCredentials() instanceof String) || !(((String) auth.getCredentials()).equalsIgnoreCase(AuthenticationTest.testExternalPassword)) ) {
            log.debug("invalid credentials. was " + auth.getCredentials());
            return null;
        }

        UsernamePasswordAuthenticationToken token = null;

        if (auth.getPrincipal() instanceof String) {
            token = new UsernamePasswordAuthenticationToken(auth.getPrincipal(), AuthenticationTest.testExternalPassword, getGrantedAuthorities());
        } else if (auth.getPrincipal() instanceof UserDetails) {
            UserDetails ud = (UserDetails) auth.getPrincipal();

            token = new UsernamePasswordAuthenticationToken(ud.getUsername(), AuthenticationTest.testExternalPassword, getGrantedAuthorities());
        } else {
            
            log.debug("principal is an unknown class: " + auth.getPrincipal().getClass().getName());
            return null;
        }

        log.debug("Setting authentication to: " + token);

        return token;

    }

    public boolean supports(Class arg0) {
        return true;
    }

    public GrantedAuthority[] getGrantedAuthorities() {
        return grantedAuthorities;
    }

    public void setGrantedAuthorities(GrantedAuthority[] grantedAuthorities) {
        this.grantedAuthorities = grantedAuthorities;
    }

}

