/*
 * Copyright (C) 2005 - 2007 JasperSoft Corporation.  All rights reserved.
 * http://www.jaspersoft.com.
 *
 * Unless you have purchased a commercial license agreement from JasperSoft,
 * the following license terms apply:
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as published by
 * the Free Software Foundation.
 *
 * This program is distributed WITHOUT ANY WARRANTY; and without the
 * implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see http://www.gnu.org/licenses/gpl.txt
 * or write to:
 *
 * Free Software Foundation, Inc.,
 * 59 Temple Place - Suite 330,
 * Boston, MA  USA  02111-1307
 */
package com.jaspersoft.jasperserver.api.metadata.view.service.impl;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Properties;

import org.springframework.test.AbstractDependencyInjectionSpringContextTests;

import com.jaspersoft.jasperserver.api.metadata.common.domain.ContentResource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.DataContainer;
import com.jaspersoft.jasperserver.api.metadata.common.domain.FileBufferedDataContainer;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Folder;
import com.jaspersoft.jasperserver.api.metadata.common.domain.client.FolderImpl;
import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryService;

public class ContentRepositoryTest extends AbstractDependencyInjectionSpringContextTests
{
	private Properties jdbcProps;
	private RepositoryService repositoryService;

	public ContentRepositoryTest(String name) {
		super(name);
		setAutowireMode(AUTOWIRE_BY_NAME);
	}
	
    public RepositoryService getRepositoryService() {
		return repositoryService;
	}

	public void setRepositoryService(RepositoryService repositoryService) {
		this.repositoryService = repositoryService;
	}

	protected String[] getConfigLocations() {
		try {
			loadJdbcProps();
		} catch (Exception e) {
			throw new RuntimeException(e);
		}

		// metadata.additionalSettings=hibernateRepositoryAdditionalSettings.xml

		if (jdbcProps.getProperty("metadata.additionalSettings") == null) {
			return
					new String[]{"hibernateConfig.xml", "viewService.xml", "userAuthorityService.xml"};
		} else {
			return
					new String[]{"hibernateConfig.xml", jdbcProps.getProperty("metadata.additionalSettings"), "viewService.xml", "userAuthorityService.xml"};
		}
    }

	protected Properties loadJdbcProps() throws IOException, FileNotFoundException {
		jdbcProps = new Properties();
		String jdbcPropFile = System.getProperty("test.hibernate.jdbc.properties");
		BufferedInputStream is = new BufferedInputStream(new FileInputStream(jdbcPropFile));
		jdbcProps.load(is);
		is.close();
		return jdbcProps;
	}

	public void testFolder()
	{
		Folder dsFolder = new FolderImpl();
		dsFolder.setName("ContentFiles");
		dsFolder.setLabel("Content files");
		dsFolder.setDescription("Content files generated by reports");
		repositoryService.saveFolder(null, dsFolder);

		Folder newFolder = new FolderImpl();
		newFolder.setParentFolder(dsFolder);
		newFolder.setName("html");
		newFolder.setLabel("html");
		repositoryService.saveFolder(null, newFolder);

		newFolder = new FolderImpl();
		newFolder.setParentFolder(dsFolder);
		newFolder.setName("pdf");
		newFolder.setLabel("pdf");
		repositoryService.saveFolder(null, newFolder);

		newFolder = new FolderImpl();
		newFolder.setParentFolder(dsFolder);
		newFolder.setName("xls");
		newFolder.setLabel("xls");
		repositoryService.saveFolder(null, newFolder);

	}

	public void testFiles() throws Exception
	{
		ContentResource fileResource = (ContentResource) repositoryService.newResource(null, ContentResource.class);
		fileResource.setName("PdfTestFile");
		fileResource.setLabel("Pdf test file");
		fileResource.setParentFolder("/ContentFiles/pdf");
		InputStream file  = getClass().getResourceAsStream("/FontsReport.pdf");

        // Test the dataContainer used by scheduling - There was a problem with this under DB2
        // This is a small file, so it will fit all in mempory

         fileResource.setDataContainer(createFileDataContainer(file));
		//fileResource.readData(file);

		fileResource.setFileType(ContentResource.TYPE_PDF);
		repositoryService.saveResource(null, fileResource);


		ContentResource htmlFile = (ContentResource) repositoryService.newResource(null, ContentResource.class);;
		htmlFile.setName("HtmlTestFile");
		htmlFile.setLabel("HTML test file with images");
		htmlFile.setParentFolder("/ContentFiles/html");
		file  = getClass().getResourceAsStream("/FirstJasper.html");

        // This is a large file, so it will be in both memory and on the file system

        htmlFile.setDataContainer(createFileDataContainer(file));
		//htmlFile.readData(file);
		htmlFile.setFileType(ContentResource.TYPE_HTML);

		ArrayList images = new ArrayList();

		ContentResource image = (ContentResource) repositoryService.newResource(null, ContentResource.class);;
		image.setName("img_0_0_1");
		image.setLabel("img_0_0_1");
		file  = getClass().getResourceAsStream("/FirstJasper.html_files/img_0_0_1");

		// ContentResource.readData stores the data only in memory

		image.readData(file);
		image.setFileType(ContentResource.TYPE_HTML);
		images.add(image);

		image = (ContentResource) repositoryService.newResource(null, ContentResource.class);
		image.setName("img_0_7_125");
		image.setLabel("img_0_7_125");
		file  = getClass().getResourceAsStream("/FirstJasper.html_files/img_0_7_125");
		image.readData(file);
		image.setFileType(ContentResource.TYPE_HTML);
		images.add(image);

		image = (ContentResource) repositoryService.newResource(null, ContentResource.class);;
		image.setName("px");
		image.setLabel("px");
		file  = getClass().getResourceAsStream("/FirstJasper.html_files/px");
		image.readData(file);
		image.setFileType(ContentResource.TYPE_HTML);
		images.add(image);

		htmlFile.setResources(images);
		repositoryService.saveResource(null, htmlFile);


		htmlFile = (ContentResource) repositoryService.newResource(null, ContentResource.class);;
		htmlFile.setName("Test");
		htmlFile.setLabel("HTML test file with one image");
		htmlFile.setParentFolder("/ContentFiles/html");
		file  = getClass().getResourceAsStream("/Test.html");
		htmlFile.readData(file);
		htmlFile.setFileType(ContentResource.TYPE_HTML);

		image = (ContentResource) repositoryService.newResource(null, ContentResource.class);;
		image.setName("image0");
		image.setLabel("image0");
		file  = getClass().getResourceAsStream("/Test.html_files/image0");
		image.readData(file);
		image.setFileType(ContentResource.TYPE_HTML);
		images = new ArrayList();
		images.add(image);

		htmlFile.setResources(images);
		repositoryService.saveResource(null, htmlFile);
	}

	private DataContainer createFileDataContainer(InputStream file) throws Exception {
		DataContainer dataContainer = new FileBufferedDataContainer();
		OutputStream os = dataContainer.getOutputStream();

		byte[] buf = new byte[4000];
		try {
			for (;;) {
				int dataSize = file.read(buf);

				if (dataSize == -1) {
					break;
				}
				os.write(buf, 0, dataSize);
			}
		} finally {
			if (file != null) {
				try {
					file.close();
					os.close();
				} catch (IOException ex) {
				}
			}
		}

		return dataContainer;
	}
}
