/*
 * Copyright (C) 2005 - 2007 JasperSoft Corporation.  All rights reserved.
 * http://www.jaspersoft.com.
 *
 * Unless you have purchased a commercial license agreement from JasperSoft,
 * the following license terms apply:
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as published by
 * the Free Software Foundation.
 *
 * This program is distributed WITHOUT ANY WARRANTY; and without the
 * implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see http://www.gnu.org/licenses/gpl.txt
 * or write to:
 *
 * Free Software Foundation, Inc.,
 * 59 Temple Place - Suite 330,
 * Boston, MA  USA  02111-1307
 */
package com.jaspersoft.jasperserver.war;

/**
 * Contains the username and password used to log in
 * Also contains the initial url as base usl used by all the pages
 **/
public class JasperServerConstants {

    /* changed from an interface to a singleton class so it can be overridden 
       for builds that layer on top of OS that want to reuse remote-tests */

    private static JasperServerConstants mConstants;
    private JasperServerConstants() {}

    public static JasperServerConstants instance() {
	if (mConstants == null) {
	    mConstants = new JasperServerConstants();
	}
	return mConstants;
    }
    
    public String USERNAME      = "jasperadmin";
    public String PASSWORD      = "jasperadmin";
    public String BASE_URL      = "http://localhost:8080";
    public String XMLA_URL      = BASE_URL + "/jasperserver/xmla";
    public String HOME_PAGE_URL = BASE_URL + "/jasperserver/home.html";
    public String WS_END_POINT_URL = BASE_URL + "/jasperserver/services/repository";
    public String WS_SCHEDULING_END_POINT_URL = BASE_URL + "/jasperserver/services/ReportScheduler";
   
    public String USERNAME2     = "joeuser";
    public String PASSWORD2  = "joeuser";
    public String BAD_PASSWORD2  = "wrongPassword";
}
