/*
 * Copyright (C) 2005 - 2007 JasperSoft Corporation.  All rights reserved.
 * http://www.jaspersoft.com.
 *
 * Unless you have purchased a commercial license agreement from JasperSoft,
 * the following license terms apply:
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as published by
 * the Free Software Foundation.
 *
 * This program is distributed WITHOUT ANY WARRANTY; and without the
 * implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see http://www.gnu.org/licenses/gpl.txt
 * or write to:
 *
 * Free Software Foundation, Inc.,
 * 59 Temple Place - Suite 330,
 * Boston, MA  USA  02111-1307
 */
package com.jaspersoft.jasperserver.api.metadata.user.service;

import java.util.List;
import java.util.Set;

import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.metadata.user.domain.Role;
import com.jaspersoft.jasperserver.api.metadata.user.domain.User;
import com.jaspersoft.jasperserver.api.metadata.view.domain.FilterCriteria;

/**
 * @author swood
 * @version $Id: UserAuthorityService.java 15013 2009-02-06 10:45:28Z sergey.prilukin $
 */
public interface UserAuthorityService {
	public User getUser(ExecutionContext context, String username);
	public void putUser(ExecutionContext context, User aUser);
	public List getUsers(ExecutionContext context, FilterCriteria filterCriteria);
	public User newUser(ExecutionContext context);
	public void deleteUser(ExecutionContext context, String username);
	public boolean userExists(ExecutionContext context, String username);
	
	public boolean disableUser(ExecutionContext context, String username);
	public boolean enableUser(ExecutionContext context, String username);
	public void addRole(ExecutionContext context, User aUser, Role role);
	public void removeRole(ExecutionContext context, User aUser, Role role);
	public void removeAllRoles(ExecutionContext context, User aUser);
	
	public Role getRole(ExecutionContext context, String roleName);
	public void putRole(ExecutionContext context, Role aRole);
	public List getRoles(ExecutionContext context, FilterCriteria filterCriteria);
	public Role newRole(ExecutionContext context);
	public void deleteRole(ExecutionContext context, String roleName);
	public List getUsersNotInRole(ExecutionContext context, String roleName);
	public List getUsersInRole(ExecutionContext context, String roleName);
	public List getAssignedRoles(ExecutionContext context, String userName);
	public List getAvailableRoles(ExecutionContext context, String userName);
	public boolean roleExists(ExecutionContext context, String roleName);
	public boolean isPasswordExpired(ExecutionContext context, String username, int nDate);
	public void resetPasswordExpiration(ExecutionContext context, String username);
	
    public void updateUser(ExecutionContext context, String userName, User aUser);
    public void updateRole(ExecutionContext context, String roleName, Role roleDetails);
	public String getTenantId(ExecutionContext context, String userName);
    public List getTenantUsers(ExecutionContext context, Set tenantIds, String name);
    public List getTenantUsers(ExecutionContext context, Set tenantIds, String name, int firstResult, int maxResults);
    public List getTenantRoles(ExecutionContext context, Set tenantIds, String name);
    public List getTenantRoles(ExecutionContext context, Set tenantIds, String name, int firstResult, int maxResults);
    public int getTenantUsersCount(ExecutionContext context, Set tenantIds, String name);
    public int getTenantRolesCount(ExecutionContext context, Set tenantIds, String name);
    public List getTenantVisibleRoles(ExecutionContext context, Set tenantIds, String name, int firstResult, int maxResults);
    public int getTenantVisibleRolesCount(ExecutionContext context, Set tenantIds, String name);
    public List getAvailableRoles(ExecutionContext context, String roleName, Set userRoles, String userName,
                                  int firstResult, int maxResults);
    public int getAvailableRolesCount(ExecutionContext context, String roleName, Set userRoles, String userName);

    public List getUsersWithoutRole(ExecutionContext context, String roleName, String userName,
                                    int firstResult, int maxResults);
    public int getUsersCountWithoutRole(ExecutionContext context, String roleName, String userName);
    public List getUsersWithRole(ExecutionContext context, String roleName, String userName,
                                 int firstResult, int maxResults);
    public int getUsersCountWithRole(ExecutionContext context, String roleName, String userName);

    public void assignUsers(ExecutionContext context, String roleName, Set userNames);

    public void unassignUsers(ExecutionContext context, String roleName, Set userNames);

}
