/*
 * Copyright (C) 2006 JasperSoft http://www.jaspersoft.com
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed WITHOUT ANY WARRANTY; and without the 
 * implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see http://www.gnu.org/licenses/gpl.txt 
 * or write to:
 * 
 * Free Software Foundation, Inc.,
 * 59 Temple Place - Suite 330,
 * Boston, MA  USA  02111-1307
 */

package com.jaspersoft.jasperserver.api.metadata.user.service;

import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.metadata.user.domain.Tenant;
import java.util.List;

/**
 * @author achan
 *
 */
public interface TenantService {
	
	public static final String ORGANIZATIONS = "organizations";
	public static final String ORG_TEMPLATE = "org_template";

	public void putTenant(ExecutionContext context, Tenant aTenant);
	
	public Tenant getTenant(ExecutionContext context, String tenantId);
	
	public List getSubTenantList(ExecutionContext context, Tenant parentTenant);
	
	public List getSubTenantList(ExecutionContext context, String parnentTenantId);
	
	public void deleteTenant(ExecutionContext context, String tenantId);
	
	public void updateTenant(ExecutionContext context, Tenant aTenant);
	
	public List getAllSubTenantList(ExecutionContext context, String parentTenantId);
	
	public int getNumberOfTenants(ExecutionContext context);
	
	public Tenant getDefaultTenant(ExecutionContext context);
	
	public Tenant getTenantBasedOnTenantUri(ExecutionContext context, String tenantUri);
	
	public Tenant getTenantBasedOnRepositoryUri(ExecutionContext context, String uri);
	
	public String getUserOrgIdDelimiter();

	public void setUserOrgIdDelimiter(String userOrgIdDelimiter);
	
	public boolean isMultiTenantEnvironment(ExecutionContext context);

    public String getUniqueTenantId(String proposedTenantId);
	
}
