package com.jaspersoft.jasperserver.api.metadata.user.service;

import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.metadata.common.service.PaginatedOperationResult;
import com.jaspersoft.jasperserver.api.metadata.user.domain.Role;

import java.util.List;
import java.util.Set;

/**
 */
public interface RoleManagerService {

    public PaginatedOperationResult getUsersWithoutRole(ExecutionContext context, String roleName, String userName,
                                    Set assignedUserNameSet, Set unassignedUserNameSet,
                                    int firstResult, int maxResults);

    public PaginatedOperationResult getUsersWithRole(ExecutionContext context, String roleName, String userName,
                                 Set assignedUserNameSet, Set unassignedUserNameSet,
                                 int firstResult, int maxResults);

    public void updateRole(ExecutionContext context, String roleName, Role roleDetails,
                                 Set assignedUserNameSet, Set unassignedUserNameSet);
}
