/*
 * Copyright (C) 2005 - 2007 JasperSoft Corporation.  All rights reserved.
 * http://www.jaspersoft.com.
 *
 * Unless you have purchased a commercial license agreement from JasperSoft,
 * the following license terms apply:
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as published by
 * the Free Software Foundation.
 *
 * This program is distributed WITHOUT ANY WARRANTY; and without the
 * implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see http://www.gnu.org/licenses/gpl.txt
 * or write to:
 *
 * Free Software Foundation, Inc.,
 * 59 Temple Place - Suite 330,
 * Boston, MA  USA  02111-1307
 */
package com.jaspersoft.jasperserver.api.metadata.user.domain;

import java.util.Set;

import com.jaspersoft.jasperserver.api.common.domain.AttributedObject;

/**
 * @author swood
 * @version $Id: Role.java 14829 2008-12-23 16:27:34Z lucian $
 */
public interface Role extends AttributedObject, TenantQualified {
	
	public String getRoleName();
	public void setRoleName(String roleName);
	
	public Set getUsers();
	//public void setUsers(Set userList);
	
	public boolean isExternallyDefined();
	public void setExternallyDefined(boolean isExternallyDefined);
	
	public void addUser(User aUser);
	public void removeUser(User aUser);

}
