/*
 * Copyright (C) 2006 JasperSoft http://www.jaspersoft.com
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed WITHOUT ANY WARRANTY; and without the 
 * implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see http://www.gnu.org/licenses/gpl.txt 
 * or write to:
 * 
 * Free Software Foundation, Inc.,
 * 59 Temple Place - Suite 330,
 * Boston, MA  USA  02111-1307
 */

package com.jaspersoft.jasperserver.api.metadata.user.domain.impl.client;

import java.io.Serializable;

/**
 * @author Lucian Chirita (lucianc@users.sourceforge.net)
 * @version $Id: SimpleTenantQualifiedPrincipal.java 14865 2009-01-08 15:26:56Z lucian $
 */
public class SimpleTenantQualifiedPrincipal implements TenantQualifiedPrincipal, Serializable {

	private static final long serialVersionUID = 1L;

	private final String name;
	private final String tenantId;

	public SimpleTenantQualifiedPrincipal(String name, String tenantId) {
		this.name = name;
		this.tenantId = tenantId;
	}
	
	public String getName() {
		return name;
	}

	public String getTenantId() {
		return tenantId;
	}
	
	public boolean equals(Object o) {
		if (!(o instanceof SimpleTenantQualifiedPrincipal)) {
			return false;
		}
		
		if (o == this) {
			return true;
		}
		
		SimpleTenantQualifiedPrincipal p = (SimpleTenantQualifiedPrincipal) o;
		return name.equals(p.name)
			&& (tenantId == null ? p.tenantId == null : (tenantId.equals(p.tenantId)));
	}
	
	public int hashCode() {
		return 37 * name.hashCode() 
			+ (tenantId == null ? 0 : tenantId.hashCode());
	}
	
	public String toString() {
		return name + (tenantId == null ? "" : ("|" + tenantId));
	}

}
