/*
 * Copyright (C) 2005 - 2007 JasperSoft Corporation.  All rights reserved.
 * http://www.jaspersoft.com.
 *
 * Unless you have purchased a commercial license agreement from JasperSoft,
 * the following license terms apply:
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as published by
 * the Free Software Foundation.
 *
 * This program is distributed WITHOUT ANY WARRANTY; and without the
 * implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see http://www.gnu.org/licenses/gpl.txt
 * or write to:
 *
 * Free Software Foundation, Inc.,
 * 59 Temple Place - Suite 330,
 * Boston, MA  USA  02111-1307
 */
package com.jaspersoft.jasperserver.api.metadata.olap.service.impl;

import java.util.Map;

import net.sf.jasperreports.olap.xmla.JRXmlaQueryExecuterFactory;

import com.jaspersoft.jasperserver.api.metadata.jasperreports.service.ReportDataSourceService;
import com.jaspersoft.jasperserver.api.metadata.olap.domain.XMLAConnection;
import com.jaspersoft.jasperserver.api.metadata.user.domain.User;

/**
 * @author Lucian Chirita (lucianc@users.sourceforge.net)
 * @version $Id: XmlaConnectionDataSourceService.java 14857 2009-01-03 02:38:16Z asokolnikov $
 */
public class XmlaConnectionDataSourceService implements ReportDataSourceService {
    
	private final XMLAConnection xmlaConnection;
	private final String tenantSeparator;
	private final User contextUser;
	
	public XmlaConnectionDataSourceService(XMLAConnection xmlaConnection, String tenantSeparator) {
		this(xmlaConnection, tenantSeparator, null);
	}
	
	public XmlaConnectionDataSourceService(XMLAConnection xmlaConnection, String tenantSeparator,
			User contextUser) {
		this.xmlaConnection = xmlaConnection;
		this.tenantSeparator = tenantSeparator;
		this.contextUser = contextUser;
	}

	public void setReportParameterValues(Map parameterValues) {
		parameterValues.put(JRXmlaQueryExecuterFactory.PARAMETER_XMLA_URL, xmlaConnection.getURI());
		parameterValues.put(JRXmlaQueryExecuterFactory.PARAMETER_XMLA_CATALOG, xmlaConnection.getCatalog());
        String dataSource = xmlaConnection.getDataSource();
        
        String uName = null;
        String uPass = null;
		if (contextUser == null) {
			uName = xmlaConnection.getUsername();
			uPass = xmlaConnection.getPassword();
		} else {
			uName = contextUser.getUsername();
			if (contextUser.getTenantId() != null) {
				uName += tenantSeparator + contextUser.getTenantId();
			}
			uPass = contextUser.getPassword();
		}
        
		parameterValues.put(JRXmlaQueryExecuterFactory.PARAMETER_XMLA_USER, uName);
		parameterValues.put(JRXmlaQueryExecuterFactory.PARAMETER_XMLA_PASSWORD, uPass);
		parameterValues.put(JRXmlaQueryExecuterFactory.PARAMETER_XMLA_DATASOURCE, dataSource);
	}

	public void closeConnection() {
	}

}
