package com.jaspersoft.jasperserver.api.metadata.common.service.impl;

import com.jaspersoft.jasperserver.api.metadata.common.service.PaginatedOperationResult;

import java.util.List;

/**
 *
 */
public class PaginationHelper {

    static public PaginatedOperationResult paginatedGetOperationResult(int firstResult, int maxResults, JasperService service) {

        int resultCount = service.getResultCount();
        int currentFirstResult = firstResult;

        if (resultCount > 0 && firstResult >= resultCount) {

            currentFirstResult = resultCount - maxResults;
            currentFirstResult = (currentFirstResult > -1) ? currentFirstResult : 0;
        }

        List result = service.getResultList(currentFirstResult, maxResults);

        return new PaginatedOperationResult(result, currentFirstResult, maxResults, resultCount);
    }

    public interface JasperService {

        public List getResultList(int firstResult, int maxResults);

        public int getResultCount();
    }

}
