/*
 * Copyright (C) 2006 JasperSoft http://www.jaspersoft.com
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed WITHOUT ANY WARRANTY; and without the 
 * implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see http://www.gnu.org/licenses/gpl.txt 
 * or write to:
 * 
 * Free Software Foundation, Inc.,
 * 59 Temple Place - Suite 330,
 * Boston, MA  USA  02111-1307
 */

package com.jaspersoft.jasperserver.api.engine.jasperreports.service.impl;

import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.metadata.common.domain.FileResource;
import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryCacheableItem;

/**
 * @author Lucian Chirita (lucianc@users.sourceforge.net)
 * @version $Id: CacheableCompiledReports.java 14686 2008-11-21 18:31:49Z lucian $
 */
public class CacheableCompiledReports implements RepositoryCacheableItem {

	private static final String CACHE_NAME = "JasperReport";

	private InternalReportCompiler compiler;
	
	public CacheableCompiledReports() {
	}
	
	public CacheableCompiledReports(InternalReportCompiler compiler) {
		this.compiler = compiler;
	}
	
	public InternalReportCompiler getCompiler() {
		return compiler;
	}

	public void setCompiler(InternalReportCompiler compiler) {
		this.compiler = compiler;
	}

	public String getCacheName() {
		return CACHE_NAME;
	}

	public byte[] getData(ExecutionContext context, FileResource resource) {
		return compiler.compileReport(context, resource);
	}

}
