/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.tbutils.res;

import com.tonbeller.tbutils.res.BundleResourceProvider;
import com.tonbeller.tbutils.res.CompositeResourceProvider;
import com.tonbeller.tbutils.res.JNDIInitialProvider;
import com.tonbeller.tbutils.res.PropertyResourceProvider;
import com.tonbeller.tbutils.res.ReplacingResourceProvider;
import com.tonbeller.tbutils.res.ResourceProvider;
import com.tonbeller.tbutils.res.Resources;
import com.tonbeller.tbutils.res.SimpleInitialProvider;
import com.tonbeller.tbutils.res.SystemResourceProvider;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class ResourcesFactory {
    public static final String INITIAL_PROVIDER = "tbeller.InitialResourceProvider";
    public static final String USE_JNDI_PROVIDER = "tbeller.usejndi";
    public static final String TBELLER_BUNDLES = "tbeller.bundles";
    public static final String TBELLER_PROPERTIES = "tbeller.properties";
    public static final String TBELLER_HOME = "tbeller.home";
    public static final String TBELLER_LOCALE = "tbeller.locale";
    private static Logger logger = Logger.getLogger((Class)ResourcesFactory.class);
    Map locale2providerMap = new HashMap();
    File homeDir;
    Locale fixedLocale;
    String[] properties;
    String[] bundles;
    static ResourcesFactory instance = new ResourcesFactory();

    private ResourcesFactory() {
        this.initialize();
    }

    public static ResourcesFactory instance() {
        return instance;
    }

    Resources getResources(Locale requestLocale, String bundleName) {
        Locale locale = this.fixedLocale;
        if (locale == null) {
            locale = requestLocale;
        }
        if (locale == null) {
            locale = Locale.getDefault();
        }
        CompositeResourceProvider crp = new CompositeResourceProvider();
        ResourceProvider baseProvider = this.getProvider(locale);
        crp.add(baseProvider);
        ResourceProvider bundleProvider = ResourcesFactory.getProvider(locale, bundleName);
        if (bundleProvider != null) {
            crp.add(bundleProvider);
        }
        return new Resources(crp, locale, this.homeDir);
    }

    public Locale getFixedLocale() {
        return this.fixedLocale;
    }

    static ResourceProvider getProvider(Locale locale, String bundleName) {
        if (bundleName == null) {
            return null;
        }
        try {
            ResourceBundle resb = ResourceBundle.getBundle(bundleName, locale);
            return new BundleResourceProvider(bundleName, resb);
        }
        catch (MissingResourceException e) {
            return null;
        }
    }

    ResourceProvider getProvider(Locale locale) {
        String key = locale.getLanguage() + locale.getCountry() + locale.getVariant();
        ResourceProvider p = (ResourceProvider)this.locale2providerMap.get(key);
        if (p != null) {
            return p;
        }
        p = this.createProvider(locale);
        this.locale2providerMap.put(key, p);
        return p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initialize() {
        ResourceProvider p = this.getInitialProvider();
        try {
            this.initialize(p);
        }
        finally {
            p.close();
        }
    }

    private ResourceProvider getInitialProvider() {
        SimpleInitialProvider m = new SimpleInitialProvider();
        String clazz = m.getString(INITIAL_PROVIDER);
        if (clazz != null) {
            try {
                return (ResourceProvider)Class.forName(clazz).newInstance();
            }
            catch (Exception e) {
                logger.error((Object)("could not instantiate " + clazz), (Throwable)e);
            }
        }
        if ("false".equals(m.getString(USE_JNDI_PROVIDER))) {
            return new SimpleInitialProvider();
        }
        return new JNDIInitialProvider();
    }

    void initialize(ResourceProvider resp) {
        this.locale2providerMap.clear();
        ReplacingResourceProvider p = new ReplacingResourceProvider(resp);
        this.bundles = this.tokenize(p.getString(TBELLER_BUNDLES));
        CompositeResourceProvider c = new CompositeResourceProvider();
        c.add(p);
        this.addBundleProviders(Locale.getDefault(), c);
        p = new ReplacingResourceProvider(c);
        this.initHome(p);
        this.initLocale(p);
        this.properties = this.tokenize(p.getString(TBELLER_PROPERTIES));
    }

    String[] tokenize(String s) {
        if (s == null) {
            return new String[0];
        }
        StringTokenizer st = new StringTokenizer(s);
        String[] a = new String[st.countTokens()];
        for (int i = 0; i < a.length; ++i) {
            a[i] = st.nextToken();
        }
        return a;
    }

    CompositeResourceProvider createProvider(Locale locale) {
        CompositeResourceProvider c = new CompositeResourceProvider();
        c.add(new SystemResourceProvider());
        this.addPropertyProviders(locale, c);
        this.addBundleProviders(locale, c);
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addPropertyProviders(Locale locale, CompositeResourceProvider c) {
        for (int i = 0; i < this.properties.length; ++i) {
            File f = this.propertyFile(this.properties[i], locale);
            Properties props = new Properties();
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(f);
                props.load(fis);
                c.add(new PropertyResourceProvider(f.getCanonicalPath(), props));
                continue;
            }
            catch (FileNotFoundException e) {
                if (!logger.isInfoEnabled()) continue;
                logger.info((Object)("optional property file not found: " + f.getAbsolutePath()));
                continue;
            }
            catch (IOException e) {
                logger.error((Object)("error loading " + f.getAbsolutePath()), (Throwable)e);
                continue;
            }
            finally {
                try {
                    if (fis != null) {
                        fis.close();
                    }
                }
                catch (IOException e2) {
                    logger.error((Object)("error closing " + f.getAbsolutePath()), (Throwable)e2);
                }
            }
        }
    }

    File propertyFile(String propertyName, Locale locale) {
        File f = new File(propertyName);
        String fn = f.isAbsolute() ? f.getAbsolutePath() : this.homeDir.getAbsolutePath() + File.separator + propertyName;
        return this.findFile(fn, locale);
    }

    private void addBundleProviders(Locale locale, CompositeResourceProvider c) {
        for (int i = 0; i < this.bundles.length; ++i) {
            try {
                ResourceBundle rb = ResourceBundle.getBundle(this.bundles[i], locale);
                c.add(new BundleResourceProvider(this.bundles[i], rb));
                continue;
            }
            catch (MissingResourceException e) {
                if (!logger.isInfoEnabled()) continue;
                logger.info((Object)("optional resource bundle not found: " + this.bundles[i]));
            }
        }
    }

    File findFile(String path, Locale locale) {
        File f;
        String ext = "";
        int pos = path.lastIndexOf(46);
        if (pos >= 0) {
            ext = path.substring(pos, path.length());
        }
        if ((f = new File((path = path.substring(0, pos)) + "_" + locale.getLanguage() + "_" + locale.getCountry() + ext)).exists()) {
            return f;
        }
        f = new File(path + "_" + locale.getLanguage() + ext);
        if (f.exists()) {
            return f;
        }
        return new File(path + ext);
    }

    void initHome(ResourceProvider p) {
        String dir = p.getString(TBELLER_HOME);
        if (dir == null || dir.trim().length() == 0) {
            dir = System.getProperty("user.home") + File.separator + ".tonbeller";
        }
        this.homeDir = new File(dir);
        this.homeDir.mkdirs();
    }

    void initLocale(ResourceProvider p) {
        this.fixedLocale = null;
        String lang = p.getString(TBELLER_LOCALE);
        if (lang != null) {
            if ((lang = lang.trim()).length() == 2) {
                this.fixedLocale = new Locale(lang, lang.toUpperCase());
            } else if (lang.length() == 5) {
                String l = lang.substring(0, 2);
                String c = lang.substring(3, 5);
                this.fixedLocale = new Locale(l, c);
            } else if ("browser".equals(lang)) {
                // empty if block
            }
        }
    }
}

