/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.jpivot.table;

import com.tonbeller.jpivot.mondrian.MondrianHierarchy;
import com.tonbeller.jpivot.mondrian.MondrianLevel;
import com.tonbeller.jpivot.olap.model.Axis;
import com.tonbeller.jpivot.olap.model.Displayable;
import com.tonbeller.jpivot.olap.model.Hierarchy;
import com.tonbeller.jpivot.olap.model.Level;
import com.tonbeller.jpivot.table.AxisBuilderSupport;
import com.tonbeller.jpivot.table.RowAxisBuilder;
import com.tonbeller.jpivot.table.RowAxisConfig;
import com.tonbeller.jpivot.table.SpanBuilderImpl;
import com.tonbeller.jpivot.table.span.HierarchyHeaderFactory;
import com.tonbeller.jpivot.table.span.IgnorePropertiesHierarchyHeaderFactory;
import com.tonbeller.jpivot.table.span.LevelHeaderFactory;
import com.tonbeller.jpivot.table.span.PropertyHeading;
import com.tonbeller.jpivot.table.span.Span;
import com.tonbeller.jpivot.table.span.SpanCalc;
import com.tonbeller.jpivot.xmla.XMLA_Hierarchy;
import com.tonbeller.jpivot.xmla.XMLA_Level;
import com.tonbeller.tbutils.res.Resources;
import mondrian.olap.HierarchyBase;
import mondrian.rolap.RolapLevel;
import org.apache.log4j.Logger;
import org.w3c.dom.Element;

public class RowAxisBuilderImpl
extends AxisBuilderSupport
implements RowAxisBuilder,
RowAxisConfig {
    int positionHeader;
    SpanCalc headerSpans;
    private static final Logger logger = Logger.getLogger(RowAxisBuilderImpl.class);

    public RowAxisBuilderImpl() {
        super(new SpanBuilderImpl("row-heading", "heading-heading"));
        this.setMemberIndent(true);
        this.setShowParentMembers(false);
        this.setHierarchyHeader(0);
        this.setMemberSpan(3);
        this.setHeaderSpan(3);
        this.setPositionHeader(1);
    }

    public void buildRow(Element parent, int rowIndex) {
        boolean even = rowIndex % 2 == 0;
        for (int i = 0; i < this.spanCalc.getHierarchyCount(); ++i) {
            Span span = this.spanCalc.getSpan(rowIndex, i);
            if (!span.isSignificant()) continue;
            int rowspan = span.getPositionSpan();
            int colspan = span.getHierarchySpan();
            this.buildHeading(parent, span, rowspan, colspan, even);
        }
    }

    public int getColumnCount() {
        return this.spanCalc.getHierarchyCount();
    }

    public int getRowCount() {
        return this.spanCalc.getPositionCount();
    }

    public int getPositionHeader() {
        return this.positionHeader;
    }

    public void setPositionHeader(int positionHeader) {
        this.positionHeader = positionHeader;
        this.setDirty(true);
    }

    public void buildHeaderRow(Element parent, int rowIndex) {
        boolean even = rowIndex % 2 == 0;
        for (int i = 0; i < this.headerSpans.getHierarchyCount(); ++i) {
            Span span = this.headerSpans.getSpan(rowIndex, i);
            if (logger.isInfoEnabled()) {
                logger.info((Object)("building header row: " + span));
            }
            if (!span.isSignificant()) continue;
            int rowspan = span.getPositionSpan();
            int colspan = span.getHierarchySpan();
            this.buildHeading(parent, span, rowspan, colspan, even);
        }
    }

    public int getHeaderRowCount() {
        if (this.headerSpans == null) {
            return 0;
        }
        return this.headerSpans.getPositionCount();
    }

    public SpanCalc getHeaderSpanCalc() {
        return this.headerSpans;
    }

    public void initialize(Axis axis) {
        super.initialize(axis);
        switch (this.positionHeader) {
            case 3: {
                logger.info((Object)"HIERARCHY_LEVEL_HEADER");
                SpanCalc sc1 = this.spanCalc.createPositionHeader(new IgnorePropertiesHierarchyHeaderFactory());
                SpanCalc sc2 = this.spanCalc.createPositionHeader(new LevelHeaderFactory());
                this.headerSpans = this.getAllHeader(sc1, sc2);
                break;
            }
            case 2: {
                logger.info((Object)"LEVEL_HEADER");
                this.headerSpans = this.spanCalc.createPositionHeader(new LevelHeaderFactory());
                break;
            }
            case 1: {
                logger.info((Object)"HIERARCHY_HEADER");
                this.headerSpans = this.spanCalc.createPositionHeader(new HierarchyHeaderFactory());
                break;
            }
            default: {
                this.headerSpans = null;
            }
        }
        if (this.headerSpans != null) {
            this.headerSpans.setConfig(this.spanCalc.getConfig());
        }
    }

    private SpanCalc getAllHeader(SpanCalc sc1, SpanCalc sc2) {
        Span[][] hierSpans = null;
        if (sc1 != null) {
            hierSpans = sc1.getSpans();
        }
        Span[][] levelSpans = null;
        if (sc2 != null) {
            levelSpans = sc2.getSpans();
        }
        if (hierSpans != null && levelSpans != null) {
            for (int i = 0; i < hierSpans.length; ++i) {
                Span[] hierSpans1 = hierSpans[i];
                Span[] levelSpans1 = levelSpans[i];
                if (hierSpans1 == null || levelSpans1 == null) continue;
                for (int j = 0; j < hierSpans1.length && hierSpans1[j] != null; ++j) {
                    Hierarchy hierarchy = (Hierarchy)hierSpans1[j].getObject();
                    Displayable ol = levelSpans1[j].getObject();
                    if (hierarchy == null || levelSpans1[j] == null) continue;
                    if (ol != null && ol instanceof Level) {
                        Level ml = (Level)levelSpans1[j].getObject();
                        if (ml == null) continue;
                        if (hierarchy instanceof MondrianHierarchy) {
                            HierarchyBase hierarchyBase = (HierarchyBase)((MondrianHierarchy)hierarchy).getMonHierarchy();
                            RolapLevel rl = (RolapLevel)((MondrianLevel)ml).getMonLevel();
                            if (rl == null || hierarchyBase == null || !rl.getName().equals("(All)")) continue;
                            rl.setCaption(hierarchyBase.getCaption());
                            continue;
                        }
                        if (!(hierarchy instanceof XMLA_Hierarchy)) continue;
                        XMLA_Hierarchy xh = (XMLA_Hierarchy)hierarchy;
                        if (!((XMLA_Level)ml).getName().equals(Resources.instance().getString("(All)"))) continue;
                        ((XMLA_Level)ml).setCaption(xh.getCaption());
                        continue;
                    }
                    PropertyHeading ph = (PropertyHeading)ol;
                    if (!(hierarchy instanceof MondrianHierarchy) && !(hierarchy instanceof XMLA_Hierarchy)) continue;
                }
            }
        }
        return sc2;
    }

    public void stopBuild() {
        super.stopBuild();
        this.headerSpans = null;
    }

    protected Axis getAxis() {
        return this.table.getRowAxis();
    }
}

