/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.jpivot.table;

import com.jaspersoft.jasperserver.api.JSDuplicateResourceException;
import com.jaspersoft.jasperserver.api.JSException;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Folder;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ResourceReference;
import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryService;
import com.jaspersoft.jasperserver.api.metadata.common.util.RepositoryLabelIDHelper;
import com.jaspersoft.jasperserver.api.metadata.olap.domain.client.OlapUnitImpl;
import com.jaspersoft.jasperserver.api.metadata.view.domain.FilterCriteria;
import com.jaspersoft.jasperserver.api.metadata.view.domain.FilterElement;
import com.jaspersoft.jasperserver.war.common.JasperServerUtil;
import com.jaspersoft.jasperserver.war.repository.RepositoryDataFilter;
import com.tonbeller.jpivot.core.Model;
import com.tonbeller.jpivot.mondrian.MondrianDrillThroughTableModel;
import com.tonbeller.jpivot.mondrian.MondrianModel;
import com.tonbeller.jpivot.olap.model.OlapModel;
import com.tonbeller.jpivot.olap.model.OlapModelDecorator;
import com.tonbeller.jpivot.xmla.XMLA_Model;
import com.tonbeller.tbutils.res.Resources;
import com.tonbeller.wcf.bookmarks.BookmarkManager;
import com.tonbeller.wcf.component.FormListener;
import com.tonbeller.wcf.controller.RequestContext;
import com.tonbeller.wcf.form.FormComponent;
import com.tonbeller.wcf.form.NodeHandlerSupport;
import com.tonbeller.wcf.form.XmlComponent;
import com.tonbeller.wcf.table.EditableTableComponent;
import com.tonbeller.wcf.ui.ListItem;
import com.tonbeller.wcf.ui.Select;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.acegisecurity.AccessDeniedException;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.w3c.dom.Element;

public class RepoFolderList
extends NodeHandlerSupport
implements FormListener {
    private static Logger logger = Logger.getLogger(RepoFolderList.class);

    private void filterFolders(List folders, RepositoryDataFilter folderFilter) {
        HashSet<Folder> itemsToRemove = new HashSet<Folder>();
        for (Folder f : folders) {
            if (folderFilter.filter(f.getURIString())) continue;
            itemsToRemove.add(f);
        }
        if (itemsToRemove.size() > 0) {
            folders.removeAll(itemsToRemove);
        }
    }

    public void populateFolderList(RequestContext context) {
        HttpSession session = context.getSession();
        HttpServletRequest request = context.getRequest();
        if (session == null || request == null) {
            return;
        }
        WebApplicationContext ctx = WebApplicationContextUtils.getWebApplicationContext((ServletContext)context.getServletContext());
        RepositoryService repo = (RepositoryService)ctx.getBean("repositoryServiceForAclUpdate");
        logger.debug((Object)"populateFolderList: getting repoService from repositoryServiceForAclUpdate");
        if (repo != null) {
            ArrayList folders = repo.getAllFolders(JasperServerUtil.getExecutionContext((HttpServletRequest)request));
            if (folders == null) {
                folders = new ArrayList();
            }
            try {
                RepositoryDataFilter folderFilter = (RepositoryDataFilter)ctx.getBean("jpivotRepositoryFilter");
                this.filterFolders(folders, folderFilter);
            }
            catch (NoSuchBeanDefinitionException ex) {
                // empty catch block
            }
            String selectedItem = "";
            Iterator iter = folders.iterator();
            Element list = this.getElement();
            Select.removeAllItems((Element)list);
            logger.debug((Object)"Adding folders for OLAP save as");
            while (iter.hasNext()) {
                list = this.getElement();
                String path = ((Folder)iter.next()).getURIString();
                if ((path + "/").startsWith("/adhoc/temp/")) continue;
                logger.debug((Object)("\t" + path));
                Element item = ListItem.addListItem((Element)list);
                ListItem.setId((Element)item, (String)path);
                ListItem.setValue((Element)item, (String)path);
                ListItem.setLabel((Element)item, (String)path);
                if (!"".equalsIgnoreCase(selectedItem)) continue;
                selectedItem = path;
            }
            if (folders.size() == 0) {
                Element item = ListItem.addListItem((Element)list);
                ListItem.setId((Element)item, (String)"");
                ListItem.setValue((Element)item, (String)"");
                ListItem.setLabel((Element)item, (String)"");
                selectedItem = "";
            }
            logger.debug((Object)("selected item: " + selectedItem));
            session.setAttribute("ja_saveas_selectedItem", (Object)selectedItem);
        }
    }

    public boolean validate(RequestContext context) {
        HttpSession sess = context.getRequest().getSession();
        HttpServletRequest request = context.getRequest();
        String name = context.getParameter("viewName");
        if (name == null || "".equals(name.trim())) {
            return true;
        }
        String location = context.getParameter("location");
        if (location == null || "".equals(location.trim())) {
            Resources resources = Resources.instance();
            String errMsg = resources.getResourceBundle().getMessage("JAJ_000_jsp.jpivot.toolb.saveas.emptyFolderList", null, resources.getLocaleContextHolderLocale());
            sess.setAttribute("location", (Object)errMsg);
            return false;
        }
        OlapUnitImpl existingOlapUnit = (OlapUnitImpl)context.getRequest().getSession().getAttribute("olapUnit");
        if (existingOlapUnit == null) {
            throw new JSException("No OLAP Model retrieved");
        }
        ResourceReference olapCltConn = existingOlapUnit.getOlapClientConnection();
        Object state = BookmarkManager.instance((HttpSession)context.getRequest().getSession()).collectSessionState(0);
        OlapModel olapModel = (OlapModel)context.getSession().getAttribute("olapModel");
        Model mdl = ((OlapModelDecorator)olapModel).getRootModel();
        String drillThruSQL = null;
        String currentView = (String)context.getRequest().getSession().getAttribute("currentView");
        if (mdl instanceof MondrianModel) {
            try {
                EditableTableComponent et;
                if (currentView != null && (et = (EditableTableComponent)context.getRequest().getSession().getAttribute(currentView + ".drillthroughtable")) != null) {
                    drillThruSQL = ((MondrianDrillThroughTableModel)et.getModel()).getSql();
                    ((HashMap)state).put("drillThruSQL", drillThruSQL);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        OlapUnitImpl olapUnit = new OlapUnitImpl();
        String mdxQuery = null;
        if (mdl instanceof MondrianModel) {
            try {
                mdxQuery = ((MondrianModel)mdl).getCurrentMdx();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (mdl instanceof XMLA_Model) {
            mdxQuery = ((XMLA_Model)mdl).getCurrentMdx();
        }
        olapUnit.setMdxQuery(mdxQuery);
        name = name.replaceAll("[^a-zA-Z0-9]", "_");
        olapUnit.setName(name);
        olapUnit.setLabel(context.getParameter("viewName"));
        olapUnit.setDescription(context.getParameter("description"));
        olapUnit.setOlapClientConnection(olapCltConn);
        olapUnit.setParentFolder(context.getParameter("location"));
        WebApplicationContext ctx = WebApplicationContextUtils.getWebApplicationContext((ServletContext)context.getServletContext());
        RepositoryService repository = (RepositoryService)ctx.getBean("repositoryService");
        try {
            int i;
            FilterCriteria criteria = FilterCriteria.createFilter();
            criteria.addFilterElement((FilterElement)FilterCriteria.createParentFolderFilter((String)context.getParameter("location")));
            List resourceList = repository.loadResourcesList(null, criteria);
            boolean doesInternalNameExist = false;
            for (i = 0; i < resourceList.size(); ++i) {
                String curLabel = ((Resource)resourceList.get(i)).getLabel();
                if (curLabel == null) {
                    curLabel = "";
                }
                if (curLabel.equalsIgnoreCase(context.getParameter("viewName"))) {
                    throw new IOException();
                }
                String curInternalName = ((Resource)resourceList.get(i)).getName();
                if (curInternalName == null) {
                    curInternalName = "";
                }
                if (!curInternalName.equalsIgnoreCase(name)) continue;
                doesInternalNameExist = true;
            }
            i = 0;
            String curName = RepositoryLabelIDHelper.generateIdBasedOnLabel((RepositoryService)repository, (String)context.getParameter("location"), (String)name);
            logger.debug((Object)("there you go!!!!!!!!!!!!!!!!! curName ===== " + curName));
            olapUnit.setName(curName);
            HashMap pureState = new HashMap();
            this.removeNonCurrentViewBookmark(pureState, (HashMap)state, existingOlapUnit.getPath());
            HashMap newState = new HashMap();
            this.changeHashKeyToNewPath(newState, pureState, existingOlapUnit.getPath(), curName, context.getParameter("location"));
            olapUnit.setOlapViewOptions(newState);
            olapUnit.setVersion(-1);
            repository.saveResource(null, (Resource)olapUnit);
            olapUnit.setVersion(0);
            sess.setAttribute("olapUnit", (Object)olapUnit);
            sess.setAttribute("currentView", (Object)(context.getParameter("location") + "/" + curName));
            this.revert(context);
            String fromPage = request.getHeader("Referer");
            fromPage = !fromPage.contains("?") ? fromPage + "?name=" + context.getParameter("location") + "/" + curName : fromPage + "&name=" + context.getParameter("location") + "/" + curName;
            context.getResponse().sendRedirect(fromPage);
        }
        catch (JSDuplicateResourceException e) {
            e.printStackTrace();
            return false;
        }
        catch (AccessDeniedException f) {
            Resources resources = Resources.instance();
            String errMsg = resources.getResourceBundle().getMessage("JAJ_000_jsp.jpivot.toolb.saveas.accessDenied", null, resources.getLocaleContextHolderLocale());
            sess.setAttribute("location", (Object)errMsg);
            System.out.println((Object)f);
            return false;
        }
        catch (IOException g) {
            Resources resources = Resources.instance();
            String errMsg = resources.getResourceBundle().getMessage("JAJ_000_jsp.jpivot.toolb.saveas.needNewName", null, resources.getLocaleContextHolderLocale());
            sess.setAttribute("viewName", (Object)errMsg);
            System.out.println(g);
            return false;
        }
        return true;
    }

    private void changeHashKeyToNewPath(HashMap newState, HashMap existingState, String oldName, String newName, String parentFolder) {
        Set set = existingState.keySet();
        for (String key : set) {
            Object value = existingState.get(key);
            String newKey = key.replace(oldName, parentFolder + "/" + newName);
            newState.put(newKey, value);
        }
    }

    private void removeNonCurrentViewBookmark(HashMap pureState, HashMap state, String existingPathAndObject) {
        Set set = state.keySet();
        for (String key : set) {
            if ((!key.startsWith(existingPathAndObject) || key.length() <= existingPathAndObject.length() || key.charAt(existingPathAndObject.length()) != '.' && key.charAt(existingPathAndObject.length()) != '/') && !key.equals("drillThruSQL")) continue;
            Object value = state.get(key);
            pureState.put(key, value);
        }
    }

    public void initialize(RequestContext context, XmlComponent comp, Element element) throws Exception {
        super.initialize(context, comp, element);
        comp.addFormListener((FormListener)this);
        this.populateFolderList(context);
        this.revert(context);
    }

    public void revert(RequestContext context) {
        String curView;
        HttpSession sess = context.getRequest().getSession();
        FormComponent form = (FormComponent)sess.getAttribute((curView = (String)sess.getAttribute("currentView")) + "/saveas");
        if (form != null) {
            form.setError("location", null);
            form.setError("viewName", null);
        }
    }
}

