/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.jpivot.mondrian;

import com.tonbeller.jpivot.util.TreeNode;
import com.tonbeller.jpivot.util.TreeNodeCallback;
import com.tonbeller.tbutils.res.Resources;
import java.util.ArrayList;
import java.util.List;
import mondrian.mdx.LevelExpr;
import mondrian.mdx.MemberExpr;
import mondrian.mdx.UnresolvedFunCall;
import mondrian.olap.Dimension;
import mondrian.olap.Exp;
import mondrian.olap.FunCall;
import mondrian.olap.Hierarchy;
import mondrian.olap.Level;
import mondrian.olap.Member;
import mondrian.olap.Parameter;
import mondrian.olap.Property;
import mondrian.olap.SchemaReader;
import mondrian.olap.Syntax;
import mondrian.rolap.RolapHierarchy;
import mondrian.rolap.RolapMember;

public class MondrianUtil {
    public static String expString(Exp exp) {
        String s = "";
        if (exp instanceof FunCall) {
            FunCall f = (FunCall)exp;
            String name = f.getFunName();
            s = s + "<function:" + name + ">";
            Exp[] args = f.getArgs();
            for (int i = 0; i < args.length; ++i) {
                s = s + MondrianUtil.expString(args[i]);
            }
            s = s + "</function:" + name + ">";
        } else if (exp instanceof Member) {
            Member m = (Member)exp;
            s = s + "<member>" + m.getUniqueName() + "</member>";
        } else if (exp instanceof Parameter) {
            Parameter p = (Parameter)exp;
            s = s + "<parameter>" + p.getName() + "</parameter>";
        } else if (exp instanceof Hierarchy) {
            Hierarchy h = (Hierarchy)exp;
            s = s + "<hier>" + h.getUniqueName() + "</hier>";
        } else if (exp instanceof Level) {
            Level l = (Level)exp;
            s = s + "<level>" + l.getUniqueName() + "</level>";
        } else {
            s = s + " <exp>" + exp.toString() + "</exp>";
        }
        return s;
    }

    public static boolean compareMembers(Member[] aMem1, Member[] aMem2) {
        if (aMem1.length != aMem2.length) {
            return false;
        }
        for (int i = 0; i < aMem1.length; ++i) {
            if (aMem1[i] == null) {
                return false;
            }
            if (aMem1[i].equals(aMem2[i])) continue;
            return false;
        }
        return true;
    }

    public static String memberString(Member[] mPath) {
        if (mPath == null || mPath.length == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < mPath.length; ++i) {
            if (i > 0) {
                sb.append(" ");
            }
            sb.append(mPath[i].getUniqueName());
        }
        return sb.toString();
    }

    static Exp topLevelMembers(Hierarchy monHier, boolean expandAllMember, SchemaReader scr) {
        RolapMember mona;
        if (monHier.hasAll() && (mona = ((RolapHierarchy)monHier).getAllMember()) != null) {
            if (!expandAllMember) {
                return new MemberExpr((Member)mona);
            }
            MemberExpr[] monar = new MemberExpr[]{new MemberExpr((Member)mona)};
            UnresolvedFunCall monaSet = new UnresolvedFunCall("{}", Syntax.Braces, (Exp[])monar);
            UnresolvedFunCall mAllChildren = new UnresolvedFunCall("children", Syntax.Property, (Exp[])monar);
            UnresolvedFunCall union = new UnresolvedFunCall("union", Syntax.Function, new Exp[]{monaSet, mAllChildren});
            return union;
        }
        Member[] topMembers = scr.getHierarchyRootMembers(monHier);
        if (topMembers.length == 1) {
            return new MemberExpr(topMembers[0]);
        }
        if (topMembers.length == 0) {
            return null;
        }
        ArrayList<Member> list = new ArrayList<Member>(topMembers.length);
        for (int i = 0; i < topMembers.length; ++i) {
            Member m = topMembers[i];
            if (!MondrianUtil.isVisible(scr, m)) continue;
            list.add(m);
        }
        topMembers = list.toArray(new Member[list.size()]);
        return new UnresolvedFunCall("{}", Syntax.Braces, (Exp[])MondrianUtil.toExprArray(topMembers));
    }

    static MemberExpr[] toExprArray(Member[] members) {
        MemberExpr[] memberExprs = new MemberExpr[members.length];
        for (int i = 0; i < memberExprs.length; ++i) {
            memberExprs[i] = new MemberExpr(members[i]);
        }
        return memberExprs;
    }

    public static Member[] getMemberDescendants(SchemaReader scr, Member member, Level level) {
        Level lev;
        int depth = level.getDepth();
        if (depth <= (lev = member.getLevel()).getDepth()) {
            return new Member[0];
        }
        Member[] currentMembers = new Member[]{member};
        while (depth > lev.getDepth()) {
            lev = lev.getChildLevel();
            currentMembers = scr.getMemberChildren(currentMembers);
        }
        return currentMembers;
    }

    public static Syntax funCallSyntax(String fuName, int nArgs) {
        if (fuName.equals("()")) {
            return Syntax.Parentheses;
        }
        if (fuName.equals("{}")) {
            return Syntax.Braces;
        }
        if (nArgs == 1) {
            if (fuName.equalsIgnoreCase("members")) {
                return Syntax.Property;
            }
            if (fuName.equalsIgnoreCase("children")) {
                return Syntax.Property;
            }
            if (fuName.equalsIgnoreCase("dimension")) {
                return Syntax.Property;
            }
            if (fuName.equalsIgnoreCase("hierarchy")) {
                return Syntax.Property;
            }
            if (fuName.equalsIgnoreCase("level")) {
                return Syntax.Property;
            }
            if (fuName.equalsIgnoreCase("currentmember")) {
                return Syntax.Property;
            }
            if (fuName.equalsIgnoreCase("defaultmember")) {
                return Syntax.Property;
            }
            if (fuName.equalsIgnoreCase("firstchild")) {
                return Syntax.Property;
            }
            if (fuName.equalsIgnoreCase("firstsibling")) {
                return Syntax.Property;
            }
            if (fuName.equalsIgnoreCase("lastchild")) {
                return Syntax.Property;
            }
            if (fuName.equalsIgnoreCase("lastsibling")) {
                return Syntax.Property;
            }
            if (fuName.equalsIgnoreCase("nextmember")) {
                return Syntax.Property;
            }
            if (fuName.equalsIgnoreCase("parent")) {
                return Syntax.Property;
            }
            if (fuName.equalsIgnoreCase("prevmember")) {
                return Syntax.Property;
            }
            if (fuName.equalsIgnoreCase("ordinal")) {
                return Syntax.Property;
            }
            if (fuName.equalsIgnoreCase("value")) {
                return Syntax.Property;
            }
            if (fuName.equalsIgnoreCase("lastperiods")) {
                return Syntax.Property;
            }
            if (fuName.equalsIgnoreCase("siblings")) {
                return Syntax.Property;
            }
            if (fuName.equalsIgnoreCase("name")) {
                return Syntax.Property;
            }
            if (fuName.equalsIgnoreCase("uniquename")) {
                return Syntax.Property;
            }
            if (fuName.equalsIgnoreCase("current")) {
                return Syntax.Property;
            }
            if (fuName.equalsIgnoreCase("not")) {
                return Syntax.Prefix;
            }
            if (fuName.equals("-")) {
                return Syntax.Prefix;
            }
        } else if (nArgs == 2) {
            if (fuName.indexOf(60) >= 0) {
                return Syntax.Infix;
            }
            if (fuName.indexOf(61) >= 0) {
                return Syntax.Infix;
            }
            if (fuName.indexOf(62) >= 0) {
                return Syntax.Infix;
            }
            if (fuName.equals("*")) {
                return Syntax.Infix;
            }
            if (fuName.equals(":")) {
                return Syntax.Infix;
            }
            if (fuName.equals("+")) {
                return Syntax.Infix;
            }
            if (fuName.equals("-")) {
                return Syntax.Infix;
            }
            if (fuName.equals("/")) {
                return Syntax.Infix;
            }
            if (fuName.equalsIgnoreCase("||")) {
                return Syntax.Infix;
            }
            if (fuName.equalsIgnoreCase("and")) {
                return Syntax.Infix;
            }
            if (fuName.equalsIgnoreCase("or")) {
                return Syntax.Infix;
            }
            if (fuName.equalsIgnoreCase("xor")) {
                return Syntax.Infix;
            }
        }
        if (fuName.equalsIgnoreCase("lead")) {
            return Syntax.Method;
        }
        if (fuName.equalsIgnoreCase("properties")) {
            return Syntax.Method;
        }
        if (fuName.equalsIgnoreCase("item")) {
            return Syntax.Method;
        }
        return Syntax.Function;
    }

    static List collectMembers(TreeNode root, final int iDim, final SchemaReader scr) {
        if (root == null) {
            return null;
        }
        final ArrayList memberList = new ArrayList();
        int ret = root.walkChildren(new TreeNodeCallback(){

            public int handleTreeNode(TreeNode node) {
                int iDimNode = node.getLevel() - 1;
                if (iDimNode < iDim) {
                    return 0;
                }
                Object ref = node.getReference();
                if (ref instanceof Member) {
                    Member m = (Member)ref;
                    if (!memberList.contains(m)) {
                        memberList.add(m);
                    }
                } else if (ref instanceof MemberExpr) {
                    Member m = ((MemberExpr)ref).getMember();
                    if (!memberList.contains(m)) {
                        memberList.add(m);
                    }
                } else {
                    FunCall f = (FunCall)ref;
                    boolean b = MondrianUtil.resolveFunCallMembers(f, memberList, scr);
                    if (!b) {
                        return 3;
                    }
                }
                return 1;
            }
        });
        if (ret == 3) {
            return null;
        }
        return memberList;
    }

    static boolean isCallTo(FunCall f, String name) {
        return Resources.instance().getCollator().compare(f.getFunName().toLowerCase(), name.toLowerCase()) == 0;
    }

    static boolean resolveFunCallMembers(FunCall f, List memberList, SchemaReader scr) {
        boolean canHandle = true;
        if (MondrianUtil.isCallTo(f, "Children")) {
            Member m = ((MemberExpr)f.getArg(0)).getMember();
            Member[] members = scr.getMemberChildren(m);
            for (int i = 0; i < members.length; ++i) {
                if (memberList.contains(members[i])) continue;
                memberList.add(members[i]);
            }
        } else if (MondrianUtil.isCallTo(f, "Descendants")) {
            Member m = ((MemberExpr)f.getArg(0)).getMember();
            Level level = ((LevelExpr)f.getArg(1)).getLevel();
            Member[] members = MondrianUtil.getMemberDescendants(scr, m, level);
            for (int i = 0; i < members.length; ++i) {
                if (memberList.contains(members[i])) continue;
                memberList.add(members[i]);
            }
        } else if (MondrianUtil.isCallTo(f, "Members")) {
            Level level = ((LevelExpr)f.getArg(0)).getLevel();
            Member[] members = scr.getLevelMembers(level, false);
            for (int i = 0; i < members.length; ++i) {
                if (memberList.contains(members[i])) continue;
                memberList.add(members[i]);
            }
        } else if (MondrianUtil.isCallTo(f, "Union")) {
            MondrianUtil.resolveFunCallMembers((FunCall)f.getArg(0), memberList, scr);
            MondrianUtil.resolveFunCallMembers((FunCall)f.getArg(1), memberList, scr);
        } else if (MondrianUtil.isCallTo(f, "{}")) {
            for (int i = 0; i < f.getArgs().length; ++i) {
                Member member;
                Exp arg = f.getArg(i);
                if (!(arg instanceof MemberExpr) || memberList.contains(member = ((MemberExpr)arg).getMember())) continue;
                memberList.add(member);
            }
        } else {
            canHandle = false;
        }
        return canHandle;
    }

    public static String defaultParamName(Member m) {
        Dimension d = m.getDimension();
        String s = d.getName();
        s.replace(' ', '_');
        return s + "_param";
    }

    public static boolean isVisible(SchemaReader scr, Member member) {
        if (!scr.isVisible(member)) {
            return false;
        }
        Object visible = member.getPropertyValue(Property.VISIBLE.name);
        return !Boolean.FALSE.equals(visible);
    }

    public static Hierarchy[] removeNull(Hierarchy[] hierarchies) {
        ArrayList<Hierarchy> list = new ArrayList<Hierarchy>();
        for (int i = 0; i < hierarchies.length; ++i) {
            if (hierarchies[i] == null) continue;
            list.add(hierarchies[i]);
        }
        return list.toArray(new Hierarchy[list.size()]);
    }
}

