/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.jpivot.mondrian;

import com.tonbeller.jpivot.core.ExtensionSupport;
import com.tonbeller.jpivot.mondrian.MondrianHierarchy;
import com.tonbeller.jpivot.mondrian.MondrianMember;
import com.tonbeller.jpivot.mondrian.MondrianModel;
import com.tonbeller.jpivot.mondrian.MondrianQueryAdapter;
import com.tonbeller.jpivot.mondrian.MondrianResult;
import com.tonbeller.jpivot.olap.model.Axis;
import com.tonbeller.jpivot.olap.model.Hierarchy;
import com.tonbeller.jpivot.olap.model.Member;
import com.tonbeller.jpivot.olap.model.Position;
import com.tonbeller.jpivot.olap.navi.MemberTree;
import com.tonbeller.jpivot.olap.query.Quax;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import mondrian.olap.Formula;
import mondrian.olap.Query;
import mondrian.olap.ResultLimitExceededException;
import mondrian.olap.SchemaReader;
import org.apache.log4j.Logger;

public class MondrianMemberTree
extends ExtensionSupport
implements MemberTree {
    static Logger logger = Logger.getLogger(MondrianMemberTree.class);

    public MondrianMemberTree() {
        super.setId("memberTree");
    }

    public Member[] getRootMembers(Hierarchy hier) {
        try {
            return this.internalGetRootMembers(hier);
        }
        catch (ResultLimitExceededException e) {
            logger.error(null, (Throwable)e);
            throw new MemberTree.TooManyMembersException(e);
        }
    }

    private Member[] internalGetRootMembers(Hierarchy hier) {
        MondrianQueryAdapter adapter;
        Quax quax;
        mondrian.olap.Member[] monMembers;
        Query q;
        mondrian.olap.Hierarchy monHier;
        MondrianModel model;
        block11: {
            model = (MondrianModel)this.getModel();
            monHier = ((MondrianHierarchy)hier).getMonHierarchy();
            logger.debug((Object)("internalGetRootMembers for hierarchy: " + monHier));
            q = ((MondrianQueryAdapter)model.getQueryAdapter()).getMonQuery();
            SchemaReader scr = model.getSchemaReader();
            monMembers = null;
            try {
                monMembers = scr.getHierarchyRootMembers(monHier);
            }
            catch (Exception e) {
                if (!e.getMessage().startsWith("Internal error: Illegal access")) break block11;
                logger.debug((Object)("Illegal access for : " + monHier));
                return null;
            }
        }
        ArrayList<MondrianMember> aMem = new ArrayList<MondrianMember>();
        final ArrayList<MondrianMember> visibleRootMembers = new ArrayList<MondrianMember>();
        int k = monMembers.length;
        logger.debug((Object)("members length: " + k));
        for (int i = 0; i < k; ++i) {
            mondrian.olap.Member monMember = monMembers[i];
            if (this.isVisible(monMember)) {
                logger.debug((Object)monMember);
                aMem.add(model.addMember(monMember));
                continue;
            }
            logger.debug((Object)("invisible member: " + monMember));
        }
        Formula[] formulas = q.getFormulas();
        logger.debug((Object)("formulas.length: " + formulas.length));
        for (int i = 0; i < formulas.length; ++i) {
            Formula f = formulas[i];
            mondrian.olap.Member monMem = f.getMdxMember();
            if (monMem == null || !monMem.getHierarchy().equals(monHier)) continue;
            if (this.isVisible(monMem)) {
                MondrianMember m = model.addMember(monMem);
                if (aMem.contains(m)) continue;
                logger.debug((Object)m);
                aMem.add(m);
                continue;
            }
            logger.debug((Object)("invisible formula: " + monMem));
        }
        MondrianResult res = model.currentResult();
        if (res != null && (quax = (adapter = (MondrianQueryAdapter)model.getQueryAdapter()).findQuax(hier.getDimension())) != null) {
            int iDim = quax.dimIdx(hier.getDimension());
            int iAx = quax.getOrdinal();
            if (adapter.isSwapAxes()) {
                iAx = (iAx + 1) % 2;
            }
            Axis axis = res.getAxes()[iAx];
            List positions = axis.getPositions();
            for (Position pos : positions) {
                Member[] posMembers = pos.getMembers();
                MondrianMember mem = (MondrianMember)posMembers[iDim];
                if (mem == null || mem.getMonMember() == null || !mem.getMonMember().getHierarchy().equals(monHier) || mem.getMonMember().getParentMember() != null) continue;
                if (!visibleRootMembers.contains(mem)) {
                    visibleRootMembers.add(mem);
                }
                if (aMem.contains(mem)) continue;
                aMem.add(mem);
            }
        }
        Member[] members = aMem.toArray(new Member[0]);
        if (visibleRootMembers.size() != 0) {
            Arrays.sort(members, new Comparator(){

                public int compare(Object arg0, Object arg1) {
                    Member m1 = (Member)arg0;
                    Member m2 = (Member)arg1;
                    int index1 = visibleRootMembers.indexOf(m1);
                    int index2 = visibleRootMembers.indexOf(m2);
                    if (index2 == -1) {
                        return -1;
                    }
                    if (index1 == -1) {
                        return 1;
                    }
                    return index1 - index2;
                }
            });
        }
        return members;
    }

    private boolean isVisible(mondrian.olap.Member monMember) {
        logger.debug((Object)("isVisible: " + monMember));
        if (monMember.getName().startsWith(".")) {
            logger.debug((Object)"hidden member");
            return false;
        }
        return true;
    }

    public boolean hasChildren(Member member) {
        mondrian.olap.Member monMember = ((MondrianMember)member).getMonMember();
        logger.debug((Object)("getChildren : " + monMember));
        if (monMember.isCalculatedInQuery()) {
            logger.debug((Object)"isCalculatedInQuery : true, so does not have children");
            return false;
        }
        if (monMember.getLevel().getChildLevel() != null) {
            logger.debug((Object)("getChildren true - getChildLevel : " + monMember.getLevel().getChildLevel()));
            return true;
        }
        MondrianModel model = (MondrianModel)this.getModel();
        SchemaReader scr = model.getSchemaReader();
        boolean hasChildren = scr.isDrillable(monMember);
        logger.debug((Object)("hasChildren result: " + hasChildren));
        return hasChildren;
    }

    public Member[] getChildren(Member member) {
        try {
            return this.internalGetChildren(member);
        }
        catch (ResultLimitExceededException e) {
            logger.error(null, (Throwable)e);
            throw new MemberTree.TooManyMembersException(e);
        }
    }

    private Member[] internalGetChildren(Member member) {
        mondrian.olap.Member monMember = ((MondrianMember)member).getMonMember();
        MondrianModel model = (MondrianModel)this.getModel();
        SchemaReader scr = model.getSchemaReader();
        mondrian.olap.Member[] monChildren = scr.getMemberChildren(monMember);
        logger.debug((Object)("internalGetChildren member: " + monMember + ", original size: " + monChildren.length));
        ArrayList<MondrianMember> list = new ArrayList<MondrianMember>(monChildren.length);
        for (int i = 0; i < monChildren.length; ++i) {
            mondrian.olap.Member m = monChildren[i];
            if (!this.isVisible(m)) continue;
            list.add(model.addMember(m));
        }
        Member[] children = list.toArray(new Member[list.size()]);
        logger.debug((Object)("internalGetChildren member: " + monMember + ", final size: " + children.length));
        return children;
    }

    public Member getParent(Member member) {
        mondrian.olap.Member monMember = ((MondrianMember)member).getMonMember();
        logger.debug((Object)("getParent member: " + monMember));
        MondrianModel model = (MondrianModel)this.getModel();
        SchemaReader scr = model.getSchemaReader();
        mondrian.olap.Member monParent = scr.getMemberParent(monMember);
        if (monParent == null) {
            logger.debug((Object)"  already top level");
            return null;
        }
        MondrianMember parent = model.addMember(monParent);
        logger.debug((Object)("  parent: " + monParent));
        return parent;
    }
}

