/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap.agg;

import java.util.Collection;
import mondrian.rolap.BitKey;
import mondrian.rolap.RolapStar;
import mondrian.rolap.RolapUtil;
import mondrian.rolap.StarColumnPredicate;
import mondrian.rolap.StarPredicate;
import mondrian.rolap.agg.AbstractColumnPredicate;
import mondrian.rolap.agg.LiteralStarPredicate;
import mondrian.rolap.sql.SqlQuery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValueColumnPredicate
extends AbstractColumnPredicate
implements Comparable {
    private final Object value;

    public ValueColumnPredicate(RolapStar.Column constrainedColumn, Object value) {
        super(constrainedColumn);
        assert (value != null);
        assert (!(value instanceof StarColumnPredicate));
        this.value = value;
    }

    public Object getValue() {
        return this.value;
    }

    @Override
    public String toString() {
        return String.valueOf(this.value);
    }

    @Override
    public boolean equalConstraint(StarPredicate that) {
        return that instanceof ValueColumnPredicate && this.getConstrainedColumnBitKey().equals(that.getConstrainedColumnBitKey()) && this.value.equals(((ValueColumnPredicate)that).value);
    }

    public int compareTo(Object o) {
        ValueColumnPredicate that = (ValueColumnPredicate)o;
        int columnBitKeyComp = this.getConstrainedColumnBitKey().compareTo(that.getConstrainedColumnBitKey());
        if (columnBitKeyComp != 0) {
            return columnBitKeyComp;
        }
        if (this.value instanceof Comparable && that.value instanceof Comparable && this.value.getClass() == that.value.getClass()) {
            return ((Comparable)this.value).compareTo(that.value);
        }
        String thisComp = String.valueOf(this.value);
        String thatComp = String.valueOf(that.value);
        return thisComp.compareTo(thatComp);
    }

    public boolean equals(Object other) {
        if (!(other instanceof ValueColumnPredicate)) {
            return false;
        }
        ValueColumnPredicate that = (ValueColumnPredicate)other;
        int columnBitKeyComp = this.getConstrainedColumnBitKey().compareTo(that.getConstrainedColumnBitKey());
        if (columnBitKeyComp != 0) {
            return false;
        }
        if (this.value != null) {
            return this.value.equals(that.getValue());
        }
        return null == that.getValue();
    }

    public int hashCode() {
        int hashCode = this.getConstrainedColumnBitKey().hashCode();
        if (this.value != null) {
            hashCode ^= this.value.hashCode();
        }
        return hashCode;
    }

    @Override
    public void values(Collection<Object> collection) {
        collection.add(this.value);
    }

    @Override
    public boolean evaluate(Object value) {
        return this.value.equals(value);
    }

    @Override
    public void describe(StringBuilder buf) {
        buf.append(this.value);
    }

    @Override
    public StarColumnPredicate.Overlap intersect(StarColumnPredicate predicate) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean mightIntersect(StarPredicate other) {
        return ((StarColumnPredicate)other).evaluate(this.value);
    }

    @Override
    public StarColumnPredicate minus(StarPredicate predicate) {
        assert (predicate != null);
        if (((StarColumnPredicate)predicate).evaluate(this.value)) {
            return LiteralStarPredicate.FALSE;
        }
        return this;
    }

    @Override
    public StarColumnPredicate cloneWithColumn(RolapStar.Column column) {
        return new ValueColumnPredicate(column, this.value);
    }

    @Override
    public void toSql(SqlQuery sqlQuery, StringBuilder buf) {
        RolapStar.Column column = this.getConstrainedColumn();
        String expr = column.generateExprString(sqlQuery);
        buf.append(expr);
        Object key = this.getValue();
        if (key == RolapUtil.sqlNullValue) {
            buf.append(" is null");
        } else {
            buf.append(" = ");
            sqlQuery.getDialect().quote(buf, key, column.getDatatype());
        }
    }

    public BitKey checkInList(BitKey inListLHSBitKey) {
        BitKey inListRHSBitKey = inListLHSBitKey.copy();
        if (!this.getConstrainedColumnBitKey().equals(inListLHSBitKey) || this.value == RolapUtil.sqlNullValue) {
            inListRHSBitKey.clear();
        }
        return inListRHSBitKey;
    }

    public void toInListSql(SqlQuery sqlQuery, StringBuilder buf) {
        sqlQuery.getDialect().quote(buf, this.value, this.getConstrainedColumn().getDatatype());
    }
}

