/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.sql.DataSource;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.Id;
import mondrian.olap.Member;
import mondrian.olap.MondrianDef;
import mondrian.olap.MondrianProperties;
import mondrian.olap.Property;
import mondrian.olap.Util;
import mondrian.resource.MondrianResource;
import mondrian.rolap.BitKey;
import mondrian.rolap.MemberCache;
import mondrian.rolap.MemberKey;
import mondrian.rolap.MemberReader;
import mondrian.rolap.RolapAggregationManager;
import mondrian.rolap.RolapCube;
import mondrian.rolap.RolapCubeLevel;
import mondrian.rolap.RolapHierarchy;
import mondrian.rolap.RolapLevel;
import mondrian.rolap.RolapMember;
import mondrian.rolap.RolapProperty;
import mondrian.rolap.RolapStar;
import mondrian.rolap.RolapUtil;
import mondrian.rolap.SqlConstraintFactory;
import mondrian.rolap.SqlContextConstraint;
import mondrian.rolap.SqlStatement;
import mondrian.rolap.SqlTupleReader;
import mondrian.rolap.TupleReader;
import mondrian.rolap.agg.AggregationManager;
import mondrian.rolap.agg.CellRequest;
import mondrian.rolap.aggmatcher.AggStar;
import mondrian.rolap.sql.MemberChildrenConstraint;
import mondrian.rolap.sql.SqlQuery;
import mondrian.rolap.sql.TupleConstraint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SqlMemberSource
implements MemberReader,
TupleReader.MemberBuilder {
    private final SqlConstraintFactory sqlConstraintFactory = SqlConstraintFactory.instance();
    private final RolapHierarchy hierarchy;
    private final DataSource dataSource;
    private MemberCache cache;
    private int lastOrdinal = 0;
    private boolean assignOrderKeys;

    SqlMemberSource(RolapHierarchy hierarchy) {
        this.hierarchy = hierarchy;
        this.dataSource = hierarchy.getRolapSchema().getInternalConnection().getDataSource();
        this.assignOrderKeys = MondrianProperties.instance().CompareSiblingsByOrderKey.get();
    }

    @Override
    public RolapHierarchy getHierarchy() {
        return this.hierarchy;
    }

    @Override
    public boolean setCache(MemberCache cache) {
        this.cache = cache;
        return true;
    }

    @Override
    public int getMemberCount() {
        RolapLevel[] levels = (RolapLevel[])this.hierarchy.getLevels();
        int count = 0;
        for (RolapLevel level : levels) {
            count += this.getLevelMemberCount(level);
        }
        return count;
    }

    @Override
    public RolapMember substitute(RolapMember member) {
        return member;
    }

    @Override
    public RolapMember desubstitute(RolapMember member) {
        return member;
    }

    @Override
    public RolapMember lookupMember(List<Id.Segment> uniqueNameParts, boolean failIfNotFound) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getLevelMemberCount(RolapLevel level) {
        if (level.isAll()) {
            return 1;
        }
        return this.getMemberCount(level, this.dataSource);
    }

    private int getMemberCount(RolapLevel level, DataSource dataSource) {
        boolean[] mustCount = new boolean[1];
        String sql = this.makeLevelMemberCountSql(level, dataSource, mustCount);
        SqlStatement stmt = RolapUtil.executeQuery(dataSource, sql, "SqlMemberSource.getLevelMemberCount", "while counting members of level '" + level);
        try {
            int count;
            ResultSet resultSet = stmt.getResultSet();
            if (!mustCount[0]) {
                Util.assertTrue(resultSet.next());
                ++stmt.rowCount;
                count = resultSet.getInt(1);
            } else {
                ResultSetMetaData rmd = resultSet.getMetaData();
                int nColumns = rmd.getColumnCount();
                String[] colStrings = new String[nColumns];
                count = 0;
                while (resultSet.next()) {
                    ++stmt.rowCount;
                    boolean isEqual = true;
                    for (int i = 0; i < nColumns; ++i) {
                        String colStr = resultSet.getString(i + 1);
                        if (!colStr.equals(colStrings[i])) {
                            isEqual = false;
                        }
                        colStrings[i] = colStr;
                    }
                    if (isEqual) continue;
                    ++count;
                }
            }
            int n = count;
            return n;
        }
        catch (SQLException e) {
            throw stmt.handle(e);
        }
        finally {
            stmt.close();
        }
    }

    private String makeLevelMemberCountSql(RolapLevel level, DataSource dataSource, boolean[] mustCount) {
        RolapLevel[] levels;
        mustCount[0] = false;
        SqlQuery sqlQuery = SqlQuery.newQuery(dataSource, "while generating query to count members in level " + level);
        int levelDepth = level.getDepth();
        if (levelDepth == (levels = (RolapLevel[])this.hierarchy.getLevels()).length) {
            sqlQuery.addSelect("count(*)");
            this.hierarchy.addToFrom(sqlQuery, level.getKeyExp());
            return sqlQuery.toString();
        }
        if (!sqlQuery.getDialect().allowsFromQuery()) {
            String columnList = "";
            int columnCount = 0;
            for (int i = levelDepth; i >= 0; --i) {
                RolapLevel level2 = levels[i];
                if (level2.isAll()) continue;
                if (columnCount > 0) {
                    if (sqlQuery.getDialect().allowsCompoundCountDistinct()) {
                        columnList = columnList + ", ";
                    } else {
                        mustCount[0] = true;
                    }
                }
                this.hierarchy.addToFrom(sqlQuery, level2.getKeyExp());
                String keyExp = level2.getKeyExp().getExpression(sqlQuery);
                if (columnCount > 0 && !sqlQuery.getDialect().allowsCompoundCountDistinct() && sqlQuery.getDialect().isSybase()) {
                    keyExp = "convert(varchar, " + columnList + ")";
                }
                columnList = columnList + keyExp;
                if (level2.isUnique()) break;
                ++columnCount;
            }
            if (mustCount[0]) {
                sqlQuery.addSelect(columnList);
                sqlQuery.addOrderBy(columnList, true, false, true);
            } else {
                sqlQuery.addSelect("count(DISTINCT " + columnList + ")");
            }
            return sqlQuery.toString();
        }
        sqlQuery.setDistinct(true);
        for (int i = levelDepth; i >= 0; --i) {
            RolapLevel level2 = levels[i];
            if (level2.isAll()) continue;
            this.hierarchy.addToFrom(sqlQuery, level2.getKeyExp());
            sqlQuery.addSelect(level2.getKeyExp().getExpression(sqlQuery));
            if (level2.isUnique()) break;
        }
        SqlQuery outerQuery = SqlQuery.newQuery(dataSource, "while generating query to count members in level " + level);
        outerQuery.addSelect("count(*)");
        boolean failIfExists = true;
        outerQuery.addFrom(sqlQuery, "init", failIfExists);
        return outerQuery.toString();
    }

    @Override
    public RolapMember[] getMembers() {
        return this.getMembers(this.dataSource);
    }

    private RolapMember[] getMembers(DataSource dataSource) {
        String sql = this.makeKeysSql(dataSource);
        RolapLevel[] levels = (RolapLevel[])this.hierarchy.getLevels();
        SqlStatement stmt = RolapUtil.executeQuery(dataSource, sql, "SqlMemberSource.getMembers", "while building member cache");
        try {
            ArrayList<RolapMember> list = new ArrayList<RolapMember>();
            HashMap<MemberKey, RolapMember> map = new HashMap<MemberKey, RolapMember>();
            RolapMember root = null;
            if (this.hierarchy.hasAll()) {
                root = this.hierarchy.getAllMember();
                list.add(root);
            }
            int limit = MondrianProperties.instance().ResultLimit.get();
            ResultSet resultSet = stmt.getResultSet();
            while (resultSet.next()) {
                ++stmt.rowCount;
                if (limit > 0 && limit < stmt.rowCount) {
                    throw stmt.handle(MondrianResource.instance().MemberFetchLimitExceeded.ex(limit));
                }
                int column = 0;
                RolapMember member = root;
                for (RolapLevel level : levels) {
                    RolapProperty[] properties;
                    RolapMember parent;
                    MemberKey key;
                    if (level.isAll()) continue;
                    Object value = resultSet.getObject(column + 1);
                    if (value == null) {
                        value = RolapUtil.sqlNullValue;
                    }
                    if ((member = (RolapMember)map.get(key = new MemberKey(parent = member, value))) == null) {
                        member = new RolapMember(parent, level, value);
                        member.setOrdinal(this.lastOrdinal++);
                        if (value == RolapUtil.sqlNullValue) {
                            this.addAsOldestSibling(list, member);
                        } else {
                            list.add(member);
                        }
                        map.put(key, member);
                    }
                    ++column;
                    if (!level.getOrdinalExp().equals((Object)level.getKeyExp())) {
                        if (this.assignOrderKeys) {
                            Object orderKey = resultSet.getObject(column + 1);
                            this.setOrderKey(member, orderKey);
                        }
                        ++column;
                    }
                    for (RolapProperty property : properties = level.getProperties()) {
                        member.setProperty(property.getName(), resultSet.getObject(column + 1));
                        ++column;
                    }
                }
            }
            RolapMember[] rolapMemberArray = RolapUtil.toArray(list);
            return rolapMemberArray;
        }
        catch (SQLException e) {
            throw stmt.handle(e);
        }
        finally {
            stmt.close();
        }
    }

    private void setOrderKey(RolapMember member, Object orderKey) {
        if (orderKey != null && !(orderKey instanceof Comparable)) {
            orderKey = orderKey.toString();
        }
        member.setOrderKey((Comparable)orderKey);
    }

    private void addAsOldestSibling(List<RolapMember> list, RolapMember member) {
        RolapMember sibling;
        int i = list.size();
        while (--i >= 0 && (sibling = list.get(i)).getParentMember() == member.getParentMember()) {
        }
        list.add(i + 1, member);
    }

    private String makeKeysSql(DataSource dataSource) {
        RolapLevel[] levels;
        SqlQuery sqlQuery = SqlQuery.newQuery(dataSource, "while generating query to retrieve members of " + this.hierarchy);
        for (RolapLevel level : levels = (RolapLevel[])this.hierarchy.getLevels()) {
            RolapProperty[] properties;
            if (level.isAll()) continue;
            MondrianDef.Expression exp = level.getKeyExp();
            this.hierarchy.addToFrom(sqlQuery, exp);
            String expString = exp.getExpression(sqlQuery);
            sqlQuery.addSelect(expString);
            sqlQuery.addGroupBy(expString);
            exp = level.getOrdinalExp();
            this.hierarchy.addToFrom(sqlQuery, exp);
            expString = exp.getExpression(sqlQuery);
            sqlQuery.addOrderBy(expString, true, false, true);
            sqlQuery.addGroupBy(expString);
            if (!exp.equals((Object)level.getKeyExp())) {
                sqlQuery.addSelect(expString);
            }
            for (RolapProperty property : properties = level.getProperties()) {
                exp = property.getExp();
                this.hierarchy.addToFrom(sqlQuery, exp);
                expString = exp.getExpression(sqlQuery);
                sqlQuery.addSelect(expString);
                sqlQuery.addGroupBy(expString);
            }
        }
        return sqlQuery.toString();
    }

    @Override
    public List<RolapMember> getMembersInLevel(RolapLevel level, int startOrdinal, int endOrdinal) {
        TupleConstraint constraint = this.sqlConstraintFactory.getLevelMembersConstraint(null);
        return this.getMembersInLevel(level, startOrdinal, endOrdinal, constraint);
    }

    @Override
    public List<RolapMember> getMembersInLevel(RolapLevel level, int startOrdinal, int endOrdinal, TupleConstraint constraint) {
        if (level.isAll()) {
            return Collections.singletonList(this.hierarchy.getAllMember());
        }
        return this.getMembersInLevel(level, constraint);
    }

    private List<RolapMember> getMembersInLevel(RolapLevel level, TupleConstraint constraint) {
        SqlTupleReader tupleReader = new SqlTupleReader(constraint);
        tupleReader.addLevelMembers(level, this, null);
        List<RolapMember[]> tupleList = tupleReader.readTuples(this.dataSource, null, null);
        ArrayList<RolapMember> memberList = new ArrayList<RolapMember>(tupleList.size());
        for (RolapMember[] tuple : tupleList) {
            assert (tuple.length == 1);
            memberList.add(tuple[0]);
        }
        return memberList;
    }

    @Override
    public MemberCache getMemberCache() {
        return this.cache;
    }

    @Override
    public Object getMemberCacheLock() {
        return this.cache;
    }

    @Override
    public List<RolapMember> getRootMembers() {
        return this.getMembersInLevel((RolapLevel)this.hierarchy.getLevels()[0], 0, Integer.MAX_VALUE);
    }

    String makeChildMemberSql(RolapMember member, DataSource dataSource, MemberChildrenConstraint constraint) {
        RolapProperty[] properties;
        SqlQuery sqlQuery = SqlQuery.newQuery(dataSource, "while generating query to retrieve children of member " + member);
        AggStar aggStar = SqlMemberSource.chooseAggStar(constraint, member);
        constraint.addMemberConstraint(sqlQuery, null, aggStar, member);
        RolapLevel level = (RolapLevel)member.getLevel().getChildLevel();
        this.hierarchy.addToFrom(sqlQuery, level.getKeyExp());
        String q = level.getKeyExp().getExpression(sqlQuery);
        sqlQuery.addSelect(q);
        sqlQuery.addGroupBy(q);
        constraint.addLevelConstraint(sqlQuery, null, aggStar, level);
        if (level.hasCaptionColumn()) {
            MondrianDef.Expression captionExp = level.getCaptionExp();
            this.hierarchy.addToFrom(sqlQuery, captionExp);
            String captionSql = captionExp.getExpression(sqlQuery);
            sqlQuery.addSelect(captionSql);
            sqlQuery.addGroupBy(captionSql);
        }
        this.hierarchy.addToFrom(sqlQuery, level.getOrdinalExp());
        String orderBy = level.getOrdinalExp().getExpression(sqlQuery);
        sqlQuery.addOrderBy(orderBy, true, false, true);
        if (!orderBy.equals(q)) {
            sqlQuery.addGroupBy(orderBy);
            sqlQuery.addSelect(orderBy);
        }
        for (RolapProperty property : properties = level.getProperties()) {
            MondrianDef.Expression exp = property.getExp();
            this.hierarchy.addToFrom(sqlQuery, exp);
            String s = exp.getExpression(sqlQuery);
            sqlQuery.addSelect(s);
            sqlQuery.addGroupBy(s);
        }
        return sqlQuery.toString();
    }

    private static AggStar chooseAggStar(MemberChildrenConstraint constraint, RolapMember member) {
        RolapStar.Column[] columns;
        if (!(constraint instanceof SqlContextConstraint)) {
            return null;
        }
        SqlContextConstraint contextConstraint = (SqlContextConstraint)constraint;
        Evaluator evaluator = contextConstraint.getEvaluator();
        RolapCube cube = (RolapCube)evaluator.getCube();
        RolapStar star = cube.getStar();
        int starColumnCount = star.getColumnCount();
        BitKey measureBitKey = BitKey.Factory.makeBitKey(starColumnCount);
        BitKey levelBitKey = BitKey.Factory.makeBitKey(starColumnCount);
        Member[] members = evaluator.getMembers();
        Member measure = members[0];
        int ordinal = measure.getOrdinal();
        RolapCubeLevel childLevel = (RolapCubeLevel)member.getLevel().getChildLevel();
        RolapStar.Column column = childLevel.getStarKeyColumn();
        CellRequest request = RolapAggregationManager.makeRequest(members);
        if (request == null) {
            return null;
        }
        for (RolapStar.Column column1 : columns = request.getConstrainedColumns()) {
            levelBitKey.set(column1.getBitPosition());
        }
        levelBitKey.set(column.getBitPosition());
        measureBitKey.set(ordinal);
        return AggregationManager.instance().findAgg(star, levelBitKey, measureBitKey, new boolean[]{false});
    }

    @Override
    public void getMemberChildren(List<RolapMember> parentMembers, List<RolapMember> children) {
        MemberChildrenConstraint constraint = this.sqlConstraintFactory.getMemberChildrenConstraint(null);
        this.getMemberChildren(parentMembers, children, constraint);
    }

    @Override
    public void getMemberChildren(List<RolapMember> parentMembers, List<RolapMember> children, MemberChildrenConstraint mcc) {
        RolapLevel childLevel = this.getCommonChildLevelForDescendants(parentMembers);
        if (childLevel != null) {
            TupleConstraint lmc = this.sqlConstraintFactory.getDescendantsConstraint(parentMembers, mcc);
            List<RolapMember> list = this.getMembersInLevel(childLevel, 0, Integer.MAX_VALUE, lmc);
            children.addAll(list);
            return;
        }
        for (RolapMember parentMember : parentMembers) {
            this.getMemberChildren(parentMember, children, mcc);
        }
    }

    @Override
    public void getMemberChildren(RolapMember parentMember, List<RolapMember> children) {
        MemberChildrenConstraint constraint = this.sqlConstraintFactory.getMemberChildrenConstraint(null);
        this.getMemberChildren(parentMember, children, constraint);
    }

    @Override
    public void getMemberChildren(RolapMember parentMember, List<RolapMember> children, MemberChildrenConstraint constraint) {
        if (!parentMember.isAll() && parentMember.isCalculated() && !parentMember.getLevel().isParentChild()) {
            return;
        }
        this.getMemberChildren2(parentMember, children, constraint);
    }

    private RolapLevel getCommonChildLevelForDescendants(List<RolapMember> parents) {
        if (parents.size() < 2) {
            return null;
        }
        RolapLevel parentLevel = null;
        RolapLevel childLevel = null;
        for (RolapMember member : parents) {
            if (member.isCalculated()) {
                return null;
            }
            if (parentLevel == null) {
                parentLevel = member.getLevel();
                if (parentLevel.isParentChild()) {
                    return null;
                }
                childLevel = (RolapLevel)parentLevel.getChildLevel();
                if (childLevel == null) {
                    return null;
                }
                if (!childLevel.isParentChild()) continue;
                return null;
            }
            if (parentLevel == member.getLevel()) continue;
            return null;
        }
        return childLevel;
    }

    private void getMemberChildren2(RolapMember parentMember, List<RolapMember> children, MemberChildrenConstraint constraint) {
        RolapLevel childLevel;
        boolean parentChild;
        String sql;
        RolapLevel parentLevel = parentMember.getLevel();
        if (parentLevel.isParentChild()) {
            sql = this.makeChildMemberSqlPC(parentMember);
            parentChild = true;
            childLevel = parentLevel;
        } else {
            childLevel = (RolapLevel)parentLevel.getChildLevel();
            if (childLevel == null) {
                return;
            }
            if (childLevel.isParentChild()) {
                sql = this.makeChildMemberSql_PCRoot(parentMember);
                parentChild = true;
            } else {
                sql = this.makeChildMemberSql(parentMember, this.dataSource, constraint);
                parentChild = false;
            }
        }
        SqlStatement stmt = RolapUtil.executeQuery(this.dataSource, sql, "SqlMemberSource.getMemberChildren", "while building member cache");
        try {
            int limit = MondrianProperties.instance().ResultLimit.get();
            boolean checkCacheStatus = true;
            ResultSet resultSet = stmt.getResultSet();
            while (resultSet.next()) {
                Object captionValue;
                int columnOffset;
                ++stmt.rowCount;
                if (limit > 0 && limit < stmt.rowCount) {
                    throw MondrianResource.instance().MemberFetchLimitExceeded.ex(limit);
                }
                Object value = resultSet.getObject(1);
                if (value == null) {
                    value = RolapUtil.sqlNullValue;
                }
                if (childLevel.hasCaptionColumn()) {
                    columnOffset = 2;
                    captionValue = resultSet.getObject(columnOffset);
                } else {
                    columnOffset = 1;
                    captionValue = null;
                }
                Object key = this.cache.makeKey(parentMember, value);
                RolapMember member = this.cache.getMember(key, checkCacheStatus);
                checkCacheStatus = false;
                if (member == null) {
                    member = this.makeMember(parentMember, childLevel, value, captionValue, parentChild, resultSet, key, columnOffset);
                }
                if (value == RolapUtil.sqlNullValue) {
                    this.addAsOldestSibling(children, member);
                    continue;
                }
                children.add(member);
            }
        }
        catch (SQLException e) {
            throw stmt.handle(e);
        }
        finally {
            stmt.close();
        }
    }

    @Override
    public RolapMember makeMember(RolapMember parentMember, RolapLevel childLevel, Object value, Object captionValue, boolean parentChild, ResultSet resultSet, Object key, int columnOffset) throws SQLException {
        RolapMember member = new RolapMember(parentMember, childLevel, value);
        if (!childLevel.getOrdinalExp().equals((Object)childLevel.getKeyExp())) {
            member.setOrdinal(this.lastOrdinal++);
        }
        if (captionValue != null) {
            member.setCaption(captionValue.toString());
        }
        if (parentChild) {
            RolapParentChildMember parentChildMember = childLevel.hasClosedPeer() ? new RolapParentChildMember(parentMember, childLevel, value, member) : new RolapParentChildMemberNoClosure(parentMember, childLevel, value, member);
            member = parentChildMember;
        }
        RolapProperty[] properties = childLevel.getProperties();
        if (!childLevel.getOrdinalExp().equals((Object)childLevel.getKeyExp())) {
            if (this.assignOrderKeys) {
                Object orderKey = resultSet.getObject(columnOffset + 1);
                this.setOrderKey(member, orderKey);
            }
            ++columnOffset;
        }
        for (int j = 0; j < properties.length; ++j) {
            RolapProperty property = properties[j];
            member.setProperty(property.getName(), resultSet.getObject(columnOffset + j + 1));
        }
        this.cache.putMember(key, member);
        return member;
    }

    private String makeChildMemberSql_PCRoot(RolapMember member) {
        RolapProperty[] properties;
        SqlQuery sqlQuery = SqlQuery.newQuery(this.dataSource, "while generating query to retrieve children of parent/child hierarchy member " + member);
        Util.assertTrue(member.isAll(), "In the current implementation, parent/child hierarchies must have only one level (plus the 'All' level).");
        RolapLevel level = (RolapLevel)member.getLevel().getChildLevel();
        Util.assertTrue(!level.isAll(), "all level cannot be parent-child");
        Util.assertTrue(level.isUnique(), "parent-child level '" + level + "' must be unique");
        this.hierarchy.addToFrom(sqlQuery, level.getParentExp());
        String parentId = level.getParentExp().getExpression(sqlQuery);
        StringBuilder condition = new StringBuilder(64);
        condition.append(parentId);
        if (level.getNullParentValue() == null || level.getNullParentValue().equalsIgnoreCase("NULL")) {
            condition.append(" IS NULL");
        } else {
            try {
                Util.discard((double)Double.parseDouble(level.getNullParentValue()));
                condition.append(" = ");
                condition.append(level.getNullParentValue());
            }
            catch (NumberFormatException e) {
                condition.append(" = ");
                Util.singleQuoteString(level.getNullParentValue(), condition);
            }
        }
        sqlQuery.addWhere(condition.toString());
        this.hierarchy.addToFrom(sqlQuery, level.getKeyExp());
        String childId = level.getKeyExp().getExpression(sqlQuery);
        sqlQuery.addSelect(childId);
        sqlQuery.addGroupBy(childId);
        this.hierarchy.addToFrom(sqlQuery, level.getOrdinalExp());
        String orderBy = level.getOrdinalExp().getExpression(sqlQuery);
        sqlQuery.addOrderBy(orderBy, true, false, true);
        if (!orderBy.equals(childId)) {
            sqlQuery.addGroupBy(orderBy);
            sqlQuery.addSelect(orderBy);
        }
        for (RolapProperty property : properties = level.getProperties()) {
            MondrianDef.Expression exp = property.getExp();
            this.hierarchy.addToFrom(sqlQuery, exp);
            String s = exp.getExpression(sqlQuery);
            sqlQuery.addSelect(s);
            sqlQuery.addGroupBy(s);
        }
        return sqlQuery.toString();
    }

    private String makeChildMemberSqlPC(RolapMember member) {
        RolapProperty[] properties;
        SqlQuery sqlQuery = SqlQuery.newQuery(this.dataSource, "while generating query to retrieve children of parent/child hierarchy member " + member);
        RolapLevel level = member.getLevel();
        Util.assertTrue(!level.isAll(), "all level cannot be parent-child");
        Util.assertTrue(level.isUnique(), "parent-child level '" + level + "' must be unique");
        this.hierarchy.addToFrom(sqlQuery, level.getParentExp());
        String parentId = level.getParentExp().getExpression(sqlQuery);
        StringBuilder buf = new StringBuilder();
        sqlQuery.getDialect().quote(buf, member.getKey(), level.getDatatype());
        sqlQuery.addWhere(parentId, " = ", buf.toString());
        this.hierarchy.addToFrom(sqlQuery, level.getKeyExp());
        String childId = level.getKeyExp().getExpression(sqlQuery);
        sqlQuery.addSelect(childId);
        sqlQuery.addGroupBy(childId);
        this.hierarchy.addToFrom(sqlQuery, level.getOrdinalExp());
        String orderBy = level.getOrdinalExp().getExpression(sqlQuery);
        sqlQuery.addOrderBy(orderBy, true, false, true);
        if (!orderBy.equals(childId)) {
            sqlQuery.addGroupBy(orderBy);
            sqlQuery.addSelect(orderBy);
        }
        for (RolapProperty property : properties = level.getProperties()) {
            MondrianDef.Expression exp = property.getExp();
            this.hierarchy.addToFrom(sqlQuery, exp);
            String s = exp.getExpression(sqlQuery);
            sqlQuery.addSelect(s);
            sqlQuery.addGroupBy(s);
        }
        return sqlQuery.toString();
    }

    @Override
    public RolapMember getLeadMember(RolapMember member, int n) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void getMemberRange(RolapLevel level, RolapMember startMember, RolapMember endMember, List<RolapMember> memberList) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int compare(RolapMember m1, RolapMember m2, boolean siblingsAreEqual) {
        throw new UnsupportedOperationException();
    }

    @Override
    public TupleReader.MemberBuilder getMemberBuilder() {
        return this;
    }

    @Override
    public RolapMember getDefaultMember() {
        throw new UnsupportedOperationException();
    }

    @Override
    public RolapMember getMemberParent(RolapMember member) {
        throw new UnsupportedOperationException();
    }

    private static class RolapParentChildMemberNoClosure
    extends RolapParentChildMember {
        public RolapParentChildMemberNoClosure(RolapMember parentMember, RolapLevel childLevel, Object value, RolapMember dataMember) {
            super(parentMember, childLevel, value, dataMember);
        }

        protected boolean computeCalculated(Member.MemberType memberType) {
            return true;
        }

        public Exp getExpression() {
            return this.getHierarchy().getAggregateChildrenExpression();
        }
    }

    private static class RolapParentChildMember
    extends RolapMember {
        private final RolapMember dataMember;
        private int depth = 0;

        public RolapParentChildMember(RolapMember parentMember, RolapLevel childLevel, Object value, RolapMember dataMember) {
            super(parentMember, childLevel, value);
            this.dataMember = dataMember;
            this.depth = parentMember != null ? parentMember.getDepth() + 1 : 0;
        }

        public Member getDataMember() {
            return this.dataMember;
        }

        public Object getPropertyValue(String propertyName, boolean matchCase) {
            if (Util.equal(propertyName, Property.CONTRIBUTING_CHILDREN.name, matchCase)) {
                ArrayList<RolapMember> list = new ArrayList<RolapMember>();
                list.add(this.dataMember);
                RolapHierarchy hierarchy = this.getHierarchy();
                hierarchy.getMemberReader().getMemberChildren(this.dataMember, list);
                return list;
            }
            return super.getPropertyValue(propertyName, matchCase);
        }

        public int getDepth() {
            return this.depth;
        }

        public int getOrdinal() {
            return this.dataMember.getOrdinal();
        }
    }
}

