/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import mondrian.mdx.MemberExpr;
import mondrian.mdx.ResolvedFunCall;
import mondrian.olap.Cube;
import mondrian.olap.Dimension;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.Level;
import mondrian.olap.Member;
import mondrian.olap.Query;
import mondrian.olap.Util;
import mondrian.rolap.RolapCalculatedMember;
import mondrian.rolap.RolapCube;
import mondrian.rolap.RolapCubeLevel;
import mondrian.rolap.RolapEvaluator;
import mondrian.rolap.RolapHierarchy;
import mondrian.rolap.RolapLevel;
import mondrian.rolap.RolapMember;
import mondrian.rolap.RolapStoredMeasure;
import mondrian.rolap.SqlConstraintUtils;
import mondrian.rolap.aggmatcher.AggStar;
import mondrian.rolap.sql.MemberChildrenConstraint;
import mondrian.rolap.sql.SqlQuery;
import mondrian.rolap.sql.TupleConstraint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlContextConstraint
implements MemberChildrenConstraint,
TupleConstraint {
    List<Object> cacheKey;
    private Evaluator evaluator;
    private boolean strict;

    public static boolean isValidContext(Evaluator context) {
        return SqlContextConstraint.isValidContext(context, true, null);
    }

    public static boolean isValidContext(Evaluator context, boolean disallowVirtualCube, Level[] levels) {
        if (context == null) {
            return false;
        }
        RolapCube cube = (RolapCube)context.getCube();
        if (disallowVirtualCube && cube.isVirtual()) {
            return false;
        }
        if (cube.isVirtual()) {
            HashSet<RolapCube> baseCubes;
            Query query = context.getQuery();
            if (!SqlContextConstraint.findVirtualCubeBaseCubes(query, baseCubes = new HashSet<RolapCube>())) {
                return false;
            }
            assert (levels != null);
            for (RolapCube baseCube : baseCubes) {
                for (Level level : levels) {
                    if (baseCube.findBaseCubeHierarchy((RolapHierarchy)level.getHierarchy()) != null) continue;
                    return false;
                }
            }
            query.setBaseCubes(baseCubes);
        }
        return true;
    }

    private static boolean findVirtualCubeBaseCubes(Query query, Set<RolapCube> baseCubes) {
        Set<Member> measureMembers = query.getMeasuresMembers();
        if (measureMembers.isEmpty()) {
            Cube cube = query.getCube();
            Dimension dimension = cube.getDimensions()[0];
            query.addMeasuresMembers(dimension.getHierarchy().getDefaultMember());
        }
        for (Member member : query.getMeasuresMembers()) {
            if (member instanceof RolapStoredMeasure) {
                SqlContextConstraint.addMeasure((RolapStoredMeasure)member, baseCubes);
                continue;
            }
            if (!(member instanceof RolapCalculatedMember)) continue;
            SqlContextConstraint.findMeasures(member.getExpression(), baseCubes);
        }
        return !baseCubes.isEmpty();
    }

    private static void addMeasure(RolapStoredMeasure measure, Set<RolapCube> baseCubes) {
        RolapCube baseCube = measure.getCube();
        baseCubes.add(baseCube);
    }

    private static void findMeasures(Exp exp, Set<RolapCube> baseCubes) {
        block4: {
            block2: {
                Member member;
                block3: {
                    if (!(exp instanceof MemberExpr)) break block2;
                    MemberExpr memberExpr = (MemberExpr)exp;
                    member = memberExpr.getMember();
                    if (!(member instanceof RolapStoredMeasure)) break block3;
                    SqlContextConstraint.addMeasure((RolapStoredMeasure)member, baseCubes);
                    break block4;
                }
                if (!(member instanceof RolapCalculatedMember)) break block4;
                SqlContextConstraint.findMeasures(member.getExpression(), baseCubes);
                break block4;
            }
            if (exp instanceof ResolvedFunCall) {
                Exp[] args;
                ResolvedFunCall funCall = (ResolvedFunCall)exp;
                for (Exp arg : args = funCall.getArgs()) {
                    SqlContextConstraint.findMeasures(arg, baseCubes);
                }
            }
        }
    }

    SqlContextConstraint(RolapEvaluator evaluator, boolean strict) {
        this.evaluator = evaluator;
        this.strict = strict;
        this.cacheKey = new ArrayList<Object>();
        this.cacheKey.add(this.getClass());
        this.cacheKey.add(strict);
        this.cacheKey.addAll(Arrays.asList(evaluator.getMembers()));
        if (evaluator.getCube().isVirtual()) {
            this.cacheKey.addAll(evaluator.getQuery().getBaseCubes());
        }
    }

    @Override
    public void addMemberConstraint(SqlQuery sqlQuery, RolapCube baseCube, AggStar aggStar, RolapMember parent) {
        if (parent.isCalculated()) {
            throw Util.newInternal("cannot restrict SQL to calculated member");
        }
        Evaluator e = this.evaluator.push(parent);
        SqlConstraintUtils.addContextConstraint(sqlQuery, aggStar, e, this.strict);
        SqlConstraintUtils.addMemberConstraint(sqlQuery, baseCube, aggStar, parent, true);
    }

    @Override
    public void addMemberConstraint(SqlQuery sqlQuery, RolapCube baseCube, AggStar aggStar, List<RolapMember> parents) {
        SqlConstraintUtils.addContextConstraint(sqlQuery, aggStar, this.evaluator, this.strict);
        SqlConstraintUtils.addMemberConstraint(sqlQuery, baseCube, aggStar, parents, true, false);
    }

    @Override
    public void addConstraint(SqlQuery sqlQuery, RolapCube baseCube) {
        SqlConstraintUtils.addContextConstraint(sqlQuery, null, this.evaluator, this.strict);
    }

    protected boolean isJoinRequired() {
        Member[] members = this.evaluator.getMembers();
        for (int i = 1; i < members.length; ++i) {
            if (members[i].isAll()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void addLevelConstraint(SqlQuery sqlQuery, RolapCube baseCube, AggStar aggStar, RolapLevel level) {
        if (!this.isJoinRequired()) {
            return;
        }
        SqlConstraintUtils.joinLevelTableToFactTable(sqlQuery, baseCube, aggStar, this.evaluator, (RolapCubeLevel)level);
    }

    @Override
    public MemberChildrenConstraint getMemberChildrenConstraint(RolapMember parent) {
        return this;
    }

    @Override
    public Object getCacheKey() {
        return this.cacheKey;
    }

    @Override
    public Evaluator getEvaluator() {
        return this.evaluator;
    }
}

