/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.util.ArrayList;
import javax.sql.DataSource;
import mondrian.olap.Exp;
import mondrian.olap.FunDef;
import mondrian.olap.MondrianProperties;
import mondrian.olap.NativeEvaluator;
import mondrian.olap.SchemaReader;
import mondrian.rolap.RolapCube;
import mondrian.rolap.RolapEvaluator;
import mondrian.rolap.RolapNativeSet;
import mondrian.rolap.RolapNativeSql;
import mondrian.rolap.SqlConstraintUtils;
import mondrian.rolap.sql.SqlQuery;

public class RolapNativeFilter
extends RolapNativeSet {
    public RolapNativeFilter() {
        super.setEnabled(MondrianProperties.instance().EnableNativeFilter.get());
    }

    protected boolean restrictMemberTypes() {
        return true;
    }

    NativeEvaluator createEvaluator(RolapEvaluator evaluator, FunDef fun, Exp[] args) {
        if (!this.isEnabled()) {
            return null;
        }
        if (!FilterConstraint.isValidContext(evaluator)) {
            return null;
        }
        String funName = fun.getName();
        if (!"Filter".equalsIgnoreCase(funName)) {
            return null;
        }
        if (args.length != 2) {
            return null;
        }
        RolapNativeSet.CrossJoinArg[] cargs = this.checkCrossJoinArg(evaluator, args[0]);
        if (cargs == null) {
            return null;
        }
        if (this.isPreferInterpreter(cargs, false)) {
            return null;
        }
        SchemaReader schemaReader = evaluator.getSchemaReader();
        DataSource ds = schemaReader.getDataSource();
        SqlQuery sqlQuery = SqlQuery.newQuery(ds, "NativeFilter");
        RolapNativeSql sql = new RolapNativeSql(sqlQuery);
        String filterExpr = sql.generateFilterCondition(args[1]);
        if (filterExpr == null) {
            return null;
        }
        if (SqlConstraintUtils.containsCalculatedMember(evaluator.getMembers())) {
            return null;
        }
        LOGGER.debug((Object)"using native filter");
        evaluator = this.overrideContext(evaluator, cargs, sql.getStoredMeasure());
        FilterConstraint constraint = new FilterConstraint(cargs, evaluator, filterExpr);
        return new RolapNativeSet.SetEvaluator(this, cargs, schemaReader, constraint);
    }

    static class FilterConstraint
    extends RolapNativeSet.SetConstraint {
        String filterExpr;

        public FilterConstraint(RolapNativeSet.CrossJoinArg[] args, RolapEvaluator evaluator, String filterByExpr) {
            super(args, evaluator, true);
            this.filterExpr = filterByExpr;
        }

        protected boolean isJoinRequired() {
            return true;
        }

        public void addConstraint(SqlQuery sqlQuery, RolapCube baseCube) {
            sqlQuery.addHaving(this.filterExpr);
            super.addConstraint(sqlQuery, baseCube);
        }

        public Object getCacheKey() {
            ArrayList<Object> key = new ArrayList<Object>();
            key.add(super.getCacheKey());
            key.add(this.filterExpr);
            return key;
        }
    }
}

