/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import mondrian.mdx.MdxVisitorImpl;
import mondrian.mdx.MemberExpr;
import mondrian.olap.Access;
import mondrian.olap.CellFormatter;
import mondrian.olap.Cube;
import mondrian.olap.CubeBase;
import mondrian.olap.Dimension;
import mondrian.olap.DimensionType;
import mondrian.olap.Formula;
import mondrian.olap.Hierarchy;
import mondrian.olap.Id;
import mondrian.olap.Level;
import mondrian.olap.MatchType;
import mondrian.olap.Member;
import mondrian.olap.MemberProperty;
import mondrian.olap.MondrianDef;
import mondrian.olap.MondrianException;
import mondrian.olap.NamedSet;
import mondrian.olap.OlapElement;
import mondrian.olap.Property;
import mondrian.olap.Query;
import mondrian.olap.Role;
import mondrian.olap.RoleImpl;
import mondrian.olap.SchemaReader;
import mondrian.olap.Util;
import mondrian.resource.MondrianResource;
import mondrian.rolap.CacheMemberReader;
import mondrian.rolap.HierarchyUsage;
import mondrian.rolap.MeasureMemberSource;
import mondrian.rolap.MemberReader;
import mondrian.rolap.RolapAggregator;
import mondrian.rolap.RolapBaseCubeMeasure;
import mondrian.rolap.RolapCalculatedMember;
import mondrian.rolap.RolapConnection;
import mondrian.rolap.RolapCubeDimension;
import mondrian.rolap.RolapCubeHierarchy;
import mondrian.rolap.RolapCubeLevel;
import mondrian.rolap.RolapCubeUsages;
import mondrian.rolap.RolapDimension;
import mondrian.rolap.RolapHierarchy;
import mondrian.rolap.RolapLevel;
import mondrian.rolap.RolapMember;
import mondrian.rolap.RolapSchema;
import mondrian.rolap.RolapSchemaReader;
import mondrian.rolap.RolapStar;
import mondrian.rolap.RolapStoredMeasure;
import mondrian.rolap.RolapUtil;
import mondrian.rolap.RolapVirtualCubeMeasure;
import mondrian.rolap.aggmatcher.ExplicitRules;
import mondrian.rolap.cache.SoftSmartCache;
import org.apache.log4j.Logger;
import org.eigenbase.xom.DOMWrapper;
import org.eigenbase.xom.Parser;
import org.eigenbase.xom.XOMException;
import org.eigenbase.xom.XOMUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RolapCube
extends CubeBase {
    private static final Logger LOGGER = Logger.getLogger(RolapCube.class);
    private final RolapSchema schema;
    private final RolapHierarchy measuresHierarchy;
    final MondrianDef.Relation fact;
    private SchemaReader schemaReader;
    private Formula[] calculatedMembers;
    private final SoftSmartCache<Role, List<Member>> roleToAccessibleCalculatedMembers = new SoftSmartCache();
    private Formula[] namedSets;
    private final List<HierarchyUsage> hierarchyUsages;
    private RolapStar star;
    private ExplicitRules.Group aggGroup;
    private boolean load;
    private final Map<Hierarchy, HierarchyUsage> firstUsageMap = new HashMap<Hierarchy, HierarchyUsage>();
    private RolapCubeUsages cubeUsages;

    private RolapCube(RolapSchema schema, MondrianDef.Schema xmlSchema, String name, String caption, boolean isCache, MondrianDef.Relation fact, MondrianDef.CubeDimension[] dimensions, boolean load) {
        super(name, new RolapDimension[dimensions.length + 1]);
        this.schema = schema;
        this.caption = caption;
        this.fact = fact;
        this.hierarchyUsages = new ArrayList<HierarchyUsage>();
        this.calculatedMembers = new Formula[0];
        this.namedSets = new Formula[0];
        this.load = load;
        if (!this.isVirtual()) {
            this.star = schema.getRolapStarRegistry().getOrCreateStar(fact);
            if (!isCache) {
                this.star.setCacheAggregations(isCache);
            }
        }
        if (this.getLogger().isDebugEnabled()) {
            if (this.isVirtual()) {
                this.getLogger().debug((Object)("RolapCube<init>: virtual cube=" + this.name));
            } else {
                this.getLogger().debug((Object)("RolapCube<init>: cube=" + this.name));
            }
        }
        RolapDimension measuresDimension = new RolapDimension(schema, "Measures", DimensionType.MeasuresDimension);
        this.dimensions[0] = measuresDimension;
        this.measuresHierarchy = measuresDimension.newHierarchy(null, false);
        if (!Util.isEmpty(xmlSchema.measuresCaption)) {
            measuresDimension.setCaption(xmlSchema.measuresCaption);
            this.measuresHierarchy.setCaption(xmlSchema.measuresCaption);
        }
        for (int i = 0; i < dimensions.length; ++i) {
            MondrianDef.CubeDimension xmlCubeDimension = dimensions[i];
            RolapCubeDimension dimension = this.getOrCreateDimension(xmlCubeDimension, schema, xmlSchema, i + 1);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)("RolapCube<init>: dimension=" + dimension.getName()));
            }
            this.dimensions[i + 1] = dimension;
            if (!this.isVirtual()) {
                this.createUsages(dimension, xmlCubeDimension);
            }
            this.registerDimension(dimension);
        }
        schema.addCube(this);
    }

    RolapCube(RolapSchema schema, MondrianDef.Schema xmlSchema, MondrianDef.Cube xmlCube, boolean load) {
        this(schema, xmlSchema, xmlCube.name, xmlCube.caption, xmlCube.cache, xmlCube.fact, xmlCube.dimensions, load);
        if (this.fact == null) {
            throw Util.newError("Must specify fact table of cube '" + this.getName() + "'");
        }
        if (this.fact.getAlias() == null) {
            throw Util.newError("Must specify alias for fact table of cube '" + this.getName() + "'");
        }
        RolapLevel measuresLevel = this.measuresHierarchy.newMeasuresLevel();
        ArrayList<RolapMember> measureList = new ArrayList<RolapMember>(xmlCube.measures.length);
        RolapBaseCubeMeasure defaultMeasure = null;
        for (int i = 0; i < xmlCube.measures.length; ++i) {
            Boolean visible;
            MondrianDef.Expression measureExp;
            MondrianDef.Measure xmlMeasure = xmlCube.measures[i];
            if (xmlMeasure.column != null) {
                if (xmlMeasure.measureExp != null) {
                    throw MondrianResource.instance().BadMeasureSource.ex(xmlCube.name, xmlMeasure.name);
                }
                measureExp = new MondrianDef.Column(this.fact.getAlias(), xmlMeasure.column);
            } else if (xmlMeasure.measureExp != null) {
                measureExp = xmlMeasure.measureExp;
            } else {
                throw MondrianResource.instance().BadMeasureSource.ex(xmlCube.name, xmlMeasure.name);
            }
            String aggregator = xmlMeasure.aggregator;
            if (aggregator.equals("distinct count")) {
                aggregator = RolapAggregator.DistinctCount.getName();
            }
            RolapBaseCubeMeasure measure = new RolapBaseCubeMeasure(this, null, measuresLevel, xmlMeasure.name, xmlMeasure.formatString, measureExp, aggregator, xmlMeasure.datatype);
            measureList.add(measure);
            if (Util.equalName(measure.getName(), xmlCube.defaultMeasure)) {
                defaultMeasure = measure;
            }
            try {
                CellFormatter cellFormatter = RolapCube.getCellFormatter(xmlMeasure.formatter);
                if (cellFormatter != null) {
                    measure.setFormatter(cellFormatter);
                }
            }
            catch (Exception e) {
                throw MondrianResource.instance().CellFormatterLoadFailed.ex(xmlMeasure.formatter, measure.getUniqueName(), e);
            }
            if (!Util.isEmpty(xmlMeasure.caption)) {
                measure.setProperty(Property.CAPTION.name, xmlMeasure.caption);
            }
            if ((visible = xmlMeasure.visible) == null) {
                visible = Boolean.TRUE;
            }
            measure.setProperty(Property.VISIBLE.name, visible);
            ArrayList<String> propNames = new ArrayList<String>();
            ArrayList<String> propExprs = new ArrayList<String>();
            this.validateMemberProps(xmlMeasure.memberProperties, propNames, propExprs, xmlMeasure.name);
            int ordinal = i;
            for (int j = 0; j < propNames.size(); ++j) {
                String expr;
                String propName = (String)propNames.get(j);
                Object propExpr = propExprs.get(j);
                measure.setProperty(propName, propExpr);
                if (!propName.equals(Property.MEMBER_ORDINAL.name) || !(propExpr instanceof String) || !(expr = (String)propExpr).startsWith("\"") || !expr.endsWith("\"")) continue;
                try {
                    ordinal = Integer.valueOf(expr.substring(1, expr.length() - 1));
                    continue;
                }
                catch (NumberFormatException e) {
                    Util.discard((Object)e);
                }
            }
            measure.setOrdinal(ordinal);
        }
        this.setMeasuresHierarchyMemberReader(new CacheMemberReader(new MeasureMemberSource(this.measuresHierarchy, measureList)));
        this.measuresHierarchy.setDefaultMember(defaultMeasure);
        this.init(xmlCube.dimensions);
        this.init(xmlCube, measureList);
        this.setMeasuresHierarchyMemberReader(new CacheMemberReader(new MeasureMemberSource(this.measuresHierarchy, measureList)));
        this.checkOrdinals(xmlCube.name, measureList);
        this.loadAggGroup(xmlCube);
    }

    private void setMeasuresHierarchyMemberReader(MemberReader memberReader) {
        this.measuresHierarchy.setMemberReader(memberReader);
        this.schemaReader = null;
    }

    static CellFormatter getCellFormatter(String cellFormatterClassName) throws Exception {
        if (Util.isEmpty(cellFormatterClassName)) {
            return null;
        }
        Class<?> clazz = Class.forName(cellFormatterClassName);
        Constructor<?> ctor = clazz.getConstructor(new Class[0]);
        return (CellFormatter)ctor.newInstance(new Object[0]);
    }

    RolapCube(RolapSchema schema, MondrianDef.Schema xmlSchema, MondrianDef.VirtualCube xmlVirtualCube, boolean load) {
        this(schema, xmlSchema, xmlVirtualCube.name, xmlVirtualCube.caption, true, null, xmlVirtualCube.dimensions, load);
        RolapLevel measuresLevel = this.measuresHierarchy.newMeasuresLevel();
        ArrayList<RolapVirtualCubeMeasure> origMeasureList = new ArrayList<RolapVirtualCubeMeasure>();
        ArrayList<MondrianDef.CalculatedMember> origCalcMeasureList = new ArrayList<MondrianDef.CalculatedMember>();
        CubeComparator cubeComparator = new CubeComparator();
        TreeMap<RolapCube, ArrayList<MondrianDef.CalculatedMember>> calculatedMembersMap = new TreeMap<RolapCube, ArrayList<MondrianDef.CalculatedMember>>(cubeComparator);
        Member defaultMeasure = null;
        this.cubeUsages = new RolapCubeUsages(xmlVirtualCube.cubeUsage);
        for (MondrianDef.VirtualCubeMeasure xmlMeasure : xmlVirtualCube.measures) {
            RolapCube cube = schema.lookupCube(xmlMeasure.cubeName);
            Member[] cubeMeasures = cube.getMeasures();
            boolean found = false;
            for (Member cubeMeasure : cubeMeasures) {
                if (!cubeMeasure.getUniqueName().equals(xmlMeasure.name)) continue;
                if (cubeMeasure.getName().equalsIgnoreCase(xmlVirtualCube.defaultMeasure)) {
                    defaultMeasure = cubeMeasure;
                }
                found = true;
                if (cubeMeasure instanceof RolapCalculatedMember) {
                    MondrianDef.CalculatedMember calcMember = schema.lookupXmlCalculatedMember(xmlMeasure.name, xmlMeasure.cubeName);
                    if (calcMember == null) {
                        throw Util.newInternal("Could not find XML Calculated Member '" + xmlMeasure.name + "' in XML cube '" + xmlMeasure.cubeName + "'");
                    }
                    ArrayList<MondrianDef.CalculatedMember> memberList = (ArrayList<MondrianDef.CalculatedMember>)calculatedMembersMap.get(cube);
                    if (memberList == null) {
                        memberList = new ArrayList<MondrianDef.CalculatedMember>();
                    }
                    memberList.add(calcMember);
                    origCalcMeasureList.add(calcMember);
                    calculatedMembersMap.put(cube, memberList);
                    break;
                }
                RolapVirtualCubeMeasure virtualCubeMeasure = new RolapVirtualCubeMeasure(null, measuresLevel, (RolapStoredMeasure)cubeMeasure);
                Boolean visible = xmlMeasure.visible;
                if (visible == null) {
                    visible = Boolean.TRUE;
                }
                virtualCubeMeasure.setProperty(Property.VISIBLE.name, visible);
                virtualCubeMeasure.setProperty(Property.CAPTION.name, cubeMeasure.getCaption());
                origMeasureList.add(virtualCubeMeasure);
                break;
            }
            if (found) continue;
            throw Util.newInternal("could not find measure '" + xmlMeasure.name + "' in cube '" + xmlMeasure.cubeName + "'");
        }
        this.init(xmlVirtualCube.dimensions);
        ArrayList<RolapVirtualCubeMeasure> modifiedMeasureList = new ArrayList<RolapVirtualCubeMeasure>(origMeasureList);
        Iterator i$ = calculatedMembersMap.keySet().iterator();
        while (i$.hasNext()) {
            RolapCube o;
            RolapCube baseCube = o = (RolapCube)i$.next();
            List calculatedMemberList = (List)calculatedMembersMap.get(baseCube);
            Query queryExp = this.resolveCalcMembers(calculatedMemberList.toArray(new MondrianDef.CalculatedMember[calculatedMemberList.size()]), new MondrianDef.NamedSet[0], baseCube, false);
            MeasureFinder measureFinder = new MeasureFinder(this, baseCube, measuresLevel);
            queryExp.accept(measureFinder);
            modifiedMeasureList.addAll(measureFinder.getMeasuresFound());
        }
        ArrayList<MondrianDef.CalculatedMember> calculatedMemberList = new ArrayList<MondrianDef.CalculatedMember>();
        Iterator i$2 = calculatedMembersMap.keySet().iterator();
        while (i$2.hasNext()) {
            RolapCube o;
            RolapCube baseCube = o = (RolapCube)i$2.next();
            calculatedMemberList.addAll((Collection)calculatedMembersMap.get(baseCube));
        }
        calculatedMemberList.addAll(Arrays.asList(xmlVirtualCube.calculatedMembers));
        this.setMeasuresHierarchyMemberReader(new CacheMemberReader(new MeasureMemberSource(this.measuresHierarchy, Util.cast(modifiedMeasureList))));
        this.createCalcMembersAndNamedSets(calculatedMemberList.toArray(new MondrianDef.CalculatedMember[calculatedMemberList.size()]), xmlVirtualCube.namedSets, new ArrayList<RolapMember>(), new ArrayList<Formula>(), this, false);
        this.setMeasuresHierarchyMemberReader(new CacheMemberReader(new MeasureMemberSource(this.measuresHierarchy, Util.cast(origMeasureList))));
        this.measuresHierarchy.setDefaultMember(defaultMeasure);
        ArrayList<Formula> finalCalcMemberList = new ArrayList<Formula>();
        for (Formula calculatedMember : this.calculatedMembers) {
            if (this.findOriginalMembers(calculatedMember, origCalcMeasureList, finalCalcMemberList)) continue;
            this.findOriginalMembers(calculatedMember, Arrays.asList(xmlVirtualCube.calculatedMembers), finalCalcMemberList);
        }
        this.calculatedMembers = finalCalcMemberList.toArray(new Formula[finalCalcMemberList.size()]);
        for (Formula calcMember : finalCalcMemberList) {
            if (!calcMember.getName().equalsIgnoreCase(xmlVirtualCube.defaultMeasure)) continue;
            this.measuresHierarchy.setDefaultMember(calcMember.getMdxMember());
            break;
        }
    }

    private boolean findOriginalMembers(Formula formula, List<MondrianDef.CalculatedMember> calcMemberList, List<Formula> finalCalcMemberList) {
        for (MondrianDef.CalculatedMember xmlCalcMember : calcMemberList) {
            Dimension dimension = (Dimension)this.lookupDimension(new Id.Segment(xmlCalcMember.dimension, Id.Quoting.UNQUOTED));
            if (!formula.getName().equals(xmlCalcMember.name) || !formula.getMdxMember().getDimension().getName().equals(dimension.getName())) continue;
            finalCalcMemberList.add(formula);
            return true;
        }
        return false;
    }

    @Override
    protected Logger getLogger() {
        return LOGGER;
    }

    public boolean hasAggGroup() {
        return this.aggGroup != null;
    }

    public ExplicitRules.Group getAggGroup() {
        return this.aggGroup;
    }

    void loadAggGroup(MondrianDef.Cube xmlCube) {
        this.aggGroup = ExplicitRules.Group.make(this, xmlCube);
    }

    private RolapCubeDimension getOrCreateDimension(MondrianDef.CubeDimension xmlCubeDimension, RolapSchema schema, MondrianDef.Schema xmlSchema, int dimensionOrdinal) {
        RolapDimension dimension = null;
        if (xmlCubeDimension instanceof MondrianDef.DimensionUsage) {
            MondrianDef.DimensionUsage usage = (MondrianDef.DimensionUsage)xmlCubeDimension;
            RolapHierarchy sharedHierarchy = schema.getSharedHierarchy(usage.source);
            if (sharedHierarchy != null) {
                dimension = (RolapDimension)sharedHierarchy.getDimension();
            }
        }
        if (dimension == null) {
            MondrianDef.Dimension xmlDimension = xmlCubeDimension.getDimension(xmlSchema);
            dimension = new RolapDimension(schema, this, xmlDimension, xmlCubeDimension);
        }
        return new RolapCubeDimension(this, dimension, xmlCubeDimension, xmlCubeDimension.name, dimensionOrdinal);
    }

    private void init(MondrianDef.Cube xmlCube, List<RolapMember> memberList) {
        ArrayList<Formula> formulaList = new ArrayList<Formula>();
        this.createCalcMembersAndNamedSets(xmlCube.calculatedMembers, xmlCube.namedSets, memberList, formulaList, this, true);
    }

    private void checkOrdinals(String cubeName, List<RolapMember> measures) {
        HashMap<Integer, String> ordinals = new HashMap<Integer, String>();
        for (RolapMember measure : measures) {
            Integer ordinal = measure.getOrdinal();
            if (!ordinals.containsKey(ordinal)) {
                ordinals.put(ordinal, measure.getUniqueName());
                continue;
            }
            throw MondrianResource.instance().MeasureOrdinalsNotUnique.ex(cubeName, ordinal.toString(), (String)ordinals.get(ordinal), measure.getUniqueName());
        }
    }

    private void createCalcMembersAndNamedSets(MondrianDef.CalculatedMember[] xmlCalcMembers, MondrianDef.NamedSet[] xmlNamedSets, List<RolapMember> memberList, List<Formula> formulaList, RolapCube cube, boolean errOnDups) {
        int i;
        Query queryExp = this.resolveCalcMembers(xmlCalcMembers, xmlNamedSets, cube, errOnDups);
        if (queryExp == null) {
            return;
        }
        Util.assertTrue(queryExp.formulas.length == xmlCalcMembers.length + xmlNamedSets.length);
        for (i = 0; i < xmlCalcMembers.length; ++i) {
            this.postCalcMember(xmlCalcMembers, i, queryExp, memberList);
        }
        for (i = 0; i < xmlNamedSets.length; ++i) {
            this.postNamedSet(xmlNamedSets, xmlCalcMembers.length, i, queryExp, formulaList);
        }
    }

    private Query resolveCalcMembers(MondrianDef.CalculatedMember[] xmlCalcMembers, MondrianDef.NamedSet[] xmlNamedSets, RolapCube cube, boolean errOnDups) {
        Query queryExp;
        if (xmlCalcMembers.length == 0 && xmlNamedSets.length == 0) {
            return null;
        }
        StringBuilder buf = new StringBuilder(256);
        buf.append("WITH").append(Util.nl);
        for (int i = 0; i < xmlCalcMembers.length; ++i) {
            this.preCalcMember(xmlCalcMembers, i, buf, cube, errOnDups);
        }
        HashSet<String> nameSet = new HashSet<String>();
        for (Formula formula : this.namedSets) {
            nameSet.add(formula.getName());
        }
        for (MondrianDef.NamedSet namedSet : xmlNamedSets) {
            this.preNamedSet(namedSet, nameSet, buf);
        }
        buf.append("SELECT FROM ").append(cube.getUniqueName());
        String string = buf.toString();
        try {
            RolapConnection conn = this.schema.getInternalConnection();
            queryExp = conn.parseQuery(string, this.load);
        }
        catch (Exception e) {
            throw MondrianResource.instance().UnknownNamedSetHasBadFormula.ex(this.getName(), e);
        }
        queryExp.resolve();
        return queryExp;
    }

    private void postNamedSet(MondrianDef.NamedSet[] xmlNamedSets, int offset, int i, Query queryExp, List<Formula> formulaList) {
        MondrianDef.NamedSet xmlNamedSet = xmlNamedSets[i];
        Util.discard((Object)((Object)xmlNamedSet));
        Formula formula = queryExp.formulas[offset + i];
        this.namedSets = RolapUtil.addElement(this.namedSets, formula);
        formulaList.add(formula);
    }

    private void preNamedSet(MondrianDef.NamedSet xmlNamedSet, Set<String> nameSet, StringBuilder buf) {
        if (!nameSet.add(xmlNamedSet.name)) {
            throw MondrianResource.instance().NamedSetNotUnique.ex(xmlNamedSet.name, this.getName());
        }
        buf.append("SET ").append(Util.makeFqName(xmlNamedSet.name)).append(Util.nl).append(" AS ");
        Util.singleQuoteString(xmlNamedSet.getFormula(), buf);
        buf.append(Util.nl);
    }

    private void postCalcMember(MondrianDef.CalculatedMember[] xmlCalcMembers, int i, Query queryExp, List<RolapMember> memberList) {
        MondrianDef.CalculatedMember xmlCalcMember = xmlCalcMembers[i];
        Formula formula = queryExp.formulas[i];
        this.calculatedMembers = RolapUtil.addElement(this.calculatedMembers, formula);
        Member member = formula.getMdxMember();
        Boolean visible = xmlCalcMember.visible;
        if (visible == null) {
            visible = Boolean.TRUE;
        }
        member.setProperty(Property.VISIBLE.name, visible);
        if (xmlCalcMember.caption != null && xmlCalcMember.caption.length() > 0) {
            member.setProperty(Property.CAPTION.name, xmlCalcMember.caption);
        }
        memberList.add((RolapMember)formula.getMdxMember());
    }

    private void preCalcMember(MondrianDef.CalculatedMember[] xmlCalcMembers, int j, StringBuilder buf, RolapCube cube, boolean errOnDup) {
        MondrianDef.CalculatedMember xmlCalcMember = xmlCalcMembers[j];
        Dimension dimension = (Dimension)this.lookupDimension(new Id.Segment(xmlCalcMember.dimension, Id.Quoting.UNQUOTED));
        if (dimension == null) {
            throw MondrianResource.instance().CalcMemberHasBadDimension.ex(xmlCalcMember.dimension, xmlCalcMember.name, this.getName());
        }
        ArrayList<Formula> newCalcMemberList = new ArrayList<Formula>();
        for (Formula formula : this.calculatedMembers) {
            if (formula.getName().equals(xmlCalcMember.name) && formula.getMdxMember().getDimension().getName().equals(dimension.getName())) {
                if (!errOnDup) continue;
                throw MondrianResource.instance().CalcMemberNotUnique.ex(Util.makeFqName(dimension, xmlCalcMember.name), this.getName());
            }
            newCalcMemberList.add(formula);
        }
        this.calculatedMembers = newCalcMemberList.toArray(new Formula[newCalcMemberList.size()]);
        for (int k = 0; k < j; ++k) {
            MondrianDef.CalculatedMember xmlCalcMember2 = xmlCalcMembers[k];
            if (!xmlCalcMember2.name.equals(xmlCalcMember.name) || !xmlCalcMember2.dimension.equals(xmlCalcMember.dimension)) continue;
            throw MondrianResource.instance().CalcMemberNotUnique.ex(Util.makeFqName(dimension, xmlCalcMember.name), this.getName());
        }
        String memberUniqueName = Util.makeFqName(dimension.getUniqueName(), xmlCalcMember.name);
        MondrianDef.CalculatedMemberProperty[] xmlProperties = xmlCalcMember.memberProperties;
        ArrayList<String> propNames = new ArrayList<String>();
        ArrayList<String> propExprs = new ArrayList<String>();
        this.validateMemberProps(xmlProperties, propNames, propExprs, xmlCalcMember.name);
        int measureCount = cube.measuresHierarchy.getMemberReader().getMemberCount();
        assert (memberUniqueName.startsWith("["));
        buf.append("MEMBER ").append(memberUniqueName).append(Util.nl).append("  AS ");
        Util.singleQuoteString(xmlCalcMember.getFormula(), buf);
        assert (propNames.size() == propExprs.size());
        this.processFormatStringAttribute(xmlCalcMember, buf);
        for (int i = 0; i < propNames.size(); ++i) {
            String name = (String)propNames.get(i);
            String expr = (String)propExprs.get(i);
            buf.append(",").append(Util.nl);
            expr = this.removeSurroundingQuotesIfNumericProperty(name, expr);
            buf.append(name).append(" = ").append(expr);
        }
        buf.append(",").append(Util.nl).append(Util.quoteMdxIdentifier(Property.MEMBER_SCOPE.name)).append(" = 'CUBE'");
        if (!propNames.contains(Property.MEMBER_ORDINAL.getName())) {
            buf.append(",").append(Util.nl).append(Property.MEMBER_ORDINAL).append(" = ").append(measureCount + j);
        }
        buf.append(Util.nl);
    }

    private String removeSurroundingQuotesIfNumericProperty(String name, String expr) {
        Property prop = Property.lookup(name, false);
        if (prop != null && prop.getType() == Property.Datatype.TYPE_NUMERIC && this.isSurroundedWithQuotes(expr) && expr.length() > 2) {
            return expr.substring(1, expr.length() - 1);
        }
        return expr;
    }

    private boolean isSurroundedWithQuotes(String expr) {
        return expr.startsWith("\"") && expr.endsWith("\"");
    }

    void processFormatStringAttribute(MondrianDef.CalculatedMember xmlCalcMember, StringBuilder buf) {
        if (xmlCalcMember.formatString != null) {
            buf.append(",").append(Util.nl).append(Property.FORMAT_STRING.name).append(" = ").append(Util.quoteForMdx(xmlCalcMember.formatString));
        }
    }

    private void validateMemberProps(MondrianDef.CalculatedMemberProperty[] xmlProperties, List<String> propNames, List<String> propExprs, String memberName) {
        MemberProperty[] properties = new MemberProperty[xmlProperties.length];
        for (int i = 0; i < properties.length; ++i) {
            MondrianDef.CalculatedMemberProperty xmlProperty = xmlProperties[i];
            if (xmlProperty.expression == null && xmlProperty.value == null) {
                throw MondrianResource.instance().NeitherExprNorValueForCalcMemberProperty.ex(xmlProperty.name, memberName, this.getName());
            }
            if (xmlProperty.expression != null && xmlProperty.value != null) {
                throw MondrianResource.instance().ExprAndValueForMemberProperty.ex(xmlProperty.name, memberName, this.getName());
            }
            propNames.add(xmlProperty.name);
            if (xmlProperty.expression != null) {
                propExprs.add(xmlProperty.expression);
                continue;
            }
            propExprs.add(Util.quoteForMdx(xmlProperty.value));
        }
    }

    @Override
    public RolapSchema getSchema() {
        return this.schema;
    }

    @Override
    public NamedSet[] getNamedSets() {
        NamedSet[] namedSetsArray = new NamedSet[this.namedSets.length];
        for (int i = 0; i < this.namedSets.length; ++i) {
            namedSetsArray[i] = this.namedSets[i].getNamedSet();
        }
        return namedSetsArray;
    }

    public synchronized SchemaReader getSchemaReader() {
        if (this.schemaReader == null) {
            RoleImpl schemaDefaultRoleImpl = this.schema.getDefaultRole();
            RoleImpl roleImpl = schemaDefaultRoleImpl.makeMutableClone();
            roleImpl.grant(this, Access.ALL);
            RoleImpl role = roleImpl;
            this.schemaReader = new RolapCubeSchemaReader(role);
        }
        return this.schemaReader;
    }

    @Override
    public SchemaReader getSchemaReader(Role role) {
        if (role == null) {
            return this.getSchemaReader();
        }
        return new RolapCubeSchemaReader(role);
    }

    MondrianDef.CubeDimension lookup(MondrianDef.CubeDimension[] xmlDimensions, String name) {
        for (MondrianDef.CubeDimension cd : xmlDimensions) {
            if (!name.equals(cd.name)) continue;
            return cd;
        }
        return null;
    }

    private void init(MondrianDef.CubeDimension[] xmlDimensions) {
        for (Dimension dimension1 : this.dimensions) {
            RolapDimension dimension = (RolapDimension)dimension1;
            dimension.init(this.lookup(xmlDimensions, dimension.getName()));
        }
        this.register();
    }

    private void register() {
        Member[] measures;
        if (this.isVirtual()) {
            return;
        }
        ArrayList<Member> list = new ArrayList<Member>();
        for (Member measure : measures = this.getMeasures()) {
            if (!(measure instanceof RolapBaseCubeMeasure)) continue;
            list.add(measure);
        }
        RolapBaseCubeMeasure[] storedMeasures = list.toArray(new RolapBaseCubeMeasure[list.size()]);
        RolapStar star = this.getStar();
        RolapStar.Table table = star.getFactTable();
        for (RolapBaseCubeMeasure storedMeasure : storedMeasures) {
            table.makeMeasure(storedMeasure);
        }
    }

    public boolean isCacheAggregations() {
        return this.isVirtual() || this.star.isCacheAggregations();
    }

    public void setCacheAggregations(boolean cache) {
        if (!this.isVirtual()) {
            this.star.setCacheAggregations(cache);
        }
    }

    public void clearCachedAggregations() {
        this.clearCachedAggregations(false);
    }

    public void clearCachedAggregations(boolean forced) {
        if (this.isVirtual()) {
            for (RolapStar star1 : this.schema.getStars()) {
                star1.clearCachedAggregations(forced);
            }
        } else {
            this.star.clearCachedAggregations(forced);
        }
    }

    public void checkAggregateModifications() {
        if (this.isVirtual()) {
            this.schema.checkAggregateModifications();
        } else {
            this.star.checkAggregateModifications();
        }
    }

    public void pushAggregateModificationsToGlobalCache() {
        if (this.isVirtual()) {
            this.schema.pushAggregateModificationsToGlobalCache();
        } else {
            this.star.pushAggregateModificationsToGlobalCache();
        }
    }

    public RolapStar getStar() {
        return this.star;
    }

    private void createUsages(RolapCubeDimension dimension, MondrianDef.CubeDimension xmlCubeDimension) {
        RolapCubeHierarchy[] hierarchies = (RolapCubeHierarchy[])dimension.getHierarchies();
        if (hierarchies.length == 1) {
            this.createUsage(hierarchies[0], xmlCubeDimension);
        } else if (xmlCubeDimension instanceof MondrianDef.DimensionUsage && ((MondrianDef.DimensionUsage)xmlCubeDimension).level != null) {
            MondrianDef.DimensionUsage du = (MondrianDef.DimensionUsage)xmlCubeDimension;
            int cnt = 0;
            for (RolapCubeHierarchy hierarchy : hierarchies) {
                RolapLevel joinLevel;
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug((Object)("RolapCube<init>: hierarchy=" + hierarchy.getName()));
                }
                if ((joinLevel = (RolapLevel)Util.lookupHierarchyLevel(hierarchy, du.level)) == null) continue;
                this.createUsage(hierarchy, xmlCubeDimension);
                ++cnt;
            }
            if (cnt == 0) {
                this.createUsage(hierarchies[0], xmlCubeDimension);
            }
        } else {
            for (RolapCubeHierarchy hierarchy : hierarchies) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug((Object)("RolapCube<init>: hierarchy=" + hierarchy.getName()));
                }
                this.createUsage(hierarchy, xmlCubeDimension);
            }
        }
    }

    synchronized void createUsage(RolapCubeHierarchy hierarchy, MondrianDef.CubeDimension cubeDim) {
        HierarchyUsage usage = new HierarchyUsage(this, hierarchy, cubeDim);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("RolapCube.createUsage: cube=" + this.getName() + ", hierarchy=" + hierarchy.getName() + ", usage=" + usage));
        }
        for (HierarchyUsage hierUsage : this.hierarchyUsages) {
            if (!hierUsage.equals(usage)) continue;
            this.getLogger().warn((Object)("RolapCube.createUsage: duplicate " + hierUsage));
            return;
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)("RolapCube.createUsage: register " + usage));
        }
        this.hierarchyUsages.add(usage);
    }

    private synchronized HierarchyUsage getUsageByName(String name) {
        for (HierarchyUsage hierUsage : this.hierarchyUsages) {
            if (!hierUsage.getFullName().equals(name)) continue;
            return hierUsage;
        }
        return null;
    }

    public synchronized HierarchyUsage[] getUsages(Hierarchy hierarchy) {
        String name = hierarchy.getName();
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)("RolapCube.getUsages: name=" + name));
        }
        HierarchyUsage hierUsage = null;
        ArrayList<HierarchyUsage> list = null;
        for (HierarchyUsage hu : this.hierarchyUsages) {
            if (!hu.getHierarchyName().equals(name)) continue;
            if (list != null) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug((Object)("RolapCube.getUsages: add list HierarchyUsage.name=" + hu.getName()));
                }
                list.add(hu);
                continue;
            }
            if (hierUsage == null) {
                hierUsage = hu;
                continue;
            }
            list = new ArrayList<HierarchyUsage>();
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)("RolapCube.getUsages: add list hierUsage.name=" + hierUsage.getName() + ", hu.name=" + hu.getName()));
            }
            list.add(hierUsage);
            list.add(hu);
            hierUsage = null;
        }
        if (hierUsage != null) {
            return new HierarchyUsage[]{hierUsage};
        }
        if (list != null) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)"RolapCube.getUsages: return list");
            }
            return list.toArray(new HierarchyUsage[list.size()]);
        }
        return new HierarchyUsage[0];
    }

    synchronized HierarchyUsage getFirstUsage(Hierarchy hier) {
        HierarchyUsage[] hierarchyUsages;
        HierarchyUsage hierarchyUsage = this.firstUsageMap.get(hier);
        if (hierarchyUsage == null && (hierarchyUsages = this.getUsages(hier)).length != 0) {
            hierarchyUsage = hierarchyUsages[0];
            this.firstUsageMap.put(hier, hierarchyUsage);
        }
        return hierarchyUsage;
    }

    private synchronized HierarchyUsage[] getUsagesBySource(String source) {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)("RolapCube.getUsagesBySource: source=" + source));
        }
        HierarchyUsage hierUsage = null;
        ArrayList<HierarchyUsage> list = null;
        for (HierarchyUsage hu : this.hierarchyUsages) {
            String s = hu.getSource();
            if (s == null || !s.equals(source)) continue;
            if (list != null) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug((Object)("RolapCube.getUsagesBySource: add list HierarchyUsage.name=" + hu.getName()));
                }
                list.add(hu);
                continue;
            }
            if (hierUsage == null) {
                hierUsage = hu;
                continue;
            }
            list = new ArrayList<HierarchyUsage>();
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)("RolapCube.getUsagesBySource: add list hierUsage.name=" + hierUsage.getName() + ", hu.name=" + hu.getName()));
            }
            list.add(hierUsage);
            list.add(hu);
            hierUsage = null;
        }
        if (hierUsage != null) {
            return new HierarchyUsage[]{hierUsage};
        }
        if (list != null) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)"RolapCube.getUsagesBySource: return list");
            }
            return list.toArray(new HierarchyUsage[list.size()]);
        }
        return new HierarchyUsage[0];
    }

    void registerDimension(RolapCubeDimension dimension) {
        Hierarchy[] hierarchies;
        RolapStar star = this.getStar();
        for (Hierarchy hierarchy1 : hierarchies = dimension.getHierarchies()) {
            RolapHierarchy hierarchy = (RolapHierarchy)hierarchy1;
            MondrianDef.RelationOrJoin relation = hierarchy.getRelation();
            if (relation == null) continue;
            RolapLevel[] levels = (RolapCubeLevel[])hierarchy.getLevels();
            HierarchyUsage[] hierarchyUsages = this.getUsages(hierarchy);
            if (hierarchyUsages.length == 0) {
                if (!this.getLogger().isDebugEnabled()) continue;
                StringBuilder buf = new StringBuilder(64);
                buf.append("RolapCube.registerDimension: ");
                buf.append("hierarchyUsages == null for cube=\"");
                buf.append(this.name);
                buf.append("\", hierarchy=\"");
                buf.append(hierarchy.getName());
                buf.append("\"");
                this.getLogger().debug((Object)buf.toString());
                continue;
            }
            block1: for (HierarchyUsage hierarchyUsage : hierarchyUsages) {
                String usagePrefix = hierarchyUsage.getUsagePrefix();
                RolapStar.Table table = star.getFactTable();
                String levelName = hierarchyUsage.getLevelName();
                if (relation instanceof MondrianDef.Join) {
                    MondrianDef.RelationOrJoin relationTmp1 = relation;
                    if ((relation = RolapCube.reorder(relation, levels)) == null && this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug((Object)"RolapCube.registerDimension: after reorder relation==null");
                        this.getLogger().debug((Object)("RolapCube.registerDimension: reorder relationTmp1=" + RolapCube.format(relationTmp1)));
                    }
                }
                MondrianDef.RelationOrJoin relationTmp2 = relation;
                if (levelName != null) {
                    String tableName;
                    RolapLevel childLevel;
                    RolapLevel level = RolapLevel.lookupLevel(levels, levelName);
                    if (level == null) {
                        StringBuilder buf = new StringBuilder(64);
                        buf.append("For cube \"");
                        buf.append(this.getName());
                        buf.append("\" and HierarchyUsage [");
                        buf.append(hierarchyUsage);
                        buf.append("], there is no level with given");
                        buf.append(" level name \"");
                        buf.append(levelName);
                        buf.append("\"");
                        throw Util.newInternal(buf.toString());
                    }
                    if (relation instanceof MondrianDef.Join && (childLevel = (RolapLevel)level.getChildLevel()) != null && (tableName = childLevel.getTableName()) != null && (relation = RolapCube.snip(relation, tableName)) == null && this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug((Object)"RolapCube.registerDimension: after snip relation==null");
                        this.getLogger().debug((Object)("RolapCube.registerDimension: snip relationTmp2=" + RolapCube.format(relationTmp2)));
                    }
                }
                if (!relation.equals((Object)table.getRelation())) {
                    if (hierarchyUsage.getForeignKey() == null) {
                        throw MondrianResource.instance().HierarchyMustHaveForeignKey.ex(hierarchy.getName(), this.getName());
                    }
                    MondrianDef.Column column = new MondrianDef.Column(table.getAlias(), hierarchyUsage.getForeignKey());
                    RolapStar.Condition joinCondition = new RolapStar.Condition(column, hierarchyUsage.getJoinExp());
                    table = table.addJoin(this, relation, joinCondition);
                }
                RolapStar.Column parentColumn = null;
                if (levelName != null) {
                    for (RolapLevel level : levels) {
                        if (level.getKeyExp() != null) {
                            parentColumn = this.makeColumns(table, (RolapCubeLevel)level, parentColumn, usagePrefix);
                        }
                        if (levelName.equals(level.getName())) continue block1;
                    }
                    continue;
                }
                for (RolapLevel level : levels) {
                    if (level.getKeyExp() == null) continue;
                    parentColumn = this.makeColumns(table, (RolapCubeLevel)level, parentColumn, usagePrefix);
                }
            }
        }
    }

    protected RolapStar.Column makeColumns(RolapStar.Table table, RolapCubeLevel level, RolapStar.Column parentColumn, String usagePrefix) {
        String tableName = level.getTableName();
        if (tableName != null) {
            if (table.getAlias().equals(tableName)) {
                parentColumn = table.makeColumns(this, level, parentColumn, usagePrefix);
            } else if (table.equalsTableName(tableName)) {
                parentColumn = table.makeColumns(this, level, parentColumn, usagePrefix);
            } else {
                RolapStar.Table t = table.findAncestor(tableName);
                if (t != null) {
                    parentColumn = t.makeColumns(this, level, parentColumn, usagePrefix);
                } else {
                    StringBuilder buf = new StringBuilder(64);
                    buf.append("RolapCube.makeColumns: for cube \"");
                    buf.append(this.getName());
                    buf.append("\" the Level \"");
                    buf.append(level.getName());
                    buf.append("\" has a table name attribute \"");
                    buf.append(tableName);
                    buf.append("\" but the associated RolapStar does not");
                    buf.append(" have a table with that name.");
                    this.getLogger().warn((Object)buf.toString());
                    parentColumn = table.makeColumns(this, level, parentColumn, usagePrefix);
                }
            }
        } else {
            parentColumn = table.makeColumns(this, level, parentColumn, usagePrefix);
        }
        return parentColumn;
    }

    private static String format(MondrianDef.RelationOrJoin relation) {
        StringBuilder buf = new StringBuilder();
        RolapCube.format(relation, buf, "");
        return buf.toString();
    }

    private static void format(MondrianDef.RelationOrJoin relation, StringBuilder buf, String indent) {
        if (relation instanceof MondrianDef.Table) {
            MondrianDef.Table table = (MondrianDef.Table)relation;
            buf.append(indent);
            buf.append(table.name);
            if (table.alias != null) {
                buf.append('(');
                buf.append(table.alias);
                buf.append(')');
            }
            buf.append(Util.nl);
        } else {
            MondrianDef.Join join = (MondrianDef.Join)relation;
            String subindent = indent + "  ";
            buf.append(indent);
            buf.append(join.getLeftAlias());
            buf.append('.');
            buf.append(join.leftKey);
            buf.append('=');
            buf.append(join.getRightAlias());
            buf.append('.');
            buf.append(join.rightKey);
            buf.append(Util.nl);
            RolapCube.format(join.left, buf, subindent);
            RolapCube.format(join.right, buf, indent);
        }
    }

    public boolean shouldIgnoreUnrelatedDimensions(String baseCubeName) {
        return this.cubeUsages != null && this.cubeUsages.shouldIgnoreUnrelatedDimensions(baseCubeName);
    }

    private static MondrianDef.RelationOrJoin reorder(MondrianDef.RelationOrJoin relation, RolapLevel[] levels) {
        if (levels.length < 2) {
            return relation;
        }
        HashMap<String, RelNode> nodeMap = new HashMap<String, RelNode>();
        for (int i = 0; i < levels.length; ++i) {
            RolapLevel level = levels[i];
            if (level.isAll()) continue;
            String tableName = level.getTableName();
            if (tableName == null) {
                return relation;
            }
            RelNode rnode = new RelNode(tableName, i);
            nodeMap.put(tableName, rnode);
        }
        if (!RolapCube.validateNodes(relation, nodeMap)) {
            return relation;
        }
        relation = RolapCube.copy(relation);
        RolapCube.leftToRight(relation, nodeMap);
        RolapCube.topToBottom(relation);
        return relation;
    }

    private static boolean validateNodes(MondrianDef.RelationOrJoin relation, Map<String, RelNode> map) {
        if (relation instanceof MondrianDef.Relation) {
            MondrianDef.Relation table = (MondrianDef.Relation)relation;
            RelNode relNode = RelNode.lookup(table, map);
            return relNode != null;
        }
        if (relation instanceof MondrianDef.Join) {
            MondrianDef.Join join = (MondrianDef.Join)relation;
            return RolapCube.validateNodes(join.left, map) && RolapCube.validateNodes(join.right, map);
        }
        throw Util.newInternal("bad relation type " + (Object)((Object)relation));
    }

    private static int leftToRight(MondrianDef.RelationOrJoin relation, Map<String, RelNode> map) {
        if (relation instanceof MondrianDef.Relation) {
            MondrianDef.Relation table = (MondrianDef.Relation)relation;
            RelNode relNode = RelNode.lookup(table, map);
            relNode.table = table;
            return relNode.depth;
        }
        if (relation instanceof MondrianDef.Join) {
            MondrianDef.Join join = (MondrianDef.Join)relation;
            int leftDepth = RolapCube.leftToRight(join.left, map);
            int rightDepth = RolapCube.leftToRight(join.right, map);
            if (rightDepth > leftDepth) {
                String leftAlias = join.leftAlias;
                String leftKey = join.leftKey;
                MondrianDef.RelationOrJoin left = join.left;
                join.leftAlias = join.rightAlias;
                join.leftKey = join.rightKey;
                join.left = join.right;
                join.rightAlias = leftAlias;
                join.rightKey = leftKey;
                join.right = left;
            }
            return leftDepth;
        }
        throw Util.newInternal("bad relation type " + (Object)((Object)relation));
    }

    private static void topToBottom(MondrianDef.RelationOrJoin relation) {
        if (!(relation instanceof MondrianDef.Table) && relation instanceof MondrianDef.Join) {
            MondrianDef.Join join = (MondrianDef.Join)relation;
            while (join.left instanceof MondrianDef.Join) {
                MondrianDef.Join jleft = (MondrianDef.Join)join.left;
                join.right = new MondrianDef.Join(join.leftAlias, join.leftKey, jleft.right, join.rightAlias, join.rightKey, join.right);
                join.left = jleft.left;
                join.rightAlias = jleft.rightAlias;
                join.rightKey = jleft.rightKey;
                join.leftAlias = jleft.leftAlias;
                join.leftKey = jleft.leftKey;
            }
        }
    }

    private static MondrianDef.RelationOrJoin copy(MondrianDef.RelationOrJoin relation) {
        if (relation instanceof MondrianDef.Table) {
            MondrianDef.Table table = (MondrianDef.Table)relation;
            return new MondrianDef.Table(table);
        }
        if (relation instanceof MondrianDef.InlineTable) {
            MondrianDef.InlineTable table = (MondrianDef.InlineTable)relation;
            return new MondrianDef.InlineTable(table);
        }
        if (relation instanceof MondrianDef.Join) {
            MondrianDef.Join join = (MondrianDef.Join)relation;
            MondrianDef.RelationOrJoin left = RolapCube.copy(join.left);
            MondrianDef.RelationOrJoin right = RolapCube.copy(join.right);
            return new MondrianDef.Join(join.leftAlias, join.leftKey, left, join.rightAlias, join.rightKey, right);
        }
        throw Util.newInternal("bad relation type " + (Object)((Object)relation));
    }

    private static MondrianDef.RelationOrJoin snip(MondrianDef.RelationOrJoin relation, String tableName) {
        if (relation instanceof MondrianDef.Table) {
            MondrianDef.Table table = (MondrianDef.Table)relation;
            return table.alias != null && table.alias.equals(tableName) ? null : (table.name.equals(tableName) ? null : table);
        }
        if (relation instanceof MondrianDef.Join) {
            MondrianDef.Join join = (MondrianDef.Join)relation;
            MondrianDef.RelationOrJoin left = RolapCube.snip(join.left, tableName);
            if (left == null) {
                return join.right;
            }
            join.left = left;
            MondrianDef.RelationOrJoin right = RolapCube.snip(join.right, tableName);
            if (right == null) {
                return join.left;
            }
            join.right = right;
            return join;
        }
        throw Util.newInternal("bad relation type " + (Object)((Object)relation));
    }

    @Override
    public Member[] getMembersForQuery(String query, List<Member> calcMembers) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<Dimension> nonJoiningDimensions(Member[] tuple) {
        HashSet<Dimension> otherDims = new HashSet<Dimension>();
        for (Member member : tuple) {
            if (member.isCalculated()) continue;
            otherDims.add(member.getDimension());
        }
        return this.nonJoiningDimensions(otherDims);
    }

    @Override
    public Set<Dimension> nonJoiningDimensions(Set<Dimension> otherDims) {
        Dimension[] baseCubeDimensions = this.getDimensions();
        HashSet<String> baseCubeDimNames = new HashSet<String>();
        for (Dimension baseCubeDimension : baseCubeDimensions) {
            baseCubeDimNames.add(baseCubeDimension.getUniqueName());
        }
        HashSet<Dimension> nonJoiningDimensions = new HashSet<Dimension>();
        for (Dimension otherDim : otherDims) {
            if (baseCubeDimNames.contains(otherDim.getUniqueName())) continue;
            nonJoiningDimensions.add(otherDim);
        }
        return nonJoiningDimensions;
    }

    Member[] getMeasures() {
        Level measuresLevel = this.dimensions[0].getHierarchies()[0].getLevels()[0];
        return this.getSchemaReader().getLevelMembers(measuresLevel, true);
    }

    MondrianDef.RelationOrJoin getFact() {
        return this.fact;
    }

    public boolean isVirtual() {
        return this.fact == null;
    }

    RolapHierarchy findBaseCubeHierarchy(RolapHierarchy hierarchy) {
        for (int i = 0; i < this.getDimensions().length; ++i) {
            Dimension dimension = this.getDimensions()[i];
            if (!dimension.getName().equals(hierarchy.getDimension().getName())) continue;
            for (int j = 0; j < dimension.getHierarchies().length; ++j) {
                Hierarchy hier = dimension.getHierarchies()[j];
                if (!hier.getName().equals(hierarchy.getName())) continue;
                return (RolapHierarchy)hier;
            }
        }
        return null;
    }

    public RolapCubeLevel findBaseCubeLevel(RolapLevel level) {
        for (int i = 0; i < this.getDimensions().length; ++i) {
            Dimension dimension = this.getDimensions()[i];
            if (!dimension.getName().equals(level.getDimension().getName())) continue;
            for (int j = 0; j < dimension.getHierarchies().length; ++j) {
                Hierarchy hier = dimension.getHierarchies()[j];
                if (!hier.getName().equals(level.getHierarchy().getName())) continue;
                for (int k = 0; k < hier.getLevels().length; ++k) {
                    Level lvl = hier.getLevels()[k];
                    if (!lvl.getName().equals(level.getName())) continue;
                    return (RolapCubeLevel)lvl;
                }
            }
        }
        return null;
    }

    RolapCubeDimension createDimension(MondrianDef.CubeDimension xmlCubeDimension, MondrianDef.Schema xmlSchema) {
        RolapCubeDimension dimension = this.getOrCreateDimension(xmlCubeDimension, this.schema, xmlSchema, this.dimensions.length);
        if (!this.isVirtual()) {
            this.createUsages(dimension, xmlCubeDimension);
        }
        this.registerDimension(dimension);
        dimension.init(xmlCubeDimension);
        this.dimensions = RolapUtil.addElement(this.dimensions, dimension);
        return dimension;
    }

    @Override
    public OlapElement lookupChild(SchemaReader schemaReader, Id.Segment s) {
        return this.lookupChild(schemaReader, s, MatchType.EXACT);
    }

    @Override
    public OlapElement lookupChild(SchemaReader schemaReader, Id.Segment s, MatchType matchType) {
        HierarchyUsage[] usages;
        String status = null;
        OlapElement oe = super.lookupChild(schemaReader, s, MatchType.EXACT);
        if (oe == null && (usages = this.getUsagesBySource(s.name)).length > 0) {
            StringBuilder buf = new StringBuilder(64);
            buf.append("RolapCube.lookupChild: ");
            buf.append("In cube \"");
            buf.append(this.getName());
            buf.append("\" use of unaliased Dimension name \"");
            buf.append(s);
            if (usages.length == 1) {
                buf.append("\" rather than the alias name ");
                buf.append("\"");
                buf.append(usages[0].getName());
                buf.append("\" ");
                this.getLogger().error((Object)buf.toString());
                throw new MondrianException(buf.toString());
            }
            buf.append("\" rather than one of the alias names ");
            for (HierarchyUsage usage : usages) {
                buf.append("\"");
                buf.append(usage.getName());
                buf.append("\" ");
            }
            this.getLogger().error((Object)buf.toString());
            throw new MondrianException(buf.toString());
        }
        if (this.getLogger().isDebugEnabled()) {
            if (!s.matches("Measures")) {
                HierarchyUsage hierUsage = this.getUsageByName(s.name);
                status = hierUsage == null ? "hierUsage == null" : "hierUsage == " + (hierUsage.isShared() ? "shared" : "not shared");
            }
            StringBuilder buf = new StringBuilder(64);
            buf.append("RolapCube.lookupChild: ");
            buf.append("name=");
            buf.append(this.getName());
            buf.append(", childname=");
            buf.append(s);
            if (status != null) {
                buf.append(", status=");
                buf.append(status);
            }
            if (oe == null) {
                buf.append(" returning null");
            } else {
                buf.append(" returning elementname=").append(oe.getName());
            }
            this.getLogger().debug((Object)buf.toString());
        }
        return oe;
    }

    public Hierarchy getMeasuresHierarchy() {
        return this.measuresHierarchy;
    }

    public RolapMember[] getMeasuresMembers() {
        return this.measuresHierarchy.getMemberReader().getMembers();
    }

    @Override
    public Member createCalculatedMember(String xml) {
        MondrianDef.CalculatedMember xmlCalcMember;
        try {
            Parser xmlParser = XOMUtil.createDefaultParser();
            DOMWrapper def = xmlParser.parse(xml);
            String tagName = def.getTagName();
            if (!tagName.equals("CalculatedMember")) {
                throw new XOMException("Got <" + tagName + "> when expecting <CalculatedMember>");
            }
            xmlCalcMember = new MondrianDef.CalculatedMember(def);
        }
        catch (XOMException e) {
            throw Util.newError(e, "Error while creating calculated member from XML [" + xml + "]");
        }
        ArrayList<RolapMember> memberList = new ArrayList<RolapMember>();
        this.createCalcMembersAndNamedSets(new MondrianDef.CalculatedMember[]{xmlCalcMember}, new MondrianDef.NamedSet[0], memberList, new ArrayList<Formula>(), this, true);
        assert (memberList.size() == 1);
        return (Member)memberList.get(0);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CubeComparator
    implements Comparator<RolapCube> {
        private CubeComparator() {
        }

        @Override
        public int compare(RolapCube c1, RolapCube c2) {
            return c1.getName().compareTo(c2.getName());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MeasureFinder
    extends MdxVisitorImpl {
        private RolapCube virtualCube;
        private RolapCube baseCube;
        private RolapLevel measuresLevel;
        private List<RolapVirtualCubeMeasure> measuresFound;
        private List<RolapCalculatedMember> calcMembersSeen;

        public MeasureFinder(RolapCube virtualCube, RolapCube baseCube, RolapLevel measuresLevel) {
            this.virtualCube = virtualCube;
            this.baseCube = baseCube;
            this.measuresLevel = measuresLevel;
            this.measuresFound = new ArrayList<RolapVirtualCubeMeasure>();
            this.calcMembersSeen = new ArrayList<RolapCalculatedMember>();
        }

        @Override
        public Object visit(MemberExpr memberExpr) {
            RolapBaseCubeMeasure baseMeasure;
            RolapVirtualCubeMeasure virtualCubeMeasure;
            Member member = memberExpr.getMember();
            if (member instanceof RolapCalculatedMember) {
                if (this.calcMembersSeen.contains(member)) {
                    return null;
                }
                RolapCalculatedMember calcMember = (RolapCalculatedMember)member;
                Formula formula = calcMember.getFormula();
                formula.accept(this);
                this.calcMembersSeen.add(calcMember);
                this.virtualCube.setMeasuresHierarchyMemberReader(new CacheMemberReader(new MeasureMemberSource(this.virtualCube.measuresHierarchy, Util.cast(this.measuresFound))));
                MondrianDef.CalculatedMember xmlCalcMember = RolapCube.this.schema.lookupXmlCalculatedMember(calcMember.getUniqueName(), this.baseCube.name);
                RolapCube.this.createCalcMembersAndNamedSets(new MondrianDef.CalculatedMember[]{xmlCalcMember}, new MondrianDef.NamedSet[0], new ArrayList(), new ArrayList(), this.virtualCube, false);
                return null;
            }
            if (member instanceof RolapBaseCubeMeasure && !this.measuresFound.contains(virtualCubeMeasure = new RolapVirtualCubeMeasure(null, this.measuresLevel, baseMeasure = (RolapBaseCubeMeasure)member))) {
                this.measuresFound.add(virtualCubeMeasure);
            }
            return null;
        }

        public List<RolapVirtualCubeMeasure> getMeasuresFound() {
            return this.measuresFound;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RolapCubeSchemaReader
    extends RolapSchemaReader {
        public RolapCubeSchemaReader(Role role) {
            super(role, RolapCube.this.schema);
            assert (role != null) : "precondition: role != null";
        }

        @Override
        public Member[] getLevelMembers(Level level, boolean includeCalculated) {
            Member[] members = super.getLevelMembers(level, false);
            if (includeCalculated) {
                members = Util.addLevelCalculatedMembers(this, level, members);
            }
            return members;
        }

        @Override
        public Member getCalculatedMember(List<Id.Segment> nameParts) {
            String uniqueName = Util.implode(nameParts);
            for (Formula formula : RolapCube.this.calculatedMembers) {
                String formulaUniqueName = formula.getMdxMember().getUniqueName();
                if (!formulaUniqueName.equals(uniqueName) || !this.getRole().canAccess(formula.getMdxMember())) continue;
                return formula.getMdxMember();
            }
            return null;
        }

        @Override
        public NamedSet getNamedSet(List<Id.Segment> segments) {
            if (segments.size() == 1) {
                Id.Segment segment = segments.get(0);
                for (Formula namedSet : RolapCube.this.namedSets) {
                    if (!segment.matches(namedSet.getName())) continue;
                    return namedSet.getNamedSet();
                }
            }
            return super.getNamedSet(segments);
        }

        @Override
        public List<Member> getCalculatedMembers(Hierarchy hierarchy) {
            ArrayList<Member> list = new ArrayList<Member>();
            if (this.getRole().getAccess(hierarchy) == Access.NONE) {
                return list;
            }
            for (Member member : this.getCalculatedMembers()) {
                if (!member.getHierarchy().equals(hierarchy)) continue;
                list.add(member);
            }
            return list;
        }

        @Override
        public List<Member> getCalculatedMembers(Level level) {
            ArrayList<Member> list = new ArrayList<Member>();
            if (this.getRole().getAccess(level) == Access.NONE) {
                return list;
            }
            for (Member member : this.getCalculatedMembers()) {
                if (!member.getLevel().equals(level)) continue;
                list.add(member);
            }
            return list;
        }

        @Override
        public List<Member> getCalculatedMembers() {
            ArrayList<Member> list = (ArrayList<Member>)RolapCube.this.roleToAccessibleCalculatedMembers.get(this.getRole());
            if (list == null) {
                list = new ArrayList<Member>();
                for (Formula formula : RolapCube.this.calculatedMembers) {
                    Member member = formula.getMdxMember();
                    if (!this.getRole().canAccess(member)) continue;
                    list.add(member);
                }
                if (list.size() > 0) {
                    RolapCube.this.roleToAccessibleCalculatedMembers.put(this.getRole(), list);
                }
            }
            return list;
        }

        @Override
        public Member getMemberByUniqueName(List<Id.Segment> uniqueNameParts, boolean failIfNotFound, MatchType matchType) {
            Member member = (Member)this.lookupCompound(RolapCube.this, uniqueNameParts, failIfNotFound, 6, matchType);
            if (!failIfNotFound && member == null) {
                return null;
            }
            if (this.getRole().canAccess(member)) {
                return member;
            }
            return null;
        }

        @Override
        public Cube getCube() {
            return RolapCube.this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RelNode {
        private int depth;
        private String alias;
        private MondrianDef.Relation table;

        private static RelNode lookup(MondrianDef.Relation table, Map<String, RelNode> map) {
            RelNode relNode;
            if (table instanceof MondrianDef.Table && (relNode = map.get(((MondrianDef.Table)table).name)) != null) {
                return relNode;
            }
            return map.get(table.getAlias());
        }

        RelNode(String alias, int depth) {
            this.alias = alias;
            this.depth = depth;
        }
    }
}

