/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.util.Collections;
import java.util.List;
import mondrian.olap.Id;
import mondrian.olap.Util;
import mondrian.resource.MondrianResource;
import mondrian.rolap.MemberCache;
import mondrian.rolap.MemberSource;
import mondrian.rolap.RolapHierarchy;
import mondrian.rolap.RolapMember;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class ArrayMemberSource
implements MemberSource {
    protected final RolapHierarchy hierarchy;
    protected final RolapMember[] members;

    ArrayMemberSource(RolapHierarchy hierarchy, RolapMember[] members) {
        this.hierarchy = hierarchy;
        this.members = members;
    }

    @Override
    public RolapHierarchy getHierarchy() {
        return this.hierarchy;
    }

    @Override
    public boolean setCache(MemberCache cache) {
        return false;
    }

    @Override
    public RolapMember[] getMembers() {
        return this.members;
    }

    @Override
    public int getMemberCount() {
        return this.members.length;
    }

    @Override
    public List<RolapMember> getRootMembers() {
        return Collections.emptyList();
    }

    @Override
    public void getMemberChildren(RolapMember parentMember, List<RolapMember> children) {
    }

    @Override
    public void getMemberChildren(List<RolapMember> parentMembers, List<RolapMember> children) {
    }

    @Override
    public RolapMember lookupMember(List<Id.Segment> uniqueNameParts, boolean failIfNotFound) {
        String uniqueName = Util.implode(uniqueNameParts);
        for (RolapMember member : this.members) {
            if (!member.getUniqueName().equals(uniqueName)) continue;
            return member;
        }
        if (failIfNotFound) {
            throw MondrianResource.instance().MdxCantFindMember.ex(uniqueName);
        }
        return null;
    }
}

