/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import java.util.ArrayList;
import java.util.List;
import mondrian.calc.Calc;
import mondrian.calc.ExpCompiler;
import mondrian.calc.IntegerCalc;
import mondrian.calc.ListCalc;
import mondrian.calc.ResultStyle;
import mondrian.calc.impl.AbstractListCalc;
import mondrian.mdx.ResolvedFunCall;
import mondrian.olap.Dimension;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.FunDef;
import mondrian.olap.Member;
import mondrian.olap.NativeEvaluator;
import mondrian.olap.SchemaReader;
import mondrian.olap.fun.FunDefBase;
import mondrian.olap.fun.FunUtil;
import mondrian.olap.fun.MultiResolver;
import mondrian.olap.type.TupleType;

class TopBottomCountFunDef
extends FunDefBase {
    boolean top;
    static final MultiResolver TopCountResolver = new MultiResolver("TopCount", "TopCount(<Set>, <Count>[, <Numeric Expression>])", "Returns a specified number of items from the top of a set, optionally ordering the set first.", new String[]{"fxxnn", "fxxn"}){

        protected FunDef createFunDef(Exp[] args, FunDef dummyFunDef) {
            return new TopBottomCountFunDef(dummyFunDef, true);
        }
    };
    static final MultiResolver BottomCountResolver = new MultiResolver("BottomCount", "BottomCount(<Set>, <Count>[, <Numeric Expression>])", "Returns a specified number of items from the bottom of a set, optionally ordering the set first.", new String[]{"fxxnn", "fxxn"}){

        protected FunDef createFunDef(Exp[] args, FunDef dummyFunDef) {
            return new TopBottomCountFunDef(dummyFunDef, false);
        }
    };

    public TopBottomCountFunDef(FunDef dummyFunDef, boolean top) {
        super(dummyFunDef);
        this.top = top;
    }

    public Calc compileCall(final ResolvedFunCall call, ExpCompiler compiler) {
        final ListCalc listCalc = compiler.compileList(call.getArg(0), true);
        final IntegerCalc integerCalc = compiler.compileInteger(call.getArg(1));
        final Calc orderCalc = call.getArgCount() > 2 ? compiler.compileScalar(call.getArg(2), true) : null;
        final int arity = call.getType() instanceof TupleType ? ((TupleType)call.getType()).elementTypes.length : 1;
        return new AbstractListCalc(call, new Calc[]{listCalc, integerCalc, orderCalc}){

            public List evaluateList(Evaluator evaluator) {
                SchemaReader schemaReader = evaluator.getSchemaReader();
                NativeEvaluator nativeEvaluator = schemaReader.getNativeSetEvaluator(call.getFunDef(), call.getArgs(), evaluator, this);
                if (nativeEvaluator != null) {
                    return (List)nativeEvaluator.execute(ResultStyle.LIST);
                }
                List<Member> list = listCalc.evaluateList(evaluator);
                int n = integerCalc.evaluateInteger(evaluator);
                if (n == -2147483647) {
                    return new ArrayList();
                }
                if (orderCalc != null) {
                    if (arity == 1) {
                        FunUtil.sortMembers(evaluator.push(), list, orderCalc, TopBottomCountFunDef.this.top, true);
                    } else {
                        FunUtil.sortTuples(evaluator.push(), list, orderCalc, TopBottomCountFunDef.this.top, true, arity);
                    }
                }
                if (n < list.size()) {
                    list = list.subList(0, n);
                }
                return list;
            }

            public boolean dependsOn(Dimension dimension) {
                return 3.anyDependsButFirst(this.getCalcs(), dimension);
            }
        };
    }
}

