/*
 * Decompiled with CFR 0.152.
 */
package mondrian.calc.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import mondrian.calc.BooleanCalc;
import mondrian.calc.DateTimeCalc;
import mondrian.calc.DimensionCalc;
import mondrian.calc.DoubleCalc;
import mondrian.calc.HierarchyCalc;
import mondrian.calc.IntegerCalc;
import mondrian.calc.IterCalc;
import mondrian.calc.LevelCalc;
import mondrian.calc.ListCalc;
import mondrian.calc.MemberCalc;
import mondrian.calc.StringCalc;
import mondrian.calc.TupleCalc;
import mondrian.calc.VoidCalc;
import mondrian.calc.impl.AbstractCalc;
import mondrian.olap.Dimension;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.Hierarchy;
import mondrian.olap.Level;
import mondrian.olap.Member;

public abstract class GenericCalc
extends AbstractCalc
implements ListCalc,
IterCalc,
TupleCalc,
StringCalc,
IntegerCalc,
DoubleCalc,
BooleanCalc,
DateTimeCalc,
VoidCalc,
MemberCalc,
LevelCalc,
HierarchyCalc,
DimensionCalc {
    protected GenericCalc(Exp exp) {
        super(exp);
    }

    public List evaluateList(Evaluator evaluator) {
        Object o = this.evaluate(evaluator);
        if (o instanceof List) {
            return (List)o;
        }
        Iterable iter = (Iterable)o;
        Iterator it = iter.iterator();
        ArrayList list = new ArrayList();
        while (it.hasNext()) {
            list.add(it.next());
        }
        return list;
    }

    public Iterable evaluateIterable(Evaluator evaluator) {
        Object o = this.evaluate(evaluator);
        if (o instanceof Iterable) {
            return (Iterable)o;
        }
        final List list = (List)o;
        return new Iterable(){

            public Iterator iterator() {
                return list.iterator();
            }
        };
    }

    public Member[] evaluateTuple(Evaluator evaluator) {
        return (Member[])this.evaluate(evaluator);
    }

    public String evaluateString(Evaluator evaluator) {
        return (String)this.evaluate(evaluator);
    }

    public int evaluateInteger(Evaluator evaluator) {
        Object o = this.evaluate(evaluator);
        Number number = (Number)o;
        return number == null ? -2147483647 : number.intValue();
    }

    public double evaluateDouble(Evaluator evaluator) {
        Object o = this.evaluate(evaluator);
        Number number = (Number)o;
        return GenericCalc.numberToDouble(number);
    }

    public static double numberToDouble(Number number) {
        return number == null ? 1.2345E-8 : number.doubleValue();
    }

    public boolean evaluateBoolean(Evaluator evaluator) {
        return (Boolean)this.evaluate(evaluator);
    }

    public Date evaluateDateTime(Evaluator evaluator) {
        return (Date)this.evaluate(evaluator);
    }

    public void evaluateVoid(Evaluator evaluator) {
        Object result = this.evaluate(evaluator);
        assert (result == null);
    }

    public Member evaluateMember(Evaluator evaluator) {
        return (Member)this.evaluate(evaluator);
    }

    public Level evaluateLevel(Evaluator evaluator) {
        return (Level)this.evaluate(evaluator);
    }

    public Hierarchy evaluateHierarchy(Evaluator evaluator) {
        return (Hierarchy)this.evaluate(evaluator);
    }

    public Dimension evaluateDimension(Evaluator evaluator) {
        return (Dimension)this.evaluate(evaluator);
    }
}

