/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.gui.wizard;

import it.businesslogic.ireport.Group;
import it.businesslogic.ireport.JRField;
import it.businesslogic.ireport.JRParameter;
import it.businesslogic.ireport.JRVariable;
import it.businesslogic.ireport.Report;
import it.businesslogic.ireport.SubReportElement;
import it.businesslogic.ireport.gui.JRTextExpressionArea;
import it.businesslogic.ireport.gui.JReportFrame;
import it.businesslogic.ireport.gui.MainFrame;
import it.businesslogic.ireport.gui.event.ReportBandChangedEvent;
import it.businesslogic.ireport.gui.wizard.BaseWizardPanel;
import it.businesslogic.ireport.gui.wizard.GenericWizard;
import it.businesslogic.ireport.util.I18n;
import it.businesslogic.ireport.util.Misc;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class ReportGroupWizard
extends JPanel
implements GenericWizard {
    private String reportFileName = null;
    private SubReportElement subReportElement = null;
    private BaseWizardPanel wizardPanel = null;
    private JDialog wizardDialog = null;
    private JReportFrame jReportFrame = null;
    Vector templates = null;
    private Thread t = null;
    private ButtonGroup buttonGroup1;
    private JCheckBox jCheckBox1;
    private JCheckBox jCheckBox2;
    private JComboBox jComboBoxObject;
    private JLabel jLabel1;
    private JLabel jLabelErrorMessage;
    private JPanel jPanel0;
    private JPanel jPanel1;
    private JPanel jPanel6;
    private JPanel jPanel61;
    private JRTextExpressionArea jRTextExpressionArea;
    private JRadioButton jRadioButton1;
    private JRadioButton jRadioButton2;
    private JTextField jTextField1;

    public ReportGroupWizard() {
        this.initComponents();
        this.applyI18n();
        this.jRTextExpressionArea.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent e) {
                if (ReportGroupWizard.this.wizardPanel != null) {
                    ReportGroupWizard.this.wizardPanel.updateButtons();
                }
            }

            public void insertUpdate(DocumentEvent e) {
                if (ReportGroupWizard.this.wizardPanel != null) {
                    ReportGroupWizard.this.wizardPanel.updateButtons();
                }
            }

            public void removeUpdate(DocumentEvent e) {
                if (ReportGroupWizard.this.wizardPanel != null) {
                    ReportGroupWizard.this.wizardPanel.updateButtons();
                }
            }
        });
        this.jTextField1.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent e) {
                if (ReportGroupWizard.this.wizardPanel != null) {
                    ReportGroupWizard.this.wizardPanel.updateButtons();
                }
            }

            public void insertUpdate(DocumentEvent e) {
                if (ReportGroupWizard.this.wizardPanel != null) {
                    ReportGroupWizard.this.wizardPanel.updateButtons();
                }
            }

            public void removeUpdate(DocumentEvent e) {
                if (ReportGroupWizard.this.wizardPanel != null) {
                    ReportGroupWizard.this.wizardPanel.updateButtons();
                }
            }
        });
        Vector values = new Vector();
        Report report = MainFrame.getMainInstance().getActiveReportFrame().getReport();
        values.addAll(report.getFields());
        values.addAll(report.getVariables());
        values.addAll(report.getParameters());
        for (int i = 0; i < values.size(); ++i) {
            this.jComboBoxObject.addItem(values.elementAt(i));
        }
    }

    public void startWizard() {
        this.setJReportFrame(MainFrame.getMainInstance().getActiveReportFrame());
        this.wizardDialog = new JDialog((Frame)MainFrame.getMainInstance(), true);
        this.wizardPanel = new BaseWizardPanel();
        this.wizardPanel.setGenericWizard(this);
        this.wizardDialog.getContentPane().add(this.wizardPanel);
        this.wizardDialog.pack();
        Misc.centerFrame(this.wizardDialog);
        this.wizardDialog.setVisible(true);
    }

    private void initComponents() {
        this.jPanel0 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jTextField1 = new JTextField();
        this.jLabelErrorMessage = new JLabel();
        this.jPanel61 = new JPanel();
        this.jPanel6 = new JPanel();
        this.jRadioButton1 = new JRadioButton();
        this.jComboBoxObject = new JComboBox();
        this.jRadioButton2 = new JRadioButton();
        this.jRTextExpressionArea = new JRTextExpressionArea();
        this.buttonGroup1 = new ButtonGroup();
        this.jPanel1 = new JPanel();
        this.jCheckBox1 = new JCheckBox();
        this.jCheckBox2 = new JCheckBox();
        this.jPanel0.setLayout(new GridBagLayout());
        this.jPanel0.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                ReportGroupWizard.this.jPanel0PropertyChange(evt);
            }
        });
        this.jLabel1.setText("Group name");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 24, 0, 24);
        this.jPanel0.add((Component)this.jLabel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 24, 0, 10);
        this.jPanel0.add((Component)this.jTextField1, gridBagConstraints);
        this.jLabelErrorMessage.setForeground(new Color(204, 0, 51));
        this.jLabelErrorMessage.setText(" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 24, 15, 10);
        this.jPanel0.add((Component)this.jLabelErrorMessage, gridBagConstraints);
        this.jPanel61.setMinimumSize(new Dimension(10, 30));
        this.jPanel61.setPreferredSize(new Dimension(10, 30));
        this.jPanel0.add((Component)this.jPanel61, new GridBagConstraints());
        this.jPanel6.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanel0.add((Component)this.jPanel6, gridBagConstraints);
        this.buttonGroup1.add(this.jRadioButton1);
        this.jRadioButton1.setSelected(true);
        this.jRadioButton1.setText("Group by the following report object:");
        this.jRadioButton1.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jRadioButton1.setMargin(new Insets(0, 0, 0, 0));
        this.jRadioButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ReportGroupWizard.this.jRadioButton1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(8, 24, 0, 10);
        this.jPanel0.add((Component)this.jRadioButton1, gridBagConstraints);
        this.jComboBoxObject.setMinimumSize(new Dimension(51, 22));
        this.jComboBoxObject.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ReportGroupWizard.this.jComboBoxObjectActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 40, 0, 10);
        this.jPanel0.add((Component)this.jComboBoxObject, gridBagConstraints);
        this.buttonGroup1.add(this.jRadioButton2);
        this.jRadioButton2.setText("Group by the following expression:");
        this.jRadioButton2.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jRadioButton2.setMargin(new Insets(0, 0, 0, 0));
        this.jRadioButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ReportGroupWizard.this.jRadioButton2ActionPerformed(evt);
            }
        });
        this.jRadioButton2.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                ReportGroupWizard.this.jRadioButton2PropertyChange(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(16, 24, 0, 10);
        this.jPanel0.add((Component)this.jRadioButton2, gridBagConstraints);
        this.jRTextExpressionArea.setBorder(BorderFactory.createEtchedBorder());
        this.jRTextExpressionArea.setElectricScroll(0);
        this.jRTextExpressionArea.setMinimumSize(new Dimension(300, 47));
        this.jRTextExpressionArea.setPreferredSize(new Dimension(300, 120));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 40, 10, 6);
        this.jPanel0.add((Component)this.jRTextExpressionArea, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        this.jPanel1.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                ReportGroupWizard.this.jPanel1PropertyChange(evt);
            }
        });
        this.jCheckBox1.setSelected(true);
        this.jCheckBox1.setText("Add the group header");
        this.jCheckBox1.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jCheckBox1.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(24, 24, 0, 24);
        this.jPanel1.add((Component)this.jCheckBox1, gridBagConstraints);
        this.jCheckBox2.setSelected(true);
        this.jCheckBox2.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jCheckBox2.setText("Add the group footer");
        this.jCheckBox2.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(8, 24, 0, 24);
        this.jPanel1.add((Component)this.jCheckBox2, gridBagConstraints);
        this.setLayout(new BorderLayout());
    }

    private void jRadioButton1ActionPerformed(ActionEvent evt) {
        if (this.wizardPanel != null) {
            this.wizardPanel.updateButtons();
        }
    }

    private void jRadioButton2ActionPerformed(ActionEvent evt) {
        if (this.wizardPanel != null) {
            this.wizardPanel.updateButtons();
        }
    }

    private void jRadioButton2PropertyChange(PropertyChangeEvent evt) {
    }

    private void jPanel1PropertyChange(PropertyChangeEvent evt) {
    }

    private void jComboBoxObjectActionPerformed(ActionEvent evt) {
        if (this.wizardPanel != null) {
            this.wizardPanel.updateButtons();
        }
    }

    private void jPanel0PropertyChange(PropertyChangeEvent evt) {
    }

    public String[] getStepsNames() {
        String[] names = new String[]{I18n.getString("reportGroupWizard.stepsnames.criteria", "Criteria"), I18n.getString("reportGroupWizard.stepsnames.details", "Details")};
        return names;
    }

    public String getStepDescription(int step) {
        if (step == 0) {
            return I18n.getString("reportGroupWizard.stepdescription.step0", "Choose the group by criteria");
        }
        if (step == 1) {
            return I18n.getString("reportGroupWizard.stepdescription.step1", "Group details");
        }
        return "";
    }

    public void initWizard() {
    }

    public void finish(int currentStep) {
        if (currentStep != -1) {
            Report report = this.getJReportFrame().getReport();
            Group grp = new Group(report, this.jTextField1.getText().trim());
            int available_vertical_space = report.getAvailableVerticalSpace();
            if (this.jCheckBox1.isSelected() && this.jCheckBox2.isSelected()) {
                available_vertical_space /= 2;
            }
            if (available_vertical_space > 50) {
                available_vertical_space = 50;
            }
            if (this.jCheckBox1.isSelected()) {
                grp.getGroupHeader().setHeight(available_vertical_space);
            }
            if (this.jCheckBox2.isSelected()) {
                grp.getGroupFooter().setHeight(available_vertical_space);
            }
            if (this.jRadioButton1.isSelected()) {
                Object obj = this.jComboBoxObject.getSelectedItem();
                if (obj != null && ("" + obj).trim().length() > 0) {
                    if (obj instanceof JRParameter) {
                        obj = "$P{" + obj + "}";
                    } else if (obj instanceof JRVariable) {
                        obj = "$V{" + obj + "}";
                    } else if (obj instanceof JRField) {
                        obj = "$F{" + obj + "}";
                    }
                    grp.setGroupExpression("" + obj);
                }
            } else {
                grp.setGroupExpression(this.jRTextExpressionArea.getText().trim());
            }
            report.addGroup(grp, true);
            this.getJReportFrame().repaint();
            MainFrame.getMainInstance().getGroupsDialog().updateGroups();
            MainFrame.getMainInstance().getBandsDialog().updateBands();
            MainFrame.getMainInstance().getElementPropertiesDialog().updateBands();
            MainFrame.getMainInstance().getElementPropertiesDialog().updateGroups();
            MainFrame.getMainInstance().reportBandChanged(new ReportBandChangedEvent(this.getJReportFrame(), null, 2));
        }
        this.getWizardDialog().setVisible(false);
        this.getWizardDialog().dispose();
    }

    public boolean nextStep(int nextStep) {
        if (nextStep == 0 || nextStep == 1) {
            // empty if block
        }
        return true;
    }

    public boolean previousStep(int previousStep) {
        return true;
    }

    public boolean canFinish(int currentStep) {
        if (currentStep > 0) {
            return true;
        }
        return this.canNext(currentStep);
    }

    public boolean canNext(int currentStep) {
        if (currentStep == 0) {
            if (this.jTextField1.getText().trim().length() == 0) {
                return false;
            }
            Vector v = this.getJReportFrame().getReport().getGroups();
            String s = this.jTextField1.getText().trim();
            this.jLabelErrorMessage.setText(" ");
            for (int i = 0; i < v.size(); ++i) {
                if (!s.equals(((Group)v.elementAt(i)).getName())) continue;
                String msg = new String(I18n.getString("reportGroupWizard.jLabelErrorMessage", "This group name is already in use."));
                this.jLabelErrorMessage.setText(msg);
                return false;
            }
            if (this.jRadioButton1.isSelected() && this.jComboBoxObject.getSelectedItem() != null) {
                return true;
            }
            if (this.jRadioButton2.isSelected() && this.jRTextExpressionArea.getText().trim().length() > 0) {
                return true;
            }
        } else if (currentStep == 1) {
            return false;
        }
        return false;
    }

    public boolean canPrevious(int currentStep) {
        return currentStep > 0;
    }

    public JPanel getStepPanel(int step) {
        if (step == 0) {
            return this.jPanel0;
        }
        if (step == 1) {
            return this.jPanel1;
        }
        return null;
    }

    public String getReportFileName() {
        return this.reportFileName;
    }

    public void setReportFileName(String reportFileName) {
        this.reportFileName = reportFileName;
    }

    public SubReportElement getSubReportElement() {
        return this.subReportElement;
    }

    public void setSubReportElement(SubReportElement subReportElement) {
        this.subReportElement = subReportElement;
    }

    public BaseWizardPanel getWizardPanel() {
        return this.wizardPanel;
    }

    public void setWizardPanel(BaseWizardPanel wizardPanel) {
        this.wizardPanel = wizardPanel;
    }

    public JDialog getWizardDialog() {
        return this.wizardDialog;
    }

    public void setWizardDialog(JDialog wizardDialog) {
        this.wizardDialog = wizardDialog;
    }

    public JReportFrame getJReportFrame() {
        return this.jReportFrame;
    }

    public void setJReportFrame(JReportFrame jReportFrame) {
        this.jReportFrame = jReportFrame;
    }

    public void applyI18n() {
        this.jCheckBox1.setText(I18n.getString("reportGroupWizard.checkBox1", "Add the group header"));
        this.jRadioButton1.setText(I18n.getString("reportGroupWizard.radioButton1", "Group by the following report object:"));
        this.jRadioButton2.setText(I18n.getString("reportGroupWizard.radioButton2", "Group by the following expression:"));
        this.jLabel1.setText(I18n.getString("reportGroupWizard.label1", "Group name"));
        this.jCheckBox2.setText(I18n.getString("reportGroupWizard.checkBox2", "Add the group footer"));
    }
}

