/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.wcf.expr;

import com.tonbeller.wcf.expr.ExprContext;
import com.tonbeller.wcf.utils.SoftException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import javax.servlet.jsp.PageContext;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.log4j.Logger;

public class ExprUtils {
    private static Logger logger = Logger.getLogger((Class)ExprUtils.class);

    private ExprUtils() {
    }

    public static void checkExpr(String expr) {
        if (expr == null) {
            throw new IllegalArgumentException("expr is null");
        }
        if (ExprUtils.isExpression(expr) && !expr.endsWith("}")) {
            throw new IllegalArgumentException("expr must end with \"}\"");
        }
    }

    public static Object getModelReference(PageContext pageContext, String expr) {
        ExprContext ec = ExprUtils.getExprContextAdapter(pageContext);
        return ExprUtils.getModelReference(ec, expr);
    }

    public static ExprContext getExprContextAdapter(final PageContext pageContext) {
        return new ExprContext(){

            public Object findBean(String name) {
                return pageContext.findAttribute(name);
            }

            public void setBean(String name, Object bean) {
                if (bean == null) {
                    pageContext.removeAttribute(name);
                } else {
                    pageContext.setAttribute(name, bean, 3);
                }
            }
        };
    }

    public static Object getModelReference(ExprContext context, String expr) {
        try {
            if (expr == null || expr.length() == 0) {
                return null;
            }
            if (!ExprUtils.isExpression(expr)) {
                return context.findBean(expr);
            }
            if (!expr.endsWith("}")) {
                throw new IllegalArgumentException("expr must end with '}'");
            }
            int pos = expr.indexOf(46);
            if (pos < 0) {
                String name = expr.substring(2, expr.length() - 1);
                return context.findBean(name);
            }
            String name = expr.substring(2, pos);
            Object bean = context.findBean(name);
            if (bean == null) {
                throw new IllegalArgumentException("bean \"" + name + "\" not found");
            }
            String path = expr.substring(pos + 1, expr.length() - 1);
            return PropertyUtils.getProperty((Object)bean, (String)path);
        }
        catch (IllegalAccessException e) {
            logger.error((Object)"?", (Throwable)e);
            throw new SoftException(e);
        }
        catch (InvocationTargetException e) {
            logger.error((Object)"?", (Throwable)e);
            throw new SoftException(e);
        }
        catch (NoSuchMethodException e) {
            logger.error((Object)"?", (Throwable)e);
            throw new SoftException(e);
        }
    }

    public static void setModelReference(ExprContext context, String expr, Object value) {
        if (expr == null) {
            throw new NullPointerException("expr is null");
        }
        if (!ExprUtils.isExpression(expr)) {
            context.setBean(expr, value);
            return;
        }
        if (!expr.endsWith("}")) {
            throw new IllegalArgumentException("expr must end with '}'");
        }
        if (expr.indexOf(46) < 0) {
            String name = expr.substring(2, expr.length() - 1);
            context.setBean(name, value);
            return;
        }
        try {
            int pos = expr.indexOf(46);
            String name = expr.substring(2, pos);
            Object bean = context.findBean(name);
            if (bean == null) {
                throw new IllegalArgumentException("bean \"" + name + "\" not found");
            }
            String path = expr.substring(pos + 1, expr.length() - 1);
            PropertyUtils.setProperty((Object)bean, (String)path, (Object)value);
        }
        catch (IllegalAccessException e) {
            logger.error((Object)"exception caught", (Throwable)e);
            throw new SoftException(e);
        }
        catch (InvocationTargetException e) {
            logger.error((Object)"exception caught", (Throwable)e);
            throw new SoftException(e);
        }
        catch (NoSuchMethodException e) {
            logger.error((Object)"exception caught", (Throwable)e);
            throw new SoftException(e);
        }
    }

    public static PropertyDescriptor getPropertyDescriptor(ExprContext context, String expr) {
        if (!ExprUtils.isExpression(expr) || !expr.endsWith("}") || expr.indexOf(46) < 0) {
            throw new IllegalArgumentException("'#{bean.property}' expected");
        }
        int pos = expr.indexOf(46);
        String name = expr.substring(2, pos);
        Object bean = context.findBean(name);
        if (bean == null) {
            throw new IllegalArgumentException("bean \"" + name + "\" not found");
        }
        String path = expr.substring(pos + 1, expr.length() - 1);
        try {
            return PropertyUtils.getPropertyDescriptor((Object)bean, (String)path);
        }
        catch (Exception e) {
            logger.error(null, (Throwable)e);
            return null;
        }
    }

    public static String getBeanName(String expr) {
        int pos;
        if (ExprUtils.isExpression(expr)) {
            expr = expr.substring(2, expr.length() - 1);
        }
        if ((pos = expr.indexOf(46)) > 0) {
            expr = expr.substring(0, pos);
        }
        return expr;
    }

    public static boolean isExpression(String expr) {
        if (expr == null) {
            return false;
        }
        return expr.startsWith("${") || expr.startsWith("#{");
    }
}

