/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.jpivot.test.olap;

import com.tonbeller.jpivot.olap.model.Hierarchy;
import com.tonbeller.jpivot.olap.model.impl.LevelImpl;
import com.tonbeller.jpivot.test.olap.TestDimension;
import com.tonbeller.jpivot.test.olap.TestHierarchy;
import com.tonbeller.jpivot.test.olap.TestLevel;
import com.tonbeller.jpivot.test.olap.TestMember;

public class DimensionBuilder {
    String hierName;
    String[] levelNames;
    int[] childCount;
    LevelImpl[] levels;

    public TestDimension build(String hierName, String[] levelNames, int[] childCount) {
        this.hierName = hierName;
        this.levelNames = levelNames;
        this.childCount = childCount;
        TestDimension dim = new TestDimension();
        dim.setLabel(hierName);
        TestHierarchy hier = new TestHierarchy();
        hier.setLabel(hierName);
        hier.setDimension(dim);
        dim.setHierarchies(new Hierarchy[]{hier});
        this.levels = new LevelImpl[levelNames.length];
        for (int i = 0; i < this.levels.length; ++i) {
            TestLevel level = new TestLevel();
            level.setLabel(levelNames[i]);
            level.setHierarchy(hier);
            this.levels[i] = level;
        }
        hier.setLevels(this.levels);
        TestMember[] roots = this.buildRoots();
        hier.rootMembers = roots;
        return dim;
    }

    TestMember[] buildRoots() {
        TestMember[] members = new TestMember[this.childCount[0]];
        for (int i = 0; i < this.childCount[0]; ++i) {
            TestMember member = new TestMember();
            member.setLabel(this.levelNames[0] + "[" + i + "]");
            member.setLevel(this.levels[0]);
            member.setVisible(true);
            this.appendChildren(member, 1);
            members[i] = member;
        }
        return members;
    }

    void appendChildren(TestMember parent, int levelIndex) {
        if (levelIndex >= this.childCount.length) {
            return;
        }
        for (int i = 0; i < this.childCount[levelIndex]; ++i) {
            TestMember member = new TestMember();
            member.setLabel(this.levelNames[levelIndex] + "[" + i + "]");
            member.setParentMember(parent);
            member.setLevel(this.levels[levelIndex]);
            member.setRootDistance(levelIndex);
            parent.addChildMember(member);
            this.appendChildren(member, levelIndex + 1);
        }
    }
}

