/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.jpivot.table.navi;

import com.tonbeller.jpivot.param.MemberParamProvider;
import com.tonbeller.jpivot.param.ParameterProvider;
import com.tonbeller.jpivot.param.PropertyParamProvider;
import com.tonbeller.jpivot.param.PropertyPrefixParamProvider;
import com.tonbeller.jpivot.table.AxisBuilder;
import com.tonbeller.jpivot.table.ClickableMember;
import com.tonbeller.jpivot.table.SpanBuilder;
import com.tonbeller.jpivot.table.TableComponent;
import com.tonbeller.jpivot.table.TableComponentTag;
import com.tonbeller.jpivot.table.navi.DynamicClickableMember;
import com.tonbeller.jpivot.table.navi.StaticClickableMember;
import com.tonbeller.jpivot.table.navi.UrlClickableMember;
import com.tonbeller.jpivot.tags.OlapModelTag;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.Tag;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.log4j.Logger;

public class ClickableMemberTag
extends TagSupport {
    String urlPattern;
    String uniqueName;
    String menuLabel;
    String sessionParam;
    String propertyName;
    String propertyPrefix;
    String providerClass;
    String page;
    private static Logger logger = Logger.getLogger((Class)ClickableMemberTag.class);

    public int doStartTag() throws JspException {
        TableComponentTag tct;
        if (this.propertyPrefix != null && this.sessionParam != null) {
            throw new JspException("propertyPrefix and sessionParam can not be specified both");
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)("creating clickable member for URL: " + this.urlPattern + ", uniqueName: " + this.uniqueName));
        }
        if ((tct = (TableComponentTag)ClickableMemberTag.findAncestorWithClass((Tag)this, (Class)TableComponentTag.class)) != null) {
            this.createStaticClickable(tct);
            return 0;
        }
        OlapModelTag omt = (OlapModelTag)ClickableMemberTag.findAncestorWithClass((Tag)this, (Class)OlapModelTag.class);
        if (omt != null) {
            this.createDynamicClickable(omt);
            return 0;
        }
        throw new JspException("ClickableMemberTag must be nested in a table or query tag");
    }

    private void createDynamicClickable(OlapModelTag omt) {
        ParameterProvider provider = this.createProvider();
        ClickableMember clickable = this.createClickable(provider);
        omt.addClickable(clickable);
    }

    private void createStaticClickable(TableComponentTag tct) throws JspException {
        TableComponent tc = (TableComponent)tct.getComponent();
        ParameterProvider provider = this.createProvider();
        this.decorate(tc.getRowAxisBuilder(), this.createClickable(provider));
        this.decorate(tc.getColumnAxisBuilder(), this.createClickable(provider));
    }

    private ClickableMember createClickable(ParameterProvider provider) {
        if (provider != null) {
            DynamicClickableMember dcm = new DynamicClickableMember(this.uniqueName, this.menuLabel, provider, this.page);
            dcm.setUrlPattern(this.urlPattern);
            return dcm;
        }
        return new UrlClickableMember(this.uniqueName, this.menuLabel, this.urlPattern);
    }

    private ParameterProvider createProvider() {
        ParameterProvider provider = null;
        if (this.sessionParam != null) {
            provider = this.propertyName != null ? new PropertyParamProvider(this.sessionParam, this.propertyName) : new MemberParamProvider(this.sessionParam);
        } else if (this.propertyPrefix != null) {
            provider = new PropertyPrefixParamProvider(this.propertyPrefix);
        } else if (this.providerClass != null) {
            try {
                provider = (ParameterProvider)Class.forName(this.providerClass).newInstance();
            }
            catch (InstantiationException e) {
                logger.error(null, (Throwable)e);
            }
            catch (IllegalAccessException e) {
                logger.error(null, (Throwable)e);
            }
            catch (ClassNotFoundException e) {
                logger.error(null, (Throwable)e);
            }
        }
        return provider;
    }

    private void decorate(AxisBuilder axisBuilder, ClickableMember clickable) {
        SpanBuilder decoree = axisBuilder.getSpanBuilder();
        StaticClickableMember decorator = new StaticClickableMember(decoree, clickable);
        axisBuilder.setSpanBuilder(decorator);
    }

    public void setUniqueName(String string) {
        this.uniqueName = string;
    }

    public void setUrlPattern(String string) {
        this.urlPattern = string;
    }

    public void setSessionParam(String sessionParam) {
        this.sessionParam = sessionParam;
    }

    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }

    public void setPropertyPrefix(String propertyPrefix) {
        this.propertyPrefix = propertyPrefix;
    }

    public void setProviderClass(String providerClass) {
        this.providerClass = providerClass;
    }

    public void setPage(String page) {
        this.page = page;
    }

    public void setMenuLabel(String menuLabel) {
        this.menuLabel = menuLabel;
    }
}

