/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.jpivot.table;

import com.tonbeller.jpivot.olap.model.Member;
import com.tonbeller.jpivot.olap.model.Property;
import com.tonbeller.jpivot.olap.navi.MemberProperties;
import com.tonbeller.jpivot.table.PartBuilderSupport;
import com.tonbeller.jpivot.table.SlicerBuilder;
import com.tonbeller.jpivot.table.span.PropertyConfig;
import com.tonbeller.jpivot.table.span.PropertyUtils;
import com.tonbeller.jpivot.table.span.ScopedPropertyMetaSet;
import com.tonbeller.wcf.controller.RequestContext;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;

public class SlicerBuilderImpl
extends PartBuilderSupport
implements SlicerBuilder {
    ScopedPropertyMetaSet visible;
    MemberProperties extension;
    PropertyConfig propertyConfig;

    public void startBuild(RequestContext context) {
        this.propertyConfig = this.table.getPropertyConfig();
        this.extension = this.getExtension();
        if (this.extension == null) {
            this.visible = null;
            return;
        }
        List list = this.propertyConfig.getVisiblePropertyMetas();
        if (list == null) {
            this.visible = null;
            return;
        }
        this.visible = new ScopedPropertyMetaSet(this.extension);
        this.visible.addAll(list);
    }

    public void stopBuild() {
        this.visible = null;
        this.extension = null;
        this.propertyConfig = null;
    }

    public Element build(Member m) {
        Element e = this.table.elem("member");
        e.setAttribute("level", m.getLevel().getLabel());
        e.setAttribute("caption", m.getLabel());
        e.setAttribute("depth", Integer.toString(m.getRootDistance()));
        this.addMemberProperties(e, m);
        return e;
    }

    private void addMemberProperties(Element e, Member m) {
        if (!this.propertyConfig.isShowProperties()) {
            return;
        }
        Property[] props = this.visibleProperties(m);
        PropertyUtils.addProperties(e, props);
    }

    private Property[] visibleProperties(Member m) {
        Property[] src = m.getProperties();
        String scope = null;
        if (this.extension != null) {
            scope = this.extension.getPropertyScope(m);
        }
        ArrayList<Property> list = new ArrayList<Property>();
        for (int i = 0; i < src.length; ++i) {
            Property p = src[i];
            if (PropertyUtils.isInline(p.getName())) continue;
            if (scope != null && this.visible != null) {
                if (!this.visible.contains(scope, p.getName())) continue;
                list.add(p);
                continue;
            }
            list.add(p);
        }
        return list.toArray(new Property[list.size()]);
    }

    MemberProperties getExtension() {
        return (MemberProperties)this.table.getOlapModel().getExtension("memberProperties");
    }

    public boolean isAvailable() {
        return this.getExtension() != null;
    }
}

