/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.jpivot.olap.model.impl;

import com.tonbeller.jpivot.olap.model.Cell;
import com.tonbeller.jpivot.olap.model.NumberFormat;
import com.tonbeller.jpivot.olap.model.Property;
import com.tonbeller.jpivot.olap.model.Visitor;
import com.tonbeller.jpivot.olap.model.impl.FormatStringParser;
import com.tonbeller.jpivot.olap.model.impl.PropertyImpl;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public abstract class CellBase
implements Cell {
    static Logger logger = Logger.getLogger((Class)CellBase.class);
    protected String formattedValue;
    private List properties = null;

    public abstract Object getValue();

    public abstract NumberFormat getFormat();

    public String getFormattedValue() {
        return this.formattedValue;
    }

    public abstract boolean isNull();

    public Property[] getProperties() {
        if (this.properties == null) {
            return new Property[0];
        }
        return this.properties.toArray(new Property[0]);
    }

    public Property getProperty(String name) {
        if (this.properties == null) {
            return null;
        }
        Iterator iter = this.properties.iterator();
        while (iter.hasNext()) {
            Property prop = (Property)iter.next();
            if (!prop.getName().equalsIgnoreCase(name)) continue;
            return prop;
        }
        return null;
    }

    public void accept(Visitor visitor) {
        visitor.visitCell(this);
    }

    public Object getRootDecoree() {
        return this;
    }

    public void setFormattedValue(String string, FormatStringParser parser2) {
        FormatStringParser.Result res = parser2.parse(this, string);
        this.formattedValue = res.getFormattedValue();
        if (res.getProperties().size() > 0) {
            if (this.properties == null) {
                this.properties = new ArrayList();
            }
            this.properties.addAll(res.getProperties());
        }
    }

    public void addProperty(String prop, String value) {
        Property p = this.getProperty(prop);
        if (p != null) {
            ((PropertyImpl)p).setValue(value);
        } else {
            PropertyImpl pi = new PropertyImpl();
            pi.setName(prop);
            pi.setLabel(prop);
            pi.setValue(value);
            if (this.properties == null) {
                this.properties = new ArrayList();
            }
            this.properties.add(pi);
        }
    }
}

