/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.jpivot.olap.mdxparse;

import com.tonbeller.jpivot.olap.mdxparse.Exp;
import com.tonbeller.jpivot.olap.mdxparse.ExpVisitor;
import com.tonbeller.jpivot.olap.mdxparse.Literal;
import com.tonbeller.jpivot.olap.mdxparse.Parameter;
import com.tonbeller.jpivot.olap.mdxparse.ParsedQuery;
import com.tonbeller.tbutils.res.Resources;
import org.apache.log4j.Logger;

public class FunCall
implements Exp {
    static Logger logger = Logger.getLogger((Class)FunCall.class);
    Resources resources = Resources.instance();
    public static final int TypeFunction = 0;
    public static final int TypeProperty = 1;
    public static final int TypeMethod = 2;
    public static final int TypeInfix = 3;
    public static final int TypePrefix = 4;
    public static final int TypeBraces = 5;
    public static final int TypeParentheses = 6;
    public static final int TypeCase = 7;
    public static final int TypeMask = 255;
    public static final int TypePropertyQuoted = 257;
    public static final int TypePropertyAmpQuoted = 513;
    private int syntacticType;
    private String function;
    private Exp[] args;
    ParsedQuery pQuery = null;

    public FunCall(String fun, Exp[] args) {
        this(fun, args, 0);
    }

    public FunCall(String fun, Exp[] args, int syntacticType) {
        this.function = fun;
        this.args = args;
        this.syntacticType = syntacticType;
    }

    public String toMdx() {
        if (this.isCallTo("Parameter") || this.isCallTo("ParamRef")) {
            return this.evaluateParameter();
        }
        StringBuffer sb = new StringBuffer();
        boolean isFollow = false;
        switch (this.syntacticType) {
            case 0: {
                sb.append(this.function);
                sb.append("(");
                for (int i = 0; i < this.args.length; ++i) {
                    if (isFollow) {
                        sb.append(", ");
                    }
                    isFollow = true;
                    sb.append(this.args[i].toMdx());
                }
                sb.append(")");
                break;
            }
            case 5: {
                sb.append("{");
                for (int i = 0; i < this.args.length; ++i) {
                    if (isFollow) {
                        sb.append(", ");
                    }
                    isFollow = true;
                    sb.append(this.args[i].toMdx());
                }
                sb.append("}");
                break;
            }
            case 6: {
                sb.append("(");
                for (int i = 0; i < this.args.length; ++i) {
                    if (isFollow) {
                        sb.append(", ");
                    }
                    isFollow = true;
                    sb.append(this.args[i].toMdx());
                }
                sb.append(")");
                break;
            }
            case 4: {
                sb.append(this.function);
                sb.append(" ");
                sb.append(this.args[0].toMdx());
                break;
            }
            case 3: {
                sb.append(this.args[0].toMdx());
                sb.append(" ");
                sb.append(this.function);
                sb.append(" ");
                sb.append(this.args[1].toMdx());
                break;
            }
            case 1: 
            case 257: 
            case 513: {
                sb.append(this.args[0].toMdx());
                sb.append(".");
                sb.append(this.function);
                break;
            }
            default: {
                System.out.println(this.resources.getString("jpivot.FunCall.error.syntaxError"));
                logger.error((Object)this.resources.getString("jpivot.FunCall.error.syntaxError"));
            }
        }
        return sb.toString();
    }

    public Object clone() {
        Exp[] cloneArgs = new Exp[this.args.length];
        for (int i = 0; i < cloneArgs.length; ++i) {
            cloneArgs[i] = (Exp)this.args[i].clone();
        }
        return new FunCall(this.function, cloneArgs, this.syntacticType);
    }

    public boolean isCallTo(String fName) {
        return Resources.instance().getCollator().compare(fName.toLowerCase(), this.function.toLowerCase()) == 0;
    }

    public Exp[] getArgs() {
        return this.args;
    }

    public String getFunction() {
        return this.function;
    }

    private String evaluateParameter() {
        Literal eName = (Literal)this.args[0];
        String paraName = eName.stringValue();
        Parameter param = (Parameter)this.pQuery.paraMap.get(paraName.toUpperCase());
        if (param == null) {
            logger.error((Object)(this.resources.getString("jpivot.FunCall.error.cannotFindParameter") + paraName));
            return "Parameter( \"" + paraName + "\" )";
        }
        int type = param.getType();
        if (type == 1) {
            Object value = param.getOValue();
            return value.toString();
        }
        if (type == 2) {
            String str = (String)param.getOValue();
            return "\"" + str + "\"";
        }
        String str = (String)param.getOValue();
        return str;
    }

    public void accept(ExpVisitor visitor) {
        visitor.visitFunCall(this);
    }
}

