/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.jpivot.mondrian;

import com.tonbeller.jpivot.mondrian.MondrianModel;
import com.tonbeller.jpivot.olap.model.NumberFormat;
import com.tonbeller.jpivot.olap.model.impl.CellBase;
import com.tonbeller.jpivot.util.NumSeparators;
import mondrian.olap.Cell;
import org.apache.log4j.Logger;

public class MondrianCell
extends CellBase {
    static Logger logger = Logger.getLogger((Class)MondrianCell.class);
    private Cell monCell;
    private MondrianModel model;
    private boolean isGrouping = false;
    private boolean isPercent = false;
    private int fractionDigits = 0;

    protected MondrianCell(Cell monCell, MondrianModel model) {
        this.monCell = monCell;
        this.model = model;
    }

    public Object getValue() {
        return this.monCell.getValue();
    }

    public boolean isNull() {
        return this.monCell.isNull();
    }

    public NumberFormat getFormat() {
        int i;
        if (this.monCell.isNull()) {
            return null;
        }
        Object o = this.monCell.getValue();
        if (!(o instanceof Number)) {
            return null;
        }
        this.isPercent = this.formattedValue.indexOf(37) >= 0;
        NumSeparators sep = NumSeparators.instance(this.model.getLocale());
        this.fractionDigits = 0;
        if (this.formattedValue.indexOf(sep.thouSep) >= 0) {
            this.isGrouping = true;
        }
        if ((i = this.formattedValue.indexOf(sep.decimalSep)) > 0) {
            while (++i < this.formattedValue.length() && Character.isDigit(this.formattedValue.charAt(i))) {
                ++this.fractionDigits;
            }
        }
        return new NumberFormat(){

            public boolean isGrouping() {
                return MondrianCell.this.isGrouping;
            }

            public int getFractionDigits() {
                return MondrianCell.this.fractionDigits;
            }

            public boolean isPercent() {
                return MondrianCell.this.isPercent;
            }
        };
    }

    public Cell getMonCell() {
        return this.monCell;
    }

    public MondrianModel getModel() {
        return this.model;
    }
}

