/*
 * Decompiled with CFR 0.152.
 */
package com.ingres.gcf.util;

import com.ingres.gcf.util.SqlData;
import com.ingres.gcf.util.SqlEx;
import java.math.BigDecimal;

public class SqlDouble
extends SqlData {
    private double value = 0.0;

    public SqlDouble() {
        super(true);
    }

    public SqlDouble(double d) {
        super(false);
        this.value = d;
    }

    public void set(double d) {
        this.setNotNull();
        this.value = d;
    }

    public void set(SqlDouble sqlDouble) {
        if (sqlDouble == null || sqlDouble.isNull()) {
            this.setNull();
        } else {
            this.setNotNull();
            this.value = sqlDouble.value;
        }
    }

    public double get() {
        return this.value;
    }

    public void setBoolean(boolean bl) throws SqlEx {
        this.setNotNull();
        this.value = bl ? 1.0 : 0.0;
    }

    public void setByte(byte by) throws SqlEx {
        this.setNotNull();
        this.value = by;
    }

    public void setShort(short s) throws SqlEx {
        this.setNotNull();
        this.value = s;
    }

    public void setInt(int n) throws SqlEx {
        this.setNotNull();
        this.value = n;
    }

    public void setLong(long l) throws SqlEx {
        this.setNotNull();
        this.value = l;
    }

    public void setFloat(float f) throws SqlEx {
        this.setNotNull();
        this.value = f;
    }

    public void setDouble(double d) throws SqlEx {
        this.setNotNull();
        this.value = d;
    }

    public void setBigDecimal(BigDecimal bigDecimal) throws SqlEx {
        if (bigDecimal == null) {
            this.setNull();
        } else {
            this.setNotNull();
            this.value = bigDecimal.doubleValue();
        }
    }

    public void setString(String string) throws SqlEx {
        if (string == null) {
            this.setNull();
        } else {
            this.setNotNull();
            try {
                this.value = Double.parseDouble(string.trim());
            }
            catch (NumberFormatException numberFormatException) {
                throw SqlEx.get(ERR_GC401A_CONVERSION_ERR);
            }
        }
    }

    public boolean getBoolean() throws SqlEx {
        return this.value != 0.0;
    }

    public byte getByte() throws SqlEx {
        return (byte)this.value;
    }

    public short getShort() throws SqlEx {
        return (short)this.value;
    }

    public int getInt() throws SqlEx {
        return (int)this.value;
    }

    public long getLong() throws SqlEx {
        return (long)this.value;
    }

    public float getFloat() throws SqlEx {
        return (float)this.value;
    }

    public double getDouble() throws SqlEx {
        return this.value;
    }

    public BigDecimal getBigDecimal() throws SqlEx {
        return new BigDecimal(this.value);
    }

    public String getString() throws SqlEx {
        return Double.toString(this.value);
    }

    public Object getObject() throws SqlEx {
        return new Double(this.value);
    }
}

