/*
 * Decompiled with CFR 0.152.
 */
package com.ingres.gcf.jdbc;

import com.ingres.gcf.jdbc.DrvConn;
import com.ingres.gcf.jdbc.DrvNlob;
import com.ingres.gcf.jdbc.JdbcClob;
import com.ingres.gcf.util.SqlDates;
import com.ingres.gcf.util.SqlEx;
import com.ingres.gcf.util.SqlLoc;
import com.ingres.gcf.util.SqlLongNChar;
import com.ingres.gcf.util.SqlStream;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Clob;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.TimeZone;

class SqlNLoc
extends SqlLoc {
    private DrvConn conn = null;

    public SqlNLoc(DrvConn drvConn) throws SqlEx {
        this.conn = drvConn;
    }

    public void set(SqlNLoc sqlNLoc) {
        if (sqlNLoc == null) {
            this.setNull();
        } else {
            this.conn = sqlNLoc.conn;
            this.set((SqlLoc)sqlNLoc);
        }
    }

    public void setClob(Clob clob) throws SqlEx {
        if (clob == null) {
            this.setNull();
        } else if (clob instanceof DrvNlob) {
            this.set(((DrvNlob)clob).getLocator());
        } else {
            throw SqlEx.get(ERR_GC401A_CONVERSION_ERR);
        }
    }

    public Clob getClob() throws SqlEx {
        return new JdbcClob(new DrvNlob(this.conn, this.value), this.conn.cnf_lob_segSize, this.conn.trace);
    }

    public boolean getBoolean() throws SqlEx {
        String string = this.getString().trim();
        return string.equals("1") ? true : Boolean.valueOf(string);
    }

    public byte getByte() throws SqlEx {
        byte by;
        try {
            by = Byte.parseByte(this.getString().trim());
        }
        catch (NumberFormatException numberFormatException) {
            throw SqlEx.get(ERR_GC401A_CONVERSION_ERR);
        }
        return by;
    }

    public short getShort() throws SqlEx {
        short s;
        try {
            s = Short.parseShort(this.getString().trim());
        }
        catch (NumberFormatException numberFormatException) {
            throw SqlEx.get(ERR_GC401A_CONVERSION_ERR);
        }
        return s;
    }

    public int getInt() throws SqlEx {
        int n;
        try {
            n = Integer.parseInt(this.getString().trim());
        }
        catch (NumberFormatException numberFormatException) {
            throw SqlEx.get(ERR_GC401A_CONVERSION_ERR);
        }
        return n;
    }

    public long getLong() throws SqlEx {
        long l;
        try {
            l = Long.parseLong(this.getString().trim());
        }
        catch (NumberFormatException numberFormatException) {
            throw SqlEx.get(ERR_GC401A_CONVERSION_ERR);
        }
        return l;
    }

    public float getFloat() throws SqlEx {
        float f;
        try {
            f = Float.parseFloat(this.getString().trim());
        }
        catch (NumberFormatException numberFormatException) {
            throw SqlEx.get(ERR_GC401A_CONVERSION_ERR);
        }
        return f;
    }

    public double getDouble() throws SqlEx {
        double d;
        try {
            d = Double.parseDouble(this.getString().trim());
        }
        catch (NumberFormatException numberFormatException) {
            throw SqlEx.get(ERR_GC401A_CONVERSION_ERR);
        }
        return d;
    }

    public BigDecimal getBigDecimal() throws SqlEx {
        BigDecimal bigDecimal;
        try {
            bigDecimal = new BigDecimal(this.getString().trim());
        }
        catch (NumberFormatException numberFormatException) {
            throw SqlEx.get(ERR_GC401A_CONVERSION_ERR);
        }
        return bigDecimal;
    }

    public String getString() throws SqlEx {
        return SqlLongNChar.strm2str(this.getCharacterStream());
    }

    public String getString(int n) throws SqlEx {
        return SqlLongNChar.strm2str(this.getCharacterStream(), n);
    }

    public Date getDate(TimeZone timeZone) throws SqlEx {
        String string = this.getString().trim();
        return timeZone == null ? SqlDates.parseDate(string, false) : SqlDates.parseDate(string, timeZone);
    }

    public Time getTime(TimeZone timeZone) throws SqlEx {
        String string = this.getString().trim();
        return timeZone == null ? SqlDates.parseTime(string, false) : SqlDates.parseTime(string, timeZone);
    }

    public Timestamp getTimestamp(TimeZone timeZone) throws SqlEx {
        String string = this.getString().trim();
        return timeZone == null ? SqlDates.parseTimestamp(string, false) : SqlDates.parseTimestamp(string, timeZone);
    }

    public InputStream getAsciiStream() throws SqlEx {
        InputStream inputStream;
        DrvNlob drvNlob = new DrvNlob(this.conn, this.value);
        try {
            inputStream = drvNlob.getAsciiStream();
        }
        catch (SQLException sQLException) {
            if (sQLException instanceof SqlEx) {
                throw (SqlEx)sQLException;
            }
            throw new SqlEx(sQLException.getMessage(), sQLException.getSQLState(), sQLException.getErrorCode());
        }
        return inputStream;
    }

    public InputStream getUnicodeStream() throws SqlEx {
        return SqlStream.getUnicodeIS(this.getCharacterStream());
    }

    public Reader getCharacterStream() throws SqlEx {
        Reader reader;
        DrvNlob drvNlob = new DrvNlob(this.conn, this.value);
        try {
            reader = drvNlob.getCharacterStream();
        }
        catch (SQLException sQLException) {
            if (sQLException instanceof SqlEx) {
                throw (SqlEx)sQLException;
            }
            throw new SqlEx(sQLException.getMessage(), sQLException.getSQLState(), sQLException.getErrorCode());
        }
        return reader;
    }

    public Object getObject() throws SqlEx {
        return this.getClob();
    }
}

