/*
 * Decompiled with CFR 0.152.
 */
package com.ingres.gcf.jdbc;

import com.ingres.gcf.jdbc.DrvConn;
import com.ingres.gcf.jdbc.DrvObj;
import com.ingres.gcf.jdbc.JdbcCall;
import com.ingres.gcf.jdbc.JdbcDBMD;
import com.ingres.gcf.jdbc.JdbcPrep;
import com.ingres.gcf.jdbc.JdbcRSMD;
import com.ingres.gcf.jdbc.JdbcSP;
import com.ingres.gcf.jdbc.JdbcStmt;
import com.ingres.gcf.jdbc.SqlParse;
import com.ingres.gcf.util.CharSet;
import com.ingres.gcf.util.Config;
import com.ingres.gcf.util.DbmsConst;
import com.ingres.gcf.util.IngXid;
import com.ingres.gcf.util.SqlEx;
import com.ingres.gcf.util.SqlWarn;
import com.ingres.gcf.util.XaEx;
import com.ingres.gcf.util.XaXid;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;

public class JdbcConn
extends DrvObj
implements Connection,
DbmsConst {
    private int isolationLevel = 8;
    private int holdability = 2;
    private JdbcSP savepoints = null;
    private JdbcDBMD dbmd = null;
    private Map type_map = new Hashtable();
    private DbXids dbXids = null;

    JdbcConn(DrvConn drvConn, Config config, int n) throws SqlEx {
        this(drvConn);
        this.connect(config, n, null, null);
        drvConn.loadDbCaps();
    }

    JdbcConn(DrvConn drvConn, Config config, IngXid ingXid) throws SqlEx {
        this(drvConn);
        this.connect(config, 0, ingXid, null);
    }

    JdbcConn(DrvConn drvConn, Config config, XaXid xaXid) throws SqlEx {
        this(drvConn);
        this.connect(config, 0, null, xaXid);
    }

    private JdbcConn(DrvConn drvConn) {
        super(drvConn);
        drvConn.jdbc = this;
        this.title = this.trace.getTraceName() + "-Connection[" + this.msg.connID() + "]";
        this.tr_id = "Conn[" + this.msg.connID() + "]";
    }

    private void connect(Config config, int n, IngXid ingXid, XaXid xaXid) throws SqlEx {
        String string = config.get("char_encode");
        if (string != null && string.length() != 0) {
            try {
                this.msg.setCharSet(new CharSet(string));
            }
            catch (Exception exception) {
                if (this.trace.enabled(1)) {
                    this.trace.write(this.tr_id + ": unknown encoding: " + string);
                }
                throw SqlEx.get(ERR_GC4009_BAD_CHARSET);
            }
        } else if (this.msg.getCharSet() == null) {
            if (this.trace.enabled()) {
                this.trace.log(this.title + ": failed to establish character encoding!");
            }
            throw SqlEx.get(ERR_GC4009_BAD_CHARSET);
        }
        if (this.trace.enabled(2)) {
            this.trace.write(this.tr_id + ": Connecting to database");
        }
        try {
            this.msg.begin((byte)1);
            this.client_parms(config);
            this.driver_parms(this.checkLocalUser(config), n, ingXid, xaXid);
            this.msg.done(true);
            this.readResults();
        }
        catch (SqlEx sqlEx) {
            if (this.trace.enabled(1)) {
                this.trace.write(this.tr_id + ": error connecting to database");
            }
            this.conn.close();
            throw sqlEx;
        }
        if (this.trace.enabled(2)) {
            this.trace.write(this.tr_id + ": connected to database");
        }
    }

    private boolean checkLocalUser(Config config) {
        String string;
        return this.msg.isLocal() && !this.conn.is_dtmc && this.conn.msg_protocol_level >= 3 && ((string = config.get("user")) == null || string.length() == 0);
    }

    private void client_parms(Config config) throws SqlEx {
        if (this.trace.enabled(3)) {
            this.trace.write(this.tr_id + ": sending connection parameters");
        }
        for (int i = 0; i < propInfo.length; ++i) {
            String string = config.get(JdbcConn.propInfo[i].name);
            if (string == null || string.length() == 0) continue;
            switch (JdbcConn.propInfo[i].msgID) {
                case 1: {
                    this.conn.database = string;
                    this.msg.write(JdbcConn.propInfo[i].msgID);
                    this.msg.write(string);
                    break;
                }
                case 3: {
                    String string2 = config.get("user");
                    if (string2 != null && string2.length() > 0) {
                        this.msg.write(JdbcConn.propInfo[i].msgID);
                        this.msg.write(this.msg.encode(string2, this.conn.session_mask, string));
                    }
                    string = "*****";
                    break;
                }
                case 7: {
                    this.msg.write(JdbcConn.propInfo[i].msgID);
                    this.msg.write(string);
                    string = "*****";
                    break;
                }
                case 9: {
                    byte by;
                    if (string.equalsIgnoreCase("off")) {
                        by = 0;
                    } else if (string.equalsIgnoreCase("on")) {
                        by = 1;
                    } else {
                        if (this.trace.enabled(1)) {
                            this.trace.write(this.tr_id + ": connection pool '" + string + "'");
                        }
                        throw SqlEx.get(ERR_GC4010_PARAM_VALUE);
                    }
                    this.msg.write(JdbcConn.propInfo[i].msgID);
                    this.msg.write((short)1);
                    this.msg.write(by);
                    break;
                }
                case 10: {
                    byte by;
                    if (string.equalsIgnoreCase("dbms")) {
                        by = 0;
                    } else if (string.equalsIgnoreCase("single")) {
                        by = 1;
                    } else if (string.equalsIgnoreCase("multi")) {
                        by = 2;
                    } else {
                        if (this.trace.enabled(1)) {
                            this.trace.write(this.tr_id + ": autocommit mode '" + string + "'");
                        }
                        throw SqlEx.get(ERR_GC4010_PARAM_VALUE);
                    }
                    if (this.conn.msg_protocol_level >= 2) {
                        this.msg.write(JdbcConn.propInfo[i].msgID);
                        this.msg.write((short)1);
                        this.msg.write(by);
                        break;
                    }
                    if (by == 0) break;
                    if (this.trace.enabled(1)) {
                        this.trace.write(this.tr_id + ": autocommit mode '" + string + "' @ proto lvl " + this.conn.msg_protocol_level);
                    }
                    throw SqlEx.get(ERR_GC4019_UNSUPPORTED);
                }
                case 15: {
                    byte by;
                    if (string.equalsIgnoreCase("login")) {
                        by = 0;
                    } else if (string.equalsIgnoreCase("connect")) {
                        by = 1;
                    } else {
                        if (this.trace.enabled(1)) {
                            this.trace.write(this.tr_id + ": vnode usage '" + string + "'");
                        }
                        throw SqlEx.get(ERR_GC4010_PARAM_VALUE);
                    }
                    if (this.conn.msg_protocol_level >= 3) {
                        this.msg.write(JdbcConn.propInfo[i].msgID);
                        this.msg.write((short)1);
                        this.msg.write(by);
                        break;
                    }
                    if (by == 1) break;
                    if (this.trace.enabled(1)) {
                        this.trace.write(this.tr_id + ": vnode usage '" + string + "' @ proto lvl " + this.conn.msg_protocol_level);
                    }
                    throw SqlEx.get(ERR_GC4019_UNSUPPORTED);
                }
                case 20: {
                    if (this.conn.msg_protocol_level < 3) break;
                    this.conn.is_gmt = false;
                    this.msg.write(JdbcConn.propInfo[i].msgID);
                    this.msg.write(string);
                    break;
                }
                case 21: 
                case 22: 
                case 23: {
                    if (this.conn.msg_protocol_level < 3) break;
                    this.msg.write(JdbcConn.propInfo[i].msgID);
                    this.msg.write(string);
                    break;
                }
                case 24: {
                    if (this.conn.msg_protocol_level < 3) break;
                    this.msg.write(JdbcConn.propInfo[i].msgID);
                    this.msg.write((short)1);
                    try {
                        this.msg.write(Byte.parseByte(string));
                        break;
                    }
                    catch (NumberFormatException numberFormatException) {
                        if (this.trace.enabled(1)) {
                            this.trace.write(this.tr_id + ": money prec '" + string + "'");
                        }
                        throw SqlEx.get(ERR_GC4010_PARAM_VALUE);
                    }
                }
                case 25: {
                    if (this.conn.msg_protocol_level < 6) break;
                    this.msg.write(JdbcConn.propInfo[i].msgID);
                    this.msg.write(string);
                    break;
                }
                case -1: {
                    if (string.equalsIgnoreCase("off")) {
                        this.conn.select_loops = false;
                        break;
                    }
                    if (string.equalsIgnoreCase("on")) {
                        this.conn.select_loops = true;
                        break;
                    }
                    if (this.trace.enabled(1)) {
                        this.trace.write(this.tr_id + ": select loop '" + string + "'");
                    }
                    throw SqlEx.get(ERR_GC4010_PARAM_VALUE);
                }
                case -2: {
                    if (string.equalsIgnoreCase("dbms")) {
                        this.conn.cursor_mode = -1;
                        break;
                    }
                    if (string.equalsIgnoreCase("update")) {
                        this.conn.cursor_mode = 1;
                        break;
                    }
                    if (string.equalsIgnoreCase("readonly")) {
                        this.conn.cursor_mode = 0;
                        break;
                    }
                    if (this.trace.enabled(1)) {
                        this.trace.write(this.tr_id + ": cursor mode '" + string + "'");
                    }
                    throw SqlEx.get(ERR_GC4010_PARAM_VALUE);
                }
                case -3: {
                    break;
                }
                default: {
                    this.msg.write(JdbcConn.propInfo[i].msgID);
                    this.msg.write(string);
                }
            }
            if (!this.trace.enabled(3)) continue;
            this.trace.write("    " + JdbcConn.propInfo[i].desc + ": '" + string + "'");
        }
    }

    private void driver_parms(boolean bl, int n, IngXid ingXid, XaXid xaXid) throws SqlEx {
        String string = null;
        try {
            string = System.getProperty("user.name");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (string != null && string.length() == 0) {
            string = null;
        }
        if (bl && string != null) {
            if (this.trace.enabled(3)) {
                this.trace.write("    Login Type: 'user'");
            }
            this.msg.write((short)15);
            this.msg.write((short)1);
            this.msg.write((byte)2);
            this.msg.write((short)2);
            this.msg.write(string);
            this.msg.write((short)3);
            this.msg.write(this.msg.encode(string, this.conn.session_mask, string));
        }
        if (n != 0) {
            if (this.trace.enabled(3)) {
                this.trace.write("    Timeout: " + n);
            }
            n = n < 0 ? -n : n * 1000;
            this.msg.write((short)8);
            this.msg.write((short)4);
            this.msg.write(n);
        }
        if (ingXid != null && this.conn.msg_protocol_level >= 2) {
            if (this.trace.enabled(3)) {
                this.trace.write("    Ingres Transaction ID: " + ingXid);
            }
            this.msg.write((short)11);
            this.msg.write((short)8);
            this.msg.write((int)ingXid.getID());
            this.msg.write((int)(ingXid.getID() >> 32));
            this.conn.autoCommit = false;
        }
        if (xaXid != null && this.conn.msg_protocol_level >= 2) {
            if (this.trace.enabled(3)) {
                this.trace.write("    XA Transaction ID: " + xaXid);
            }
            this.msg.write((short)12);
            this.msg.write((short)4);
            this.msg.write(xaXid.getFormatId());
            this.msg.write((short)13);
            this.msg.write(xaXid.getGlobalTransactionId());
            this.msg.write((short)14);
            this.msg.write(xaXid.getBranchQualifier());
            this.conn.autoCommit = false;
        }
        if (this.conn.msg_protocol_level >= 3) {
            String string2;
            if (this.trace.enabled(3)) {
                this.trace.write("    Autocommit State: " + (this.conn.autoCommit ? "on" : "off"));
            }
            this.msg.write((short)16);
            this.msg.write((short)1);
            this.msg.write(this.conn.autoCommit ? (byte)1 : 0);
            if (string != null) {
                if (this.trace.enabled(3)) {
                    this.trace.write("    Local User ID: " + string);
                }
                this.msg.write((short)17);
                this.msg.write(string);
            }
            if ((string2 = this.msg.getLocalHost()) != null && string2.length() > 0) {
                if (this.trace.enabled(3)) {
                    this.trace.write("    Local Host: " + string2);
                }
                this.msg.write((short)18);
                this.msg.write(string2);
            }
            if ((string2 = this.msg.getLocalAddr()) != null && string2.length() > 0) {
                if (this.trace.enabled(3)) {
                    this.trace.write("    Local Address: " + string2);
                }
                this.msg.write((short)19);
                this.msg.write(string2);
            }
        }
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    public boolean isClosed() throws SQLException {
        boolean bl = this.msg.isClosed();
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".isClosed(): " + bl);
        }
        return bl;
    }

    public void close() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".close()");
        }
        this.warnings = null;
        if (this.msg.isClosed()) {
            if (this.trace.enabled(2)) {
                this.trace.write(this.tr_id + ": connection already closed");
            }
            return;
        }
        this.msg.lock();
        try {
            if (this.trace.enabled(2)) {
                this.trace.write(this.tr_id + ": Closing DBMS connection");
            }
            this.msg.begin((byte)2);
            this.msg.done(true);
            this.readResults();
            if (this.trace.enabled(2)) {
                this.trace.write(this.tr_id + ": DBMS connection closed");
            }
        }
        catch (SqlEx sqlEx) {
            if (this.trace.enabled()) {
                this.trace.log(this.title + ".close(): error closing connection");
            }
            if (this.trace.enabled(1)) {
                sqlEx.trace(this.trace);
            }
            throw sqlEx;
        }
        finally {
            this.msg.unlock();
            this.conn.close();
        }
        this.conn.autoCommit = false;
    }

    void abort() {
        if (this.trace.enabled(2)) {
            this.trace.write(this.tr_id + ".abort()");
        }
        this.msg.abort();
    }

    public Statement createStatement() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".createStatement()");
        }
        return this.createStmt(1003, -1, this.holdability);
    }

    public Statement createStatement(int n, int n2) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".createStatement(" + n + "," + n2 + ")");
        }
        switch (n2) {
            case 1007: {
                n2 = 0;
                break;
            }
            case 1008: {
                n2 = 1;
                break;
            }
            default: {
                this.warnings = null;
                throw SqlEx.get(ERR_GC4010_PARAM_VALUE);
            }
        }
        return this.createStmt(n, n2, this.holdability);
    }

    public Statement createStatement(int n, int n2, int n3) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".createStatement(" + n + "," + n2 + "," + n3 + ")");
        }
        switch (n2) {
            case 1007: {
                n2 = 0;
                break;
            }
            case 1008: {
                n2 = 1;
                break;
            }
            default: {
                this.warnings = null;
                throw SqlEx.get(ERR_GC4010_PARAM_VALUE);
            }
        }
        return this.createStmt(n, n2, n3);
    }

    private JdbcStmt createStmt(int n, int n2, int n3) throws SqlEx {
        boolean bl = false;
        this.warnings = null;
        if (this.conn.is_dtmc) {
            if (this.trace.enabled(1)) {
                this.trace.write(this.tr_id + ": not permitted when DTMC");
            }
            throw SqlEx.get(ERR_GC4019_UNSUPPORTED);
        }
        switch (n) {
            case 1003: {
                break;
            }
            case 1004: 
            case 1005: {
                if (this.conn.msg_protocol_level >= 6) break;
                if (this.trace.enabled(3)) {
                    this.trace.write(this.tr_id + ": ResultSet type SCROLL requested, type FORWARD provided");
                }
                n = 1003;
                bl = true;
                break;
            }
            default: {
                throw SqlEx.get(ERR_GC4010_PARAM_VALUE);
            }
        }
        switch (n2) {
            case -1: {
                break;
            }
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            default: {
                throw SqlEx.get(ERR_GC4010_PARAM_VALUE);
            }
        }
        switch (n3) {
            case 2: {
                break;
            }
            case 1: {
                if (this.trace.enabled(3)) {
                    this.trace.write(this.tr_id + ": ResultSet HOLD requested, type CLOSE provided");
                }
                n3 = 2;
                bl = true;
                break;
            }
            default: {
                throw SqlEx.get(ERR_GC4010_PARAM_VALUE);
            }
        }
        JdbcStmt jdbcStmt = new JdbcStmt(this.conn, n, n2, n3);
        if (bl) {
            this.warnings = SqlWarn.get(ERR_GC4016_RS_CHANGED);
        }
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".createStatement(): " + jdbcStmt);
        }
        return jdbcStmt;
    }

    public PreparedStatement prepareStatement(String string) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".prepareStatement('" + string + "')");
        }
        return this.createPrep(string, 1003, -1, this.holdability);
    }

    public PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".prepareStatement('" + string + "'," + n + "," + n2 + ")");
        }
        switch (n2) {
            case 1007: {
                n2 = 0;
                break;
            }
            case 1008: {
                n2 = 1;
                break;
            }
            default: {
                this.warnings = null;
                throw SqlEx.get(ERR_GC4010_PARAM_VALUE);
            }
        }
        return this.createPrep(string, n, n2, this.holdability);
    }

    public PreparedStatement prepareStatement(String string, int n, int n2, int n3) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".prepareStatement('" + string + "'," + n + "," + n2 + "," + n3 + ")");
        }
        switch (n2) {
            case 1007: {
                n2 = 0;
                break;
            }
            case 1008: {
                n2 = 1;
                break;
            }
            default: {
                this.warnings = null;
                throw SqlEx.get(ERR_GC4010_PARAM_VALUE);
            }
        }
        return this.createPrep(string, n, n2, n3);
    }

    public PreparedStatement prepareStatement(String string, int n) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".prepareStatement('" + string + "'," + n + ")");
        }
        switch (n) {
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            default: {
                throw SqlEx.get(ERR_GC4010_PARAM_VALUE);
            }
        }
        return this.createPrep(string, 1003, -1, this.holdability);
    }

    public PreparedStatement prepareStatement(String string, int[] nArray) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".prepareStatement('" + string + "'," + nArray + ")");
        }
        return this.createPrep(string, 1003, -1, this.holdability);
    }

    public PreparedStatement prepareStatement(String string, String[] stringArray) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".prepareStatement('" + string + "'," + stringArray + ")");
        }
        return this.createPrep(string, 1003, -1, this.holdability);
    }

    private JdbcPrep createPrep(String string, int n, int n2, int n3) throws SqlEx {
        boolean bl = false;
        this.warnings = null;
        if (this.conn.is_dtmc) {
            if (this.trace.enabled(1)) {
                this.trace.write(this.tr_id + ": not permitted when DTMC");
            }
            throw SqlEx.get(ERR_GC4019_UNSUPPORTED);
        }
        switch (n) {
            case 1003: {
                break;
            }
            case 1004: 
            case 1005: {
                if (this.conn.msg_protocol_level >= 6) break;
                if (this.trace.enabled(3)) {
                    this.trace.write(this.tr_id + ": ResultSet type SCROLL requested, type FORWARD provided");
                }
                n = 1003;
                bl = true;
                break;
            }
            default: {
                throw SqlEx.get(ERR_GC4010_PARAM_VALUE);
            }
        }
        switch (n2) {
            case -1: {
                break;
            }
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            default: {
                throw SqlEx.get(ERR_GC4010_PARAM_VALUE);
            }
        }
        switch (n3) {
            case 2: {
                break;
            }
            case 1: {
                if (this.trace.enabled(3)) {
                    this.trace.write(this.tr_id + ": ResultSet type HOLD requested, type CLOSE provided");
                }
                n3 = 2;
                bl = true;
                break;
            }
            default: {
                throw SqlEx.get(ERR_GC4010_PARAM_VALUE);
            }
        }
        JdbcPrep jdbcPrep = new JdbcPrep(this.conn, string, n, n2, n3);
        if (bl) {
            this.warnings = SqlWarn.get(ERR_GC4016_RS_CHANGED);
        }
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".prepareStatement(): " + jdbcPrep);
        }
        return jdbcPrep;
    }

    public CallableStatement prepareCall(String string) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".prepareCall( " + string + " )");
        }
        return this.createCall(string, 1003, 1007, this.holdability);
    }

    public CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".prepareCall('" + string + "'," + n + "," + n2 + ")");
        }
        return this.createCall(string, n, n2, this.holdability);
    }

    public CallableStatement prepareCall(String string, int n, int n2, int n3) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".prepareCall('" + string + "'," + n + "," + n2 + "," + n3 + ")");
        }
        return this.createCall(string, n, n2, n3);
    }

    private JdbcCall createCall(String string, int n, int n2, int n3) throws SqlEx {
        boolean bl = false;
        this.warnings = null;
        if (this.conn.is_dtmc) {
            if (this.trace.enabled(1)) {
                this.trace.write(this.tr_id + ": not permitted when DTMC");
            }
            throw SqlEx.get(ERR_GC4019_UNSUPPORTED);
        }
        if (this.conn.msg_protocol_level < 2) {
            if (this.trace.enabled(1)) {
                this.trace.write(this.tr_id + ": procedures require protocol level 2");
            }
            throw SqlEx.get(ERR_GC4019_UNSUPPORTED);
        }
        switch (n) {
            case 1003: {
                break;
            }
            case 1004: 
            case 1005: {
                bl = true;
                break;
            }
            default: {
                throw SqlEx.get(ERR_GC4010_PARAM_VALUE);
            }
        }
        switch (n2) {
            case 1007: {
                break;
            }
            case 1008: {
                bl = true;
                break;
            }
            default: {
                throw SqlEx.get(ERR_GC4010_PARAM_VALUE);
            }
        }
        switch (n3) {
            case 2: {
                break;
            }
            case 1: {
                bl = true;
                break;
            }
            default: {
                throw SqlEx.get(ERR_GC4010_PARAM_VALUE);
            }
        }
        JdbcCall jdbcCall = new JdbcCall(this.conn, string);
        if (bl) {
            this.warnings = SqlWarn.get(ERR_GC4016_RS_CHANGED);
        }
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".prepareCall()" + jdbcCall);
        }
        return jdbcCall;
    }

    public int getHoldability() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getHoldability(): " + this.holdability);
        }
        return this.holdability;
    }

    public void setHoldability(int n) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getHoldability(" + n + ")");
        }
        if (n != 2) {
            if (this.trace.enabled(1)) {
                this.trace.write(this.tr_id + ": holdable cursors not supported!");
            }
            throw SqlEx.get(ERR_GC4010_PARAM_VALUE);
        }
        this.holdability = n;
    }

    public String nativeSQL(String string) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".nativeSQL( " + string + " )");
        }
        SqlParse sqlParse = new SqlParse(string, this.conn);
        string = sqlParse.parseSQL(true);
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".nativeSQL: " + string);
        }
        return string;
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getMetaData()");
        }
        if (this.dbmd == null) {
            this.dbmd = new JdbcDBMD(this.conn);
        }
        return this.dbmd;
    }

    public String getCatalog() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getCatalog(): " + null);
        }
        return null;
    }

    public void setCatalog(String string) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".setCatalog( " + string + " ): ignored");
        }
    }

    public Map getTypeMap() {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getTypeMap()");
        }
        return this.type_map;
    }

    public void setTypeMap(Map map) {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".setTypeMap()");
        }
        this.type_map = map;
    }

    public boolean isReadOnly() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".isReadOnly(): " + this.conn.readOnly);
        }
        return this.conn.readOnly;
    }

    public synchronized void setReadOnly(boolean bl) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".setReadOnly( " + bl + " )");
        }
        this.warnings = null;
        if (this.conn.readOnly == bl) {
            return;
        }
        if (this.conn.is_dtmc) {
            if (this.trace.enabled(1)) {
                this.trace.write(this.tr_id + ": not permitted when DTMC");
            }
            throw SqlEx.get(ERR_GC4019_UNSUPPORTED);
        }
        this.sendTransactionQuery(bl, this.isolationLevel);
    }

    public int getTransactionIsolation() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getTransactionIsolation: " + this.isolationLevel);
        }
        return this.isolationLevel;
    }

    public synchronized void setTransactionIsolation(int n) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".setTransactionIsolation( " + n + " )");
        }
        this.clearWarnings();
        if (n == this.isolationLevel) {
            return;
        }
        if (this.conn.is_dtmc) {
            if (this.trace.enabled(1)) {
                this.trace.write(this.tr_id + ": not permitted when DTMC");
            }
            throw SqlEx.get(ERR_GC4019_UNSUPPORTED);
        }
        if (n != 8 && this.conn.sqlLevel < 605) {
            if (this.trace.enabled(3)) {
                this.trace.write(this.tr_id + ": Requested isolation level not supported!");
            }
            this.setWarning(SqlWarn.get(ERR_GC4019_UNSUPPORTED));
            return;
        }
        this.sendTransactionQuery(this.conn.readOnly, n);
    }

    private synchronized void sendTransactionQuery(boolean bl, int n) throws SQLException {
        if (this.trace.enabled(2)) {
            this.trace.write(this.tr_id + ".sendTransactionQuery( " + bl + " , " + n + " )");
        }
        String string = "set session read ";
        string = string + (bl ? "only" : " write");
        string = string + ", isolation level ";
        try {
            Statement statement = this.createStatement();
            switch (n) {
                case 1: {
                    string = string + "read uncommitted";
                    break;
                }
                case 2: {
                    string = string + "read committed";
                    break;
                }
                case 4: {
                    string = string + "repeatable read";
                    break;
                }
                case 8: {
                    string = string + "serializable";
                    break;
                }
                default: {
                    throw SqlEx.get(ERR_GC4010_PARAM_VALUE);
                }
            }
            statement.executeUpdate(string);
            this.warnings = statement.getWarnings();
            statement.close();
            this.conn.readOnly = bl;
            this.isolationLevel = n;
        }
        catch (SQLException sQLException) {
            if (this.trace.enabled()) {
                this.trace.log(this.title + ".sendTransactionQuery(): failed!");
            }
            if (this.trace.enabled(1)) {
                ((SqlEx)sQLException).trace(this.trace);
            }
            throw sQLException;
        }
    }

    public boolean getAutoCommit() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getAutoCommit(): " + this.conn.autoCommit);
        }
        return this.conn.autoCommit;
    }

    public void setAutoCommit(boolean bl) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".setAutoCommit( " + bl + " )");
        }
        this.warnings = null;
        this.clearSavepoints(null);
        if (bl == this.conn.autoCommit) {
            return;
        }
        if (this.conn.is_dtmc) {
            if (this.trace.enabled(1)) {
                this.trace.write(this.tr_id + ": not permitted when DTMC");
            }
            throw SqlEx.get(ERR_GC4019_UNSUPPORTED);
        }
        this.msg.lock();
        try {
            this.msg.begin((byte)3);
            this.msg.write(bl ? (short)3 : 4);
            this.msg.done(true);
            this.readResults();
        }
        catch (SqlEx sqlEx) {
            if (this.trace.enabled()) {
                this.trace.log(this.title + ".setAutoCommit(): error changing autocommit");
            }
            if (this.trace.enabled(1)) {
                sqlEx.trace(this.trace);
            }
            throw sqlEx;
        }
        finally {
            this.msg.unlock();
        }
        this.conn.autoCommit = bl;
    }

    public void commit() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".commit()");
        }
        this.warnings = null;
        this.clearSavepoints(null);
        if (this.conn.autoCommit) {
            if (this.trace.enabled(1)) {
                this.trace.write(this.tr_id + ": not permitted with autocommit enabled");
            }
            throw SqlEx.get(ERR_GC401F_XACT_STATE);
        }
        this.msg.lock();
        try {
            this.msg.begin((byte)3);
            this.msg.write((short)1);
            this.msg.done(true);
            this.readResults();
        }
        catch (SqlEx sqlEx) {
            if (this.trace.enabled()) {
                this.trace.log(this.title + ".commit(): error committing transaction");
            }
            if (this.trace.enabled(1)) {
                sqlEx.trace(this.trace);
            }
            throw sqlEx;
        }
        finally {
            this.msg.unlock();
        }
    }

    public void rollback() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".rollback()");
        }
        this.warnings = null;
        this.clearSavepoints(null);
        if (this.conn.autoCommit) {
            if (this.trace.enabled(1)) {
                this.trace.write(this.tr_id + ": not permitted with autocommit enabled");
            }
            throw SqlEx.get(ERR_GC401F_XACT_STATE);
        }
        this.msg.lock();
        try {
            this.msg.begin((byte)3);
            this.msg.write((short)2);
            this.msg.done(true);
            this.readResults();
        }
        catch (SqlEx sqlEx) {
            if (this.trace.enabled()) {
                this.trace.log(this.title + ".rollback(): error rolling back transaction");
            }
            if (this.trace.enabled(1)) {
                sqlEx.trace(this.trace);
            }
            throw sqlEx;
        }
        finally {
            this.msg.unlock();
        }
    }

    public void rollback(Savepoint savepoint) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".rollback(" + savepoint + ")");
        }
        this.warnings = null;
        if (this.conn.autoCommit) {
            if (this.trace.enabled(1)) {
                this.trace.write(this.tr_id + ": not permitted with autocommit enabled");
            }
            throw SqlEx.get(ERR_GC401F_XACT_STATE);
        }
        JdbcSP jdbcSP = this.savepoints;
        while (true) {
            if (jdbcSP == null) {
                if (this.trace.enabled(1)) {
                    this.trace.write(this.tr_id + ": savepoint not found");
                }
                throw SqlEx.get(ERR_GC4010_PARAM_VALUE);
            }
            if (jdbcSP == (JdbcSP)savepoint) break;
            jdbcSP = jdbcSP.getNext();
        }
        this.msg.lock();
        try {
            this.msg.begin((byte)3);
            this.msg.write((short)2);
            this.msg.write((short)5);
            this.msg.write(jdbcSP.getName());
            this.msg.done(true);
            this.readResults();
        }
        catch (SqlEx sqlEx) {
            if (this.trace.enabled()) {
                this.trace.log(this.title + ".rollback(): error rolling back savepoint");
            }
            if (this.trace.enabled(1)) {
                sqlEx.trace(this.trace);
            }
            throw sqlEx;
        }
        finally {
            this.msg.unlock();
        }
        this.clearSavepoints(jdbcSP);
        this.conn.clearPrepStmts();
    }

    public Savepoint setSavepoint() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".setSavepoint()");
        }
        this.warnings = null;
        if (this.conn.autoCommit) {
            if (this.trace.enabled(1)) {
                this.trace.write(this.tr_id + ": not permitted with autocommit enabled");
            }
            throw SqlEx.get(ERR_GC401F_XACT_STATE);
        }
        if (this.conn.msg_protocol_level < 3) {
            if (this.trace.enabled(1)) {
                this.trace.write(this.tr_id + ": savepoints not supported @ protocol " + this.conn.msg_protocol_level);
            }
            throw SqlEx.get(ERR_GC4019_UNSUPPORTED);
        }
        String string = this.conn.dbCaps.getDbCap("SAVEPOINTS");
        if (string != null && (string.charAt(0) == 'N' || string.charAt(0) == 'n')) {
            if (this.trace.enabled(1)) {
                this.trace.write(this.tr_id + ": DBMS doesn't support savepoints");
            }
            throw SqlEx.get(ERR_GC4019_UNSUPPORTED);
        }
        JdbcSP jdbcSP = JdbcSP.getUnnamedSP();
        this.createSavepoint(jdbcSP);
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".setSavepoint: " + jdbcSP);
        }
        return jdbcSP;
    }

    public Savepoint setSavepoint(String string) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".setSavepoint('" + string + "')");
        }
        this.warnings = null;
        if (this.conn.autoCommit) {
            if (this.trace.enabled(1)) {
                this.trace.write(this.tr_id + ": not permitted with autocommit enabled");
            }
            throw SqlEx.get(ERR_GC401F_XACT_STATE);
        }
        if (this.conn.msg_protocol_level < 3) {
            if (this.trace.enabled(1)) {
                this.trace.write(this.tr_id + ": savepoints not supported @ protocol " + this.conn.msg_protocol_level);
            }
            throw SqlEx.get(ERR_GC4019_UNSUPPORTED);
        }
        String string2 = this.conn.dbCaps.getDbCap("SAVEPOINTS");
        if (string2 != null && (string2.charAt(0) == 'N' || string2.charAt(0) == 'n')) {
            if (this.trace.enabled(1)) {
                this.trace.write(this.tr_id + ": DBMS doesn't support savepoints");
            }
            throw SqlEx.get(ERR_GC4019_UNSUPPORTED);
        }
        JdbcSP jdbcSP = JdbcSP.getNamedSP(string);
        this.createSavepoint(jdbcSP);
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".setSavepoint: " + jdbcSP);
        }
        return jdbcSP;
    }

    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        JdbcSP jdbcSP = null;
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".releaseSavepoint(" + savepoint + ")");
        }
        JdbcSP jdbcSP2 = this.savepoints;
        while (true) {
            if (jdbcSP2 == null) {
                if (this.trace.enabled(1)) {
                    this.trace.write(this.tr_id + ": savepoint not found");
                }
                throw SqlEx.get(ERR_GC4010_PARAM_VALUE);
            }
            if (jdbcSP2 == (JdbcSP)savepoint) {
                if (jdbcSP == null) {
                    this.savepoints = jdbcSP2.setNext(null);
                    break;
                }
                jdbcSP.setNext(jdbcSP2.setNext(null));
                break;
            }
            jdbcSP = jdbcSP2;
            jdbcSP2 = jdbcSP2.getNext();
        }
    }

    private void createSavepoint(JdbcSP jdbcSP) throws SqlEx {
        this.msg.lock();
        try {
            this.msg.begin((byte)3);
            this.msg.write((short)7);
            this.msg.write((short)5);
            this.msg.write(jdbcSP.getName());
            this.msg.done(true);
            this.readResults();
        }
        catch (SqlEx sqlEx) {
            if (this.trace.enabled()) {
                this.trace.log(this.title + ".setSavepoint: error creating savepoint");
            }
            if (this.trace.enabled(1)) {
                sqlEx.trace(this.trace);
            }
            throw sqlEx;
        }
        finally {
            this.msg.unlock();
        }
        jdbcSP.setNext(this.savepoints);
        this.savepoints = jdbcSP;
    }

    private void clearSavepoints(JdbcSP jdbcSP) {
        while (this.savepoints != null && this.savepoints != jdbcSP) {
            this.savepoints = this.savepoints.setNext(null);
        }
    }

    String getTransactionServer() {
        String string = null;
        if (this.conn.msg_protocol_level >= 4) {
            try {
                string = this.conn.dbInfo.getDbmsInfo("ima_server");
            }
            catch (SqlEx sqlEx) {
                // empty catch block
            }
        }
        return string;
    }

    public void startTransaction(IngXid ingXid) throws SQLException {
        if (this.trace.enabled(2)) {
            this.trace.write(this.tr_id + ".startTransaction(" + ingXid + ")");
        }
        this.warnings = null;
        if (this.conn.is_dtmc) {
            if (this.trace.enabled(1)) {
                this.trace.write(this.tr_id + ".startTransaction: not permitted when DTMC");
            }
            throw SqlEx.get(ERR_GC4019_UNSUPPORTED);
        }
        if (this.conn.msg_protocol_level < 2) {
            if (this.trace.enabled(1)) {
                this.trace.write(this.tr_id + ".startTransaction: protocol = " + this.conn.msg_protocol_level);
            }
            throw SqlEx.get(ERR_GC4019_UNSUPPORTED);
        }
        this.msg.lock();
        try {
            this.msg.begin((byte)3);
            this.msg.write((short)5);
            this.msg.write((short)1);
            this.msg.write((short)8);
            this.msg.write((int)ingXid.getID());
            this.msg.write((int)(ingXid.getID() >> 32));
            this.msg.done(true);
            this.readResults();
        }
        catch (SqlEx sqlEx) {
            if (this.trace.enabled(1)) {
                this.trace.write(this.tr_id + ".startTransaction: error starting xact");
                sqlEx.trace(this.trace);
            }
            throw sqlEx;
        }
        finally {
            this.msg.unlock();
        }
    }

    public void startTransaction(XaXid xaXid) throws SQLException {
        this.startTransaction(xaXid, 0);
    }

    public void startTransaction(XaXid xaXid, int n) throws SqlEx, XaEx {
        if (this.trace.enabled(2)) {
            this.trace.write(this.tr_id + ".startTransaction( " + xaXid + ", 0x" + Integer.toHexString(n) + " )");
        }
        this.warnings = null;
        if (this.conn.is_dtmc) {
            if (this.trace.enabled(1)) {
                this.trace.write(this.tr_id + ".startTransaction: not permitted when DTMC");
            }
            throw SqlEx.get(ERR_GC4019_UNSUPPORTED);
        }
        if (this.conn.msg_protocol_level < 2 || n != 0 && this.conn.msg_protocol_level < 5) {
            if (this.trace.enabled(1)) {
                this.trace.write(this.tr_id + ".startTransaction: protocol = " + this.conn.msg_protocol_level);
            }
            throw SqlEx.get(ERR_GC4019_UNSUPPORTED);
        }
        this.msg.lock();
        try {
            this.msg.begin((byte)3);
            this.msg.write((short)5);
            this.msg.write((short)2);
            this.msg.write((short)4);
            this.msg.write(xaXid.getFormatId());
            this.msg.write((short)3);
            this.msg.write(xaXid.getGlobalTransactionId());
            this.msg.write((short)4);
            this.msg.write(xaXid.getBranchQualifier());
            if (n != 0) {
                this.msg.write((short)6);
                this.msg.write((short)4);
                this.msg.write(n);
            }
            this.msg.done(true);
            this.readResults();
        }
        catch (XaEx xaEx) {
            if (this.trace.enabled(1)) {
                this.trace.write(this.tr_id + ".startTransaction: XA error starting xact - " + xaEx.getErrorCode());
            }
            throw xaEx;
        }
        catch (SqlEx sqlEx) {
            if (this.trace.enabled(1)) {
                this.trace.write(this.tr_id + ".startTransaction: error starting xact");
                sqlEx.trace(this.trace);
            }
            throw sqlEx;
        }
        finally {
            this.msg.unlock();
        }
    }

    public void endTransaction(XaXid xaXid) throws SqlEx, XaEx {
        this.endTransaction(xaXid, 0);
    }

    public void endTransaction(XaXid xaXid, int n) throws SqlEx, XaEx {
        if (this.trace.enabled(2)) {
            this.trace.write(this.tr_id + ".endTransaction( " + xaXid + ", 0x" + Integer.toHexString(n) + " )");
        }
        this.warnings = null;
        if (this.conn.is_dtmc) {
            if (this.trace.enabled(1)) {
                this.trace.write(this.tr_id + ".endTransaction: not permitted when DTMC");
            }
            throw SqlEx.get(ERR_GC4019_UNSUPPORTED);
        }
        if (this.conn.msg_protocol_level < 5) {
            if (this.trace.enabled(1)) {
                this.trace.write(this.tr_id + ".endTransaction: protocol = " + this.conn.msg_protocol_level);
            }
            throw SqlEx.get(ERR_GC4019_UNSUPPORTED);
        }
        this.msg.lock();
        try {
            this.msg.begin((byte)3);
            this.msg.write((short)9);
            this.msg.write((short)2);
            this.msg.write((short)4);
            this.msg.write(xaXid.getFormatId());
            this.msg.write((short)3);
            this.msg.write(xaXid.getGlobalTransactionId());
            this.msg.write((short)4);
            this.msg.write(xaXid.getBranchQualifier());
            if (n != 0) {
                this.msg.write((short)6);
                this.msg.write((short)4);
                this.msg.write(n);
            }
            this.msg.done(true);
            this.readResults();
        }
        catch (XaEx xaEx) {
            if (this.trace.enabled(1)) {
                this.trace.write(this.tr_id + ".endTransaction: XA error ending xact - " + xaEx.getErrorCode());
            }
            throw xaEx;
        }
        catch (SqlEx sqlEx) {
            if (this.trace.enabled(1)) {
                this.trace.write(this.tr_id + ".endTransaction: error ending xact");
                sqlEx.trace(this.trace);
            }
            throw sqlEx;
        }
        finally {
            this.msg.unlock();
        }
    }

    public void prepareTransaction() throws SQLException {
        if (this.trace.enabled(2)) {
            this.trace.write(this.tr_id + ".prepareTransaction()");
        }
        this.warnings = null;
        if (this.conn.is_dtmc) {
            if (this.trace.enabled(1)) {
                this.trace.write(this.tr_id + ".prepareTransaction: not permitted when DTMC");
            }
            throw SqlEx.get(ERR_GC4019_UNSUPPORTED);
        }
        if (this.conn.msg_protocol_level < 2) {
            if (this.trace.enabled(1)) {
                this.trace.write(this.tr_id + ".prepareTransaction: protocol = " + this.conn.msg_protocol_level);
            }
            throw SqlEx.get(ERR_GC4019_UNSUPPORTED);
        }
        this.msg.lock();
        try {
            this.msg.begin((byte)3);
            this.msg.write((short)6);
            this.msg.done(true);
            this.readResults();
        }
        catch (SqlEx sqlEx) {
            if (this.trace.enabled(1)) {
                this.trace.write(this.tr_id + ".prepareTransaction: error preparing xact");
                sqlEx.trace(this.trace);
            }
            throw sqlEx;
        }
        finally {
            this.msg.unlock();
        }
    }

    public void prepareTransaction(XaXid xaXid) throws SqlEx, XaEx {
        if (this.trace.enabled(2)) {
            this.trace.write(this.tr_id + ".prepareTransaction(" + xaXid + ")");
        }
        this.warnings = null;
        if (this.conn.msg_protocol_level < 5) {
            if (this.trace.enabled(1)) {
                this.trace.write(this.tr_id + ".prepareTransaction: protocol = " + this.conn.msg_protocol_level);
            }
            throw SqlEx.get(ERR_GC4019_UNSUPPORTED);
        }
        this.msg.lock();
        try {
            this.msg.begin((byte)3);
            this.msg.write((short)6);
            this.msg.write((short)2);
            this.msg.write((short)4);
            this.msg.write(xaXid.getFormatId());
            this.msg.write((short)3);
            this.msg.write(xaXid.getGlobalTransactionId());
            this.msg.write((short)4);
            this.msg.write(xaXid.getBranchQualifier());
            this.msg.done(true);
            this.readResults();
        }
        catch (XaEx xaEx) {
            if (this.trace.enabled(1)) {
                this.trace.write(this.tr_id + ".prepareTransaction: XA error preparing xact - " + xaEx.getErrorCode());
            }
            throw xaEx;
        }
        catch (SqlEx sqlEx) {
            if (this.trace.enabled(1)) {
                this.trace.write(this.tr_id + ".prepareTransaction: error preparing xact");
                sqlEx.trace(this.trace);
            }
            throw sqlEx;
        }
        finally {
            this.msg.unlock();
        }
    }

    public void commit(XaXid xaXid) throws SqlEx, XaEx {
        this.commit(xaXid, 0);
    }

    public void commit(XaXid xaXid, int n) throws SqlEx, XaEx {
        if (this.trace.enabled(2)) {
            this.trace.write(this.tr_id + ".commit( " + xaXid + ", 0x" + Integer.toHexString(n) + " )");
        }
        this.warnings = null;
        if (this.conn.msg_protocol_level < 5) {
            if (this.trace.enabled(1)) {
                this.trace.write(this.tr_id + ".commit: protocol = " + this.conn.msg_protocol_level);
            }
            throw SqlEx.get(ERR_GC4019_UNSUPPORTED);
        }
        this.msg.lock();
        try {
            this.msg.begin((byte)3);
            this.msg.write((short)1);
            this.msg.write((short)2);
            this.msg.write((short)4);
            this.msg.write(xaXid.getFormatId());
            this.msg.write((short)3);
            this.msg.write(xaXid.getGlobalTransactionId());
            this.msg.write((short)4);
            this.msg.write(xaXid.getBranchQualifier());
            if (n != 0) {
                this.msg.write((short)6);
                this.msg.write((short)4);
                this.msg.write(n);
            }
            this.msg.done(true);
            this.readResults();
        }
        catch (XaEx xaEx) {
            if (this.trace.enabled(1)) {
                this.trace.write(this.tr_id + ".commit: XA error committing transaction - " + xaEx.getErrorCode());
            }
            throw xaEx;
        }
        catch (SqlEx sqlEx) {
            if (this.trace.enabled(1)) {
                this.trace.write(this.tr_id + ".commit: error committing transaction");
                sqlEx.trace(this.trace);
            }
            throw sqlEx;
        }
        finally {
            this.msg.unlock();
        }
    }

    public void rollback(XaXid xaXid) throws SqlEx, XaEx {
        if (this.trace.enabled(2)) {
            this.trace.write(this.tr_id + ".rollback(" + xaXid + ")");
        }
        this.warnings = null;
        if (this.conn.msg_protocol_level < 5) {
            if (this.trace.enabled(1)) {
                this.trace.write(this.tr_id + ".rollback: protocol = " + this.conn.msg_protocol_level);
            }
            throw SqlEx.get(ERR_GC4019_UNSUPPORTED);
        }
        this.msg.lock();
        try {
            this.msg.begin((byte)3);
            this.msg.write((short)2);
            this.msg.write((short)2);
            this.msg.write((short)4);
            this.msg.write(xaXid.getFormatId());
            this.msg.write((short)3);
            this.msg.write(xaXid.getGlobalTransactionId());
            this.msg.write((short)4);
            this.msg.write(xaXid.getBranchQualifier());
            this.msg.done(true);
            this.readResults();
        }
        catch (XaEx xaEx) {
            if (this.trace.enabled(1)) {
                this.trace.write(this.tr_id + ".rollback: XA error rolling back transaction - " + xaEx.getErrorCode());
            }
            throw xaEx;
        }
        catch (SqlEx sqlEx) {
            if (this.trace.enabled(1)) {
                this.trace.write(this.tr_id + ".rollback: error rolling back transaction");
                sqlEx.trace(this.trace);
            }
            throw sqlEx;
        }
        finally {
            this.msg.unlock();
        }
    }

    void abortTransaction(XaXid xaXid) throws SQLException {
        this.warnings = null;
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".abortTransaction( '" + xaXid + "' )");
        }
        if (!this.conn.is_dtmc) {
            if (this.trace.enabled(1)) {
                this.trace.write(this.tr_id + ": DTM connection required");
            }
            throw SqlEx.get(ERR_GC4019_UNSUPPORTED);
        }
        if (this.conn.msg_protocol_level < 4) {
            if (this.trace.enabled(1)) {
                this.trace.write(this.tr_id + ": protocol = " + this.conn.msg_protocol_level);
            }
            throw SqlEx.get(ERR_GC4019_UNSUPPORTED);
        }
        this.msg.lock();
        try {
            this.msg.begin((byte)3);
            this.msg.write((short)8);
            this.msg.write((short)2);
            this.msg.write((short)4);
            this.msg.write(xaXid.getFormatId());
            this.msg.write((short)3);
            this.msg.write(xaXid.getGlobalTransactionId());
            this.msg.write((short)4);
            this.msg.write(xaXid.getBranchQualifier());
            this.msg.done(true);
            this.readResults();
        }
        catch (SqlEx sqlEx) {
            if (this.trace.enabled()) {
                this.trace.log(this.title + ".abortTransaction(): error aborting xact");
            }
            if (this.trace.enabled(1)) {
                sqlEx.trace(this.trace);
            }
            throw sqlEx;
        }
        finally {
            this.msg.unlock();
        }
    }

    XaXid[] getPreparedTransactionIDs(String string) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getPreparedTransactionIDs('" + string + "')");
        }
        this.warnings = null;
        if (this.conn.msg_protocol_level >= 2) {
            if (this.dbXids == null) {
                this.dbXids = new DbXids(this.conn);
            }
            return this.dbXids.readXids(string);
        }
        return new XaXid[0];
    }

    private static class DbXids
    extends DrvObj {
        private static JdbcRSMD rsmd = null;
        private Vector xids = new Vector();

        public DbXids(DrvConn drvConn) {
            super(drvConn);
            this.title = this.trace.getTraceName() + "-DbXids[" + this.msg.connID() + "]";
            this.tr_id = "DbXid[" + this.msg.connID() + "]";
        }

        public synchronized XaXid[] readXids(String string) throws SqlEx {
            this.xids.clear();
            this.msg.lock();
            try {
                this.msg.begin((byte)10);
                this.msg.write((short)4);
                this.msg.write((short)4);
                this.msg.write(string);
                this.msg.done(true);
                this.readResults();
            }
            catch (SqlEx sqlEx) {
                if (this.trace.enabled(1)) {
                    this.trace.write(this.tr_id + ": error retrieving XID list");
                }
                throw sqlEx;
            }
            finally {
                this.msg.unlock();
            }
            XaXid[] xaXidArray = new XaXid[this.xids.size()];
            for (int i = 0; i < xaXidArray.length; ++i) {
                xaXidArray[i] = (XaXid)this.xids.get(i);
            }
            this.xids.clear();
            return xaXidArray;
        }

        protected JdbcRSMD readDesc() throws SqlEx {
            if (rsmd == null) {
                rsmd = JdbcRSMD.load(this.conn);
            } else {
                rsmd.reload(this.conn);
            }
            return rsmd;
        }

        protected boolean readData() throws SqlEx {
            while (this.msg.moreData()) {
                this.msg.readByte();
                int n = this.msg.readInt();
                this.msg.readByte();
                byte[] byArray = this.msg.readBytes();
                this.msg.readByte();
                byte[] byArray2 = this.msg.readBytes();
                this.xids.add(new XaXid(n, byArray, byArray2));
            }
            return false;
        }
    }
}

