/*
 * Decompiled with CFR 0.152.
 */
package com.ingres.gcf.dam;

import com.ingres.gcf.dam.MsgConst;
import com.ingres.gcf.dam.MsgIo;
import com.ingres.gcf.dam.OutBuff;
import com.ingres.gcf.dam.TlConst;
import com.ingres.gcf.util.ByteArray;
import com.ingres.gcf.util.CharArray;
import com.ingres.gcf.util.GcfErr;
import com.ingres.gcf.util.IdMap;
import com.ingres.gcf.util.IngresDate;
import com.ingres.gcf.util.SqlBigInt;
import com.ingres.gcf.util.SqlByte;
import com.ingres.gcf.util.SqlChar;
import com.ingres.gcf.util.SqlData;
import com.ingres.gcf.util.SqlDate;
import com.ingres.gcf.util.SqlDecimal;
import com.ingres.gcf.util.SqlDouble;
import com.ingres.gcf.util.SqlEx;
import com.ingres.gcf.util.SqlInt;
import com.ingres.gcf.util.SqlLoc;
import com.ingres.gcf.util.SqlLongByte;
import com.ingres.gcf.util.SqlLongByteCache;
import com.ingres.gcf.util.SqlLongChar;
import com.ingres.gcf.util.SqlLongCharCache;
import com.ingres.gcf.util.SqlLongNChar;
import com.ingres.gcf.util.SqlLongNCharCache;
import com.ingres.gcf.util.SqlNChar;
import com.ingres.gcf.util.SqlNVarChar;
import com.ingres.gcf.util.SqlNull;
import com.ingres.gcf.util.SqlReal;
import com.ingres.gcf.util.SqlSmallInt;
import com.ingres.gcf.util.SqlStream;
import com.ingres.gcf.util.SqlTime;
import com.ingres.gcf.util.SqlTimestamp;
import com.ingres.gcf.util.SqlTinyInt;
import com.ingres.gcf.util.SqlVarByte;
import com.ingres.gcf.util.SqlVarChar;
import com.ingres.gcf.util.TraceLog;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;

class MsgOut
extends MsgIo
implements TlConst,
MsgConst,
GcfErr {
    private OutBuff out = null;
    private ByteSegOS segOS = null;
    private Ucs2SegWtr segWtr = null;
    private byte out_msg_id = 0;
    private int out_hdr_pos = 0;
    private int out_hdr_len = 0;

    protected MsgOut(String string, byte[] byArray, TraceLog traceLog) throws SqlEx {
        super(string, traceLog);
        this.title = "MsgOut[" + this.connID() + "]";
        try {
            this.out = new OutBuff(this.socket.getOutputStream(), this.connID(), 1024, traceLog);
        }
        catch (Exception exception) {
            if (this.trace.enabled(1)) {
                this.trace.write(this.title + ": error creating output buffer: " + exception.getMessage());
            }
            this.disconnect();
            throw SqlEx.get(ERR_GC4001_CONNECT_ERR, exception);
        }
        try {
            if (this.trace.enabled(2)) {
                this.trace.write(this.title + ": open TL Connection");
            }
            this.out.begin((short)21059, 12);
            this.out.write((byte)1);
            this.out.write((byte)1);
            this.out.write((byte)2);
            this.out.write((byte)2);
            this.out.write((byte)1);
            this.out.write((byte)15);
            this.out.write((byte)6);
            this.out.write((byte)4);
            this.out.write(0x4C4D4D44);
            if (byArray != null && byArray.length > 0) {
                this.out.write((byte)3);
                if (byArray.length < 255) {
                    this.out.write((byte)byArray.length);
                } else {
                    this.out.write((byte)-1);
                    this.out.write((short)byArray.length);
                }
                this.out.write(byArray, 0, byArray.length);
            }
            this.out.flush();
        }
        catch (SqlEx sqlEx) {
            if (this.trace.enabled(1)) {
                this.trace.write(this.title + ": error formatting/sending parameters");
            }
            this.disconnect();
            throw sqlEx;
        }
    }

    protected void disconnect() {
        if (this.out != null) {
            try {
                this.out.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        super.disconnect();
    }

    protected void close() {
        if (this.trace.enabled(2)) {
            this.trace.write(this.title + ": close TL connection");
        }
        try {
            this.out.clear();
            this.out.begin((short)21060, 0);
            this.out.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void setBuffSize(int n) {
        this.out.setBuffSize(n);
    }

    protected void setIoProtoLvl(byte by) {
        this.out.setProtoLvl(by);
    }

    public void begin(byte by) throws SqlEx {
        if (this.isClosed()) {
            throw SqlEx.get(ERR_GC4004_CONNECTION_CLOSED);
        }
        if (this.out_hdr_pos > 0) {
            this.done(false);
        }
        if (this.trace.enabled(3)) {
            this.trace.write(this.title + ": begin message " + IdMap.map(by, MsgConst.msgMap));
        }
        try {
            this.out.begin((short)21572, 8);
            this.out_msg_id = by;
            this.out_hdr_pos = this.out.position();
            this.out.write(this.msg_proto_lvl >= 3 ? 0x4C4D4D44 : 1128416330);
            this.out.write((short)0);
            this.out.write(by);
            this.out.write((byte)1);
            this.out_hdr_len = this.out.position() - this.out_hdr_pos;
        }
        catch (SqlEx sqlEx) {
            this.disconnect();
            throw sqlEx;
        }
    }

    public void write(byte by) throws SqlEx {
        if (this.out.avail() < 1) {
            this.split();
        }
        this.out.write(by);
    }

    public void write(short s) throws SqlEx {
        if (this.out.avail() < 2) {
            this.split();
        }
        this.out.write(s);
    }

    public void write(int n) throws SqlEx {
        if (this.out.avail() < 4) {
            this.split();
        }
        this.out.write(n);
    }

    public void write(long l) throws SqlEx {
        if (this.out.avail() < 8) {
            this.split();
        }
        this.out.write(l);
    }

    public void write(float f) throws SqlEx {
        if (this.out.avail() < 6) {
            this.split();
        }
        this.out.write(f);
    }

    public void write(double d) throws SqlEx {
        if (this.out.avail() < 10) {
            this.split();
        }
        this.out.write(d);
    }

    public void write(byte[] byArray) throws SqlEx {
        this.write((short)byArray.length);
        this.write(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n, int n2) throws SqlEx {
        int n3 = n + n2;
        while (n < n3) {
            if (this.out.avail() <= 0) {
                this.split();
            }
            n2 = Math.min(this.out.avail(), n3 - n);
            this.out.write(byArray, n, n2);
            n += n2;
        }
    }

    public void write(ByteArray byteArray) throws SqlEx {
        int n;
        int n2 = byteArray.length();
        for (int i = 0; i < n2; i += n) {
            if (this.out.avail() <= 0) {
                this.split();
            }
            n = Math.min(this.out.avail(), n2 - i);
            n = this.out.write(byteArray, i, n);
        }
    }

    public void write(String string) throws SqlEx {
        byte[] byArray;
        try {
            byArray = this.char_set.getBytes(string);
        }
        catch (Exception exception) {
            throw SqlEx.get(ERR_GC401E_CHAR_ENCODE);
        }
        this.write(byArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(InputStream inputStream) throws SqlEx {
        if (this.segOS == null) {
            this.segOS = new ByteSegOS();
        }
        this.segOS.begin(this.out_msg_id);
        try {
            SqlStream.copyIs2Os(inputStream, this.segOS);
        }
        finally {
            this.segOS.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(Reader reader) throws SqlEx {
        OutputStreamWriter outputStreamWriter;
        if (this.segOS == null) {
            this.segOS = new ByteSegOS();
        }
        try {
            outputStreamWriter = this.char_set.getOSW(this.segOS);
        }
        catch (Exception exception) {
            throw SqlEx.get(ERR_GC401E_CHAR_ENCODE);
        }
        this.segOS.begin(this.out_msg_id);
        try {
            SqlStream.copyRdr2Wtr(reader, outputStreamWriter);
        }
        finally {
            this.segOS.end();
        }
    }

    public void writeUCS2(char[] cArray, int n, int n2) throws SqlEx {
        int n3 = n + n2;
        while (n < n3) {
            this.write((short)cArray[n]);
            ++n;
        }
    }

    public void writeUCS2(CharArray charArray) throws SqlEx {
        int n = charArray.length();
        for (int i = 0; i < n; ++i) {
            this.write((short)charArray.get(i));
        }
    }

    public void writeUCS2(String string) throws SqlEx {
        int n = string.length();
        this.write((short)n);
        for (int i = 0; i < n; ++i) {
            this.write((short)string.charAt(i));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeUCS2(Reader reader) throws SqlEx {
        if (this.segWtr == null) {
            this.segWtr = new Ucs2SegWtr();
        }
        this.segWtr.begin(this.out_msg_id);
        try {
            SqlStream.copyRdr2Wtr(reader, this.segWtr);
        }
        finally {
            this.segWtr.end();
        }
    }

    public void write(SqlNull sqlNull) throws SqlEx {
        if (this.writeSqlDataIndicator(sqlNull)) {
            throw SqlEx.get(ERR_GC4002_PROTOCOL_ERR);
        }
    }

    public void write(SqlTinyInt sqlTinyInt) throws SqlEx {
        if (this.writeSqlDataIndicator(sqlTinyInt)) {
            this.write(sqlTinyInt.get());
        }
    }

    public void write(SqlSmallInt sqlSmallInt) throws SqlEx {
        if (this.writeSqlDataIndicator(sqlSmallInt)) {
            this.write(sqlSmallInt.get());
        }
    }

    public void write(SqlInt sqlInt) throws SqlEx {
        if (this.writeSqlDataIndicator(sqlInt)) {
            this.write(sqlInt.get());
        }
    }

    public void write(SqlBigInt sqlBigInt) throws SqlEx {
        if (this.writeSqlDataIndicator(sqlBigInt)) {
            this.write(sqlBigInt.get());
        }
    }

    public void write(SqlReal sqlReal) throws SqlEx {
        if (this.writeSqlDataIndicator(sqlReal)) {
            this.write(sqlReal.get());
        }
    }

    public void write(SqlDouble sqlDouble) throws SqlEx {
        if (this.writeSqlDataIndicator(sqlDouble)) {
            this.write(sqlDouble.get());
        }
    }

    public void write(SqlDecimal sqlDecimal) throws SqlEx {
        if (this.writeSqlDataIndicator(sqlDecimal)) {
            this.write(sqlDecimal.get());
        }
    }

    public void write(SqlDate sqlDate) throws SqlEx {
        if (this.writeSqlDataIndicator(sqlDate)) {
            this.write(sqlDate.get());
        }
    }

    public void write(SqlTime sqlTime) throws SqlEx {
        if (this.writeSqlDataIndicator(sqlTime)) {
            this.write(sqlTime.get());
        }
    }

    public void write(SqlTimestamp sqlTimestamp) throws SqlEx {
        if (this.writeSqlDataIndicator(sqlTimestamp)) {
            this.write(sqlTimestamp.get());
        }
    }

    public void write(IngresDate ingresDate) throws SqlEx {
        if (this.writeSqlDataIndicator(ingresDate)) {
            this.write(ingresDate.get());
        }
    }

    public void write(SqlByte sqlByte) throws SqlEx {
        if (this.writeSqlDataIndicator(sqlByte)) {
            this.write((ByteArray)sqlByte);
        }
    }

    public void write(SqlVarByte sqlVarByte) throws SqlEx {
        if (this.writeSqlDataIndicator(sqlVarByte)) {
            this.write((short)sqlVarByte.length());
            this.write((ByteArray)sqlVarByte);
        }
    }

    public void write(SqlChar sqlChar) throws SqlEx {
        if (this.writeSqlDataIndicator(sqlChar)) {
            this.write((ByteArray)sqlChar);
        }
    }

    public void write(SqlVarChar sqlVarChar) throws SqlEx {
        if (this.writeSqlDataIndicator(sqlVarChar)) {
            this.write((short)sqlVarChar.length());
            this.write((ByteArray)sqlVarChar);
        }
    }

    public void write(SqlNChar sqlNChar) throws SqlEx {
        if (this.writeSqlDataIndicator(sqlNChar)) {
            this.writeUCS2(sqlNChar);
        }
    }

    public void write(SqlNVarChar sqlNVarChar) throws SqlEx {
        if (this.writeSqlDataIndicator(sqlNVarChar)) {
            this.write((short)sqlNVarChar.length());
            this.writeUCS2(sqlNVarChar);
        }
    }

    public void write(SqlLoc sqlLoc) throws SqlEx {
        if (this.writeSqlDataIndicator(sqlLoc)) {
            this.write(sqlLoc.get());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(SqlLongByte sqlLongByte) throws SqlEx {
        if (this.writeSqlDataIndicator(sqlLongByte)) {
            if (this.segOS == null) {
                this.segOS = new ByteSegOS();
            }
            this.segOS.begin(this.out_msg_id);
            try {
                sqlLongByte.get(this.segOS);
            }
            finally {
                this.segOS.end();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(SqlLongByteCache sqlLongByteCache) throws SqlEx {
        if (this.writeSqlDataIndicator(sqlLongByteCache)) {
            if (this.segOS == null) {
                this.segOS = new ByteSegOS();
            }
            this.segOS.begin(this.out_msg_id);
            try {
                sqlLongByteCache.get(this.segOS);
            }
            finally {
                this.segOS.end();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(SqlLongChar sqlLongChar) throws SqlEx {
        if (this.writeSqlDataIndicator(sqlLongChar)) {
            if (this.segOS == null) {
                this.segOS = new ByteSegOS();
            }
            this.segOS.begin(this.out_msg_id);
            try {
                sqlLongChar.get(this.segOS);
            }
            finally {
                this.segOS.end();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(SqlLongCharCache sqlLongCharCache) throws SqlEx {
        if (this.writeSqlDataIndicator(sqlLongCharCache)) {
            if (this.segOS == null) {
                this.segOS = new ByteSegOS();
            }
            this.segOS.begin(this.out_msg_id);
            try {
                sqlLongCharCache.get(this.segOS);
            }
            finally {
                this.segOS.end();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(SqlLongNChar sqlLongNChar) throws SqlEx {
        if (this.writeSqlDataIndicator(sqlLongNChar)) {
            if (this.segWtr == null) {
                this.segWtr = new Ucs2SegWtr();
            }
            this.segWtr.begin(this.out_msg_id);
            try {
                sqlLongNChar.get(this.segWtr);
            }
            finally {
                this.segWtr.end();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(SqlLongNCharCache sqlLongNCharCache) throws SqlEx {
        if (this.writeSqlDataIndicator(sqlLongNCharCache)) {
            if (this.segWtr == null) {
                this.segWtr = new Ucs2SegWtr();
            }
            this.segWtr.begin(this.out_msg_id);
            try {
                sqlLongNCharCache.get(this.segWtr);
            }
            finally {
                this.segWtr.end();
            }
        }
    }

    private boolean writeSqlDataIndicator(SqlData sqlData) throws SqlEx {
        boolean bl = sqlData.isNull();
        this.write((byte)(!bl ? 1 : 0));
        return !bl;
    }

    public void done(boolean bl) throws SqlEx {
        if (this.out_hdr_pos > 0) {
            short s = (short)(this.out.position() - (this.out_hdr_pos + this.out_hdr_len));
            if (this.trace.enabled(2)) {
                this.trace.write(this.title + ": sending message " + IdMap.map(this.out_msg_id, MsgConst.msgMap) + " length " + s + " EOD" + (bl ? " EOG" : ""));
            }
            this.out.write(this.out_hdr_pos + 4, s);
            this.out.write(this.out_hdr_pos + 7, (byte)(1 | (bl ? 2 : 0)));
        }
        if (bl) {
            try {
                this.out.flush();
            }
            catch (SqlEx sqlEx) {
                this.disconnect();
                throw sqlEx;
            }
        }
        this.out_msg_id = (byte)-1;
        this.out_hdr_pos = 0;
        this.out_hdr_len = 0;
    }

    private void split() throws SqlEx {
        if (this.out_hdr_pos > 0) {
            short s = (short)(this.out.position() - (this.out_hdr_pos + this.out_hdr_len));
            if (this.trace.enabled(3)) {
                this.trace.write(this.title + ": split message " + IdMap.map(this.out_msg_id, MsgConst.msgMap) + " length " + s);
            }
            try {
                this.out.write(this.out_hdr_pos + 4, s);
                this.out.write(this.out_hdr_pos + 7, (byte)0);
                this.out.flush();
                this.out.begin((short)21572, 8);
                this.out_hdr_pos = this.out.position();
                this.out.write(this.msg_proto_lvl >= 3 ? 0x4C4D4D44 : 1128416330);
                this.out.write((short)0);
                this.out.write(this.out_msg_id);
                this.out.write((byte)1);
                this.out_hdr_len = this.out.position() - this.out_hdr_pos;
            }
            catch (SqlEx sqlEx) {
                this.disconnect();
                throw sqlEx;
            }
        }
    }

    private class Ucs2SegWtr
    extends Writer {
        private String title;
        private byte msg_id = (byte)-1;
        private int li_pos = -1;

        public Ucs2SegWtr() {
            this.title = "Ucs2SegWtr[" + MsgOut.this.connID() + "]";
        }

        public void begin(byte by) throws SqlEx {
            this.msg_id = by;
            this.li_pos = -1;
            if (MsgOut.this.trace.enabled(3)) {
                MsgOut.this.trace.write(this.title + ": start of CLOB");
            }
            this.startSegment();
        }

        public void write(char[] cArray, int n, int n2) throws IOException {
            try {
                int n3 = n + n2;
                while (n < n3) {
                    if (MsgOut.this.out.avail() < 4) {
                        this.startSegment();
                    }
                    n2 = Math.min(MsgOut.this.out.avail() / 2, n3 - n);
                    MsgOut.this.writeUCS2(cArray, n, n2);
                    n += n2;
                }
            }
            catch (SqlEx sqlEx) {
                if (MsgOut.this.trace.enabled(1)) {
                    MsgOut.this.trace.write(this.title + ": exception writing data");
                    sqlEx.trace(MsgOut.this.trace);
                }
                MsgOut.this.disconnect();
                throw new IOException(sqlEx.getMessage());
            }
        }

        public void flush() throws IOException {
        }

        public void close() throws IOException {
            try {
                this.end();
            }
            catch (SqlEx sqlEx) {
                if (MsgOut.this.trace.enabled(1)) {
                    MsgOut.this.trace.write(this.title + ": exception writing end-of-segments");
                    sqlEx.trace(MsgOut.this.trace);
                }
                MsgOut.this.disconnect();
                throw new IOException(sqlEx.getMessage());
            }
        }

        public void end() throws SqlEx {
            if (this.msg_id >= 0) {
                this.startSegment();
                this.msg_id = (byte)-1;
                this.li_pos = -1;
                if (MsgOut.this.trace.enabled(3)) {
                    MsgOut.this.trace.write(this.title + ": end of CLOB");
                }
            }
        }

        private void startSegment() throws SqlEx {
            if (this.li_pos >= 0) {
                int n = (MsgOut.this.out.position() - this.li_pos - 2) / 2;
                if (n <= 0) {
                    return;
                }
                if (MsgOut.this.trace.enabled(4)) {
                    MsgOut.this.trace.write(this.title + ": CLOB segment length " + n);
                }
                MsgOut.this.out.write(this.li_pos, (short)n);
            }
            if (MsgOut.this.out.avail() < 4) {
                MsgOut.this.done(false);
                MsgOut.this.begin(this.msg_id);
            }
            this.li_pos = MsgOut.this.out.position();
            MsgOut.this.out.write((short)0);
        }
    }

    private class ByteSegOS
    extends OutputStream {
        private String title;
        private byte msg_id = (byte)-1;
        private int li_pos = -1;
        private byte[] ba = new byte[1];

        public ByteSegOS() {
            this.title = "ByteSegOS[" + MsgOut.this.connID() + "]";
        }

        public void begin(byte by) throws SqlEx {
            this.msg_id = by;
            this.li_pos = -1;
            if (MsgOut.this.trace.enabled(3)) {
                MsgOut.this.trace.write(this.title + ": start of BLOB");
            }
            this.startSegment();
        }

        public void write(int n) throws IOException {
            this.ba[0] = (byte)n;
            this.write(this.ba, 0, 1);
        }

        public void write(byte[] byArray) throws IOException {
            this.write(byArray, 0, byArray.length);
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            try {
                int n3 = n + n2;
                while (n < n3) {
                    if (MsgOut.this.out.avail() < 3) {
                        this.startSegment();
                    }
                    n2 = Math.min(MsgOut.this.out.avail(), n3 - n);
                    MsgOut.this.out.write(byArray, n, n2);
                    n += n2;
                }
            }
            catch (SqlEx sqlEx) {
                if (MsgOut.this.trace.enabled(1)) {
                    MsgOut.this.trace.write(this.title + ": exception writing data");
                    sqlEx.trace(MsgOut.this.trace);
                }
                MsgOut.this.disconnect();
                throw new IOException(sqlEx.getMessage());
            }
        }

        public void close() throws IOException {
            try {
                this.end();
            }
            catch (SqlEx sqlEx) {
                if (MsgOut.this.trace.enabled(1)) {
                    MsgOut.this.trace.write(this.title + ": exception writing end-of-segments");
                    sqlEx.trace(MsgOut.this.trace);
                }
                MsgOut.this.disconnect();
                throw new IOException(sqlEx.getMessage());
            }
        }

        public void end() throws SqlEx {
            if (this.msg_id >= 0) {
                this.startSegment();
                this.msg_id = (byte)-1;
                this.li_pos = -1;
                if (MsgOut.this.trace.enabled(3)) {
                    MsgOut.this.trace.write(this.title + ": end of BLOB");
                }
            }
        }

        private void startSegment() throws SqlEx {
            if (this.li_pos >= 0) {
                int n = MsgOut.this.out.position() - this.li_pos - 2;
                if (n <= 0) {
                    return;
                }
                if (MsgOut.this.trace.enabled(4)) {
                    MsgOut.this.trace.write(this.title + ": BLOB segment length " + n);
                }
                MsgOut.this.out.write(this.li_pos, (short)n);
            }
            if (MsgOut.this.out.avail() < 3) {
                MsgOut.this.done(false);
                MsgOut.this.begin(this.msg_id);
            }
            this.li_pos = MsgOut.this.out.position();
            MsgOut.this.out.write((short)0);
        }
    }
}

