/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.sample.ofc;

import com.jaspersoft.sample.ofc.BarChartCompiler;
import com.jaspersoft.sample.ofc.BarDataset;
import com.jaspersoft.sample.ofc.BarSeries;
import com.jaspersoft.sample.ofc.DefaultBarSeries;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.jasperreports.engine.JRElementDataset;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.base.JRBaseElementDataset;
import net.sf.jasperreports.engine.base.JRBaseObjectFactory;

public class CompiledBarDataset
extends JRBaseElementDataset
implements BarDataset {
    private static final long serialVersionUID = 1L;
    private List seriesList;

    public CompiledBarDataset(BarDataset dataset, JRBaseObjectFactory factory) {
        super((JRElementDataset)dataset, factory);
        List series = dataset.getSeries();
        this.seriesList = new ArrayList(series.size());
        Iterator it = series.iterator();
        while (it.hasNext()) {
            BarSeries barSeries = (BarSeries)it.next();
            DefaultBarSeries compiledSeries = new DefaultBarSeries();
            compiledSeries.setSeriesExpression(factory.getExpression(barSeries.getSeriesExpression()));
            compiledSeries.setCategoryExpression(factory.getExpression(barSeries.getCategoryExpression()));
            compiledSeries.setValueExpression(factory.getExpression(barSeries.getValueExpression()));
            this.seriesList.add(compiledSeries);
        }
    }

    public void collectExpressions(JRExpressionCollector collector) {
        BarChartCompiler.collectExpressions(this, collector);
    }

    public List getSeries() {
        return this.seriesList;
    }
}

