/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.jpivot.table;

import com.tonbeller.jpivot.olap.model.Dimension;
import com.tonbeller.jpivot.olap.model.Displayable;
import com.tonbeller.jpivot.olap.model.EmptyMember;
import com.tonbeller.jpivot.olap.model.Hierarchy;
import com.tonbeller.jpivot.olap.model.Level;
import com.tonbeller.jpivot.olap.model.Member;
import com.tonbeller.jpivot.olap.model.Property;
import com.tonbeller.jpivot.olap.model.PropertyHolder;
import com.tonbeller.jpivot.olap.model.VisitorSupportStrict;
import com.tonbeller.jpivot.table.ClickableMember;
import com.tonbeller.jpivot.table.PartBuilderSupport;
import com.tonbeller.jpivot.table.SpanBuilder;
import com.tonbeller.jpivot.table.span.PropertyHeading;
import com.tonbeller.jpivot.table.span.PropertyUtils;
import com.tonbeller.jpivot.table.span.Span;
import com.tonbeller.jpivot.table.span.SpanVisitor;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.w3c.dom.Element;

public class SpanBuilderImpl
extends PartBuilderSupport
implements SpanBuilder {
    String memberName;
    String headingName;
    private static final Logger logger = Logger.getLogger((Class)SpanBuilderImpl.class);

    public SpanBuilderImpl(String memberName, String headingName) {
        this.memberName = memberName;
        this.headingName = headingName;
    }

    public Element build(SpanBuilder.SBContext sbctx, Span span, boolean even) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("build " + span));
        }
        RenderSwitch renderSwitch = new RenderSwitch(sbctx);
        Displayable v = span.getObject();
        v.accept(renderSwitch);
        Element elem = renderSwitch.getElem();
        Iterator it = this.table.clickableIterator();
        while (it.hasNext()) {
            ((ClickableMember)it.next()).decorate(sbctx, span.getObject());
        }
        return elem;
    }

    class RenderSwitch
    extends VisitorSupportStrict
    implements SpanVisitor {
        private static final String CAPTION = "caption";
        Element elem;
        private SpanBuilder.SBContext sbctx;

        public RenderSwitch(SpanBuilder.SBContext sbctx) {
            this.sbctx = sbctx;
        }

        void renderHeading(Displayable d) {
            this.elem = SpanBuilderImpl.this.table.elem(SpanBuilderImpl.this.headingName);
            Element caption = SpanBuilderImpl.this.table.append(CAPTION, this.elem);
            String label = d.getLabel();
            caption.setAttribute(CAPTION, label);
            this.sbctx.setCaption(caption, label);
        }

        private void renderMember(Displayable d, String label) {
            this.elem = SpanBuilderImpl.this.table.elem(SpanBuilderImpl.this.memberName);
            Element caption = SpanBuilderImpl.this.table.append(CAPTION, this.elem);
            caption.setAttribute(CAPTION, label);
            this.sbctx.setCaption(caption, label);
            if (d instanceof PropertyHolder) {
                String value;
                Property[] props = ((PropertyHolder)((Object)d)).getProperties();
                PropertyUtils.addInlineProperties(caption, props);
                Property style = PropertyUtils.getInlineProperty(props, "style");
                if (style != null && (value = style.getValue().trim()).length() > 0) {
                    this.elem.setAttribute("style", value.toLowerCase());
                }
            }
        }

        public void visitPropertyHeading(PropertyHeading v) {
            this.renderHeading(v);
        }

        public void visitDimension(Dimension v) {
            this.renderHeading(v);
        }

        public void visitHierarchy(Hierarchy v) {
            this.renderHeading(v);
        }

        public void visitLevel(Level v) {
            this.renderHeading(v);
        }

        public void visitMember(Member v) {
            this.renderMember(v, v.getLabel());
        }

        public void visitProperty(Property v) {
            this.renderMember(v, v.getValue());
        }

        public void visitEmptyMember(EmptyMember v) {
            this.renderMember(v, v.getLabel());
        }

        public Element getElem() {
            return this.elem;
        }

        public void setElem(Element elem) {
            this.elem = elem;
        }
    }
}

