/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.jpivot.table;

import com.tonbeller.jpivot.olap.model.Axis;
import com.tonbeller.jpivot.olap.model.Hierarchy;
import com.tonbeller.jpivot.olap.model.Member;
import com.tonbeller.jpivot.olap.model.Position;
import com.tonbeller.jpivot.olap.model.Visitor;
import com.tonbeller.jpivot.olap.navi.MemberTree;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class LevelAxisDecorator
implements Axis {
    Axis axis;
    MemberTree tree;
    int[] levelCount;
    boolean[] skipAllMember;
    int totalLevelCount;
    List positions;

    public LevelAxisDecorator(Axis axis, MemberTree tree) {
        this.axis = axis;
        this.tree = tree;
        this.computeLevelCount();
        this.makePositions();
    }

    void computeLevelCount() {
        int i;
        Hierarchy[] hiers = this.axis.getHierarchies();
        int hierarchyCount = this.axis.getHierarchies().length;
        this.levelCount = new int[hierarchyCount];
        this.skipAllMember = new boolean[hierarchyCount];
        for (int i2 = 0; i2 < hiers.length; ++i2) {
            this.levelCount[i2] = Integer.MIN_VALUE;
            this.skipAllMember[i2] = hiers[i2].hasAll();
        }
        Iterator it = this.axis.getPositions().iterator();
        while (it.hasNext()) {
            Position p = (Position)it.next();
            Member[] members = p.getMembers();
            for (int i3 = 0; i3 < members.length; ++i3) {
                int count = members[i3].getRootDistance() + 1;
                this.levelCount[i3] = Math.max(this.levelCount[i3], count);
                if (!members[i3].isAll()) continue;
                this.skipAllMember[i3] = false;
            }
        }
        for (i = 0; i < hierarchyCount; ++i) {
            if (!this.skipAllMember[i]) continue;
            int n = i;
            this.levelCount[n] = this.levelCount[n] - 1;
        }
        this.totalLevelCount = 0;
        for (i = 0; i < hierarchyCount; ++i) {
            this.totalLevelCount += this.levelCount[i];
        }
    }

    void makePositions() {
        this.positions = new ArrayList();
        Iterator it = this.axis.getPositions().iterator();
        while (it.hasNext()) {
            Position p = (Position)it.next();
            this.positions.add(this.makePosition(p));
        }
    }

    private Position makePosition(Position source) {
        Member[] members = source.getMembers();
        Member[] result = new Member[this.totalLevelCount];
        int offset = 0;
        for (int i = 0; i < members.length; ++i) {
            int totalCount = this.levelCount[i];
            int memberCount = members[i].getRootDistance() + 1;
            if (this.skipAllMember[i]) {
                --memberCount;
            }
            this.addParents(result, offset, totalCount, memberCount, members[i]);
            offset += totalCount;
        }
        return new MyPosition(source, result);
    }

    private void addParents(Member[] result, int offset, int totalCount, int memberCount, Member member) {
        int i;
        int fillCount = totalCount - memberCount;
        offset = offset + totalCount - 1;
        for (i = 0; i < fillCount; ++i) {
            result[offset--] = member;
        }
        for (i = 0; i < memberCount; ++i) {
            result[offset--] = member;
            member = this.tree.getParent(member);
        }
    }

    public List getPositions() {
        return this.positions;
    }

    public Hierarchy[] getHierarchies() {
        return this.axis.getHierarchies();
    }

    public Axis getAxis() {
        return this.axis;
    }

    public Object getRootDecoree() {
        return this.axis.getRootDecoree();
    }

    public void accept(Visitor visitor) {
        visitor.visitAxis(this);
    }

    private static class MyPosition
    implements Position {
        Position position;
        Member[] members;

        MyPosition(Position position, Member[] members) {
            this.position = position;
            this.members = members;
        }

        public Position getPosition() {
            return this.position;
        }

        public Member[] getMembers() {
            return this.members;
        }

        public Object getRootDecoree() {
            return this.position.getRootDecoree();
        }

        public void accept(Visitor visitor) {
            visitor.visitPosition(this);
        }
    }
}

