/*
 * Decompiled with CFR 0.152.
 */
package org.flexdock.util;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import org.flexdock.logging.Log;

public class Utilities {
    public static final boolean JAVA_1_4 = Utilities.isJavaVersion("1.4");
    public static final boolean JAVA_1_5 = Utilities.isJavaVersion("1.5");

    public static int getInt(String data) {
        return Utilities.getInt(data, 0);
    }

    public static int getInt(String data, int defaultValue) {
        if (data == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(data);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static float getFloat(String data, float defaultValue) {
        if (data == null) {
            return defaultValue;
        }
        try {
            return Float.parseFloat(data);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static boolean isEmpty(String data) {
        return data == null ? true : data.trim().length() == 0;
    }

    public static Object getInstance(String className) {
        return Utilities.getInstance(className, false);
    }

    public static Object getInstance(String className, boolean failSilent) {
        if (className == null) {
            return null;
        }
        try {
            Class<?> c = Class.forName(className);
            Method m = c.getMethod("getInstance", new Class[0]);
            return m.invoke(null, new Object[0]);
        }
        catch (Throwable e) {
            return Utilities.createInstance(className, failSilent);
        }
    }

    public static Object createInstance(String className) {
        return Utilities.createInstance(className, null);
    }

    public static Object createInstance(String className, boolean failSilent) {
        return Utilities.createInstance(className, null, failSilent);
    }

    public static Object createInstance(String className, Class superType) {
        return Utilities.createInstance(className, superType, false);
    }

    public static Object createInstance(String className, Class superType, boolean failSilent) {
        if (className == null) {
            return null;
        }
        try {
            Class<?> c = Class.forName(className);
            if (superType != null && !superType.isAssignableFrom(c)) {
                throw new ClassCastException("'" + c.getName() + "' is not a type of " + superType + ".");
            }
            return c.newInstance();
        }
        catch (Throwable e) {
            if (!failSilent) {
                Log.warn(e.getMessage(), e);
            }
            return null;
        }
    }

    public static boolean isEqual(Object obj1, Object obj2) {
        return !Utilities.isChanged(obj1, obj2);
    }

    public static boolean isChanged(Object oldObj, Object newObj) {
        if (oldObj == newObj) {
            return false;
        }
        if (oldObj == null || newObj == null) {
            return true;
        }
        return !oldObj.equals(newObj);
    }

    public static boolean sysTrue(String key) {
        String value = key == null ? null : System.getProperty(key);
        return value == null ? false : "true".equals(value);
    }

    public static void put(Map map, Object key, Object value) {
        if (map == null || key == null) {
            return;
        }
        if (value == null) {
            map.remove(key);
        } else {
            map.put(key, value);
        }
    }

    public static boolean setValue(Object obj, String fieldName, Object value) {
        if (obj == null || fieldName == null) {
            return false;
        }
        try {
            Class<?> c = obj.getClass();
            Field field = c.getDeclaredField(fieldName);
            if (field.isAccessible()) {
                field.set(obj, value);
                return true;
            }
            field.setAccessible(true);
            field.set(obj, value);
            field.setAccessible(false);
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    public static Object getValue(Object obj, String fieldName) throws IllegalAccessException {
        if (obj == null || fieldName == null) {
            return null;
        }
        try {
            Class<?> c = obj.getClass();
            Field field = c.getDeclaredField(fieldName);
            if (field.isAccessible()) {
                return field.get(obj);
            }
            field.setAccessible(true);
            Object ret = field.get(obj);
            field.setAccessible(false);
            return obj;
        }
        catch (Throwable t) {
            if (t instanceof IllegalAccessException) {
                throw (IllegalAccessException)t;
            }
            IllegalAccessException e = new IllegalAccessException(t.getMessage());
            e.initCause(t);
            throw e;
        }
    }

    public static void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            Log.debug(e.getMessage(), e);
        }
    }

    private static boolean isJavaVersion(String version) {
        if (version == null) {
            return false;
        }
        return System.getProperty("java.version").startsWith(version);
    }
}

