/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.deploy.auto;

import com.liferay.portal.kernel.deploy.auto.AutoDeployListener;
import com.liferay.portal.kernel.deploy.auto.AutoDeployScanner;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.IntegerWrapper;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class AutoDeployDir {
    private static Log _log;
    private String _name;
    private File _deployDir;
    private File _destDir;
    private long _interval;
    private int _blacklistThreshold;
    private List _listeners;
    private Map _inProcessFiles;
    private Set _blacklistFiles;
    private AutoDeployScanner _scanner;
    static /* synthetic */ Class class$com$liferay$portal$kernel$deploy$auto$AutoDeployDir;
    static /* synthetic */ Class class$com$liferay$portal$kernel$deploy$auto$AutoDeployScanner;

    public String getName() {
        return this._name;
    }

    public File getDeployDir() {
        return this._deployDir;
    }

    public File getDestDir() {
        return this._destDir;
    }

    public long getInterval() {
        return this._interval;
    }

    public int getBlacklistThreshold() {
        return this._blacklistThreshold;
    }

    public List getListeners() {
        return this._listeners;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void start() {
        if (!this._deployDir.exists()) {
            boolean created;
            if (_log.isInfoEnabled()) {
                _log.info("Creating missing directory " + this._deployDir);
            }
            if (!(created = this._deployDir.mkdirs())) {
                _log.error("Directory " + this._deployDir + " could not be created");
            }
        }
        if (this._interval > 0L) {
            try {
                ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
                Class clazz = class$com$liferay$portal$kernel$deploy$auto$AutoDeployScanner;
                if (clazz == null) {
                    clazz = class$com$liferay$portal$kernel$deploy$auto$AutoDeployScanner = AutoDeployDir.class("[Lcom.liferay.portal.kernel.deploy.auto.AutoDeployScanner;", false);
                }
                this._scanner = new AutoDeployScanner(threadGroup, clazz.getName(), this);
                this._scanner.start();
                if (!_log.isInfoEnabled()) return;
                _log.info("Auto deploy scanner started for " + this._deployDir);
                return;
            }
            catch (Exception e) {
                _log.error(e, e);
                this.stop();
                return;
            }
        } else {
            if (!_log.isInfoEnabled()) return;
            _log.info("Auto deploy scanning is disabled for " + this._deployDir);
        }
    }

    public void stop() {
        if (this._scanner != null) {
            this._scanner.pause();
        }
    }

    protected void scanDirectory() {
        File[] files = this._deployDir.listFiles();
        int i = 0;
        while (i < files.length) {
            File file = files[i];
            String fileName = file.getName().toLowerCase();
            if (file.isFile() && (fileName.endsWith(".war") || fileName.endsWith(".zip") || fileName.endsWith(".xml"))) {
                this.processFile(file);
            }
            ++i;
        }
    }

    protected void processFile(File file) {
        block15: {
            String fileName = file.getName();
            if (!file.canRead()) {
                _log.error("Unable to read " + fileName);
                return;
            }
            if (!file.canWrite()) {
                _log.error("Unable to write " + fileName);
                return;
            }
            if (this._blacklistFiles.contains(fileName)) {
                if (_log.isInfoEnabled()) {
                    _log.info("Skip processing of " + fileName + " because it is blacklisted. You must restart the server to remove the file from the blacklist.");
                }
                return;
            }
            IntegerWrapper attempt = (IntegerWrapper)this._inProcessFiles.get(fileName);
            if (attempt == null) {
                attempt = new IntegerWrapper(1);
                this._inProcessFiles.put(fileName, attempt);
                if (_log.isInfoEnabled()) {
                    _log.info("Processing " + fileName);
                }
            } else if (_log.isInfoEnabled()) {
                _log.info("Processing " + fileName + ". This is attempt " + attempt.getValue() + '.');
            }
            try {
                Iterator itr = this._listeners.iterator();
                while (itr.hasNext()) {
                    AutoDeployListener listener = (AutoDeployListener)itr.next();
                    listener.deploy(file);
                }
                if (file.delete()) {
                    this._inProcessFiles.remove(fileName);
                } else {
                    _log.error("Auto deploy failed to remove " + fileName);
                    if (_log.isInfoEnabled()) {
                        _log.info("Add " + fileName + " to the blacklist");
                    }
                    this._blacklistFiles.add(fileName);
                }
            }
            catch (Exception e) {
                _log.error(e, e);
                attempt.increment();
                if (attempt.getValue() < this._blacklistThreshold) break block15;
                if (_log.isInfoEnabled()) {
                    _log.info("Add " + fileName + " to the blacklist");
                }
                this._blacklistFiles.add(fileName);
            }
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    public AutoDeployDir(String name, File deployDir, File destDir, long interval, int blacklistThreshold, List listeners) {
        this._name = name;
        this._deployDir = deployDir;
        this._destDir = destDir;
        this._interval = interval;
        this._blacklistThreshold = blacklistThreshold;
        this._listeners = listeners;
        this._inProcessFiles = new HashMap();
        this._blacklistFiles = new HashSet();
    }

    static {
        Class clazz = class$com$liferay$portal$kernel$deploy$auto$AutoDeployDir;
        if (clazz == null) {
            clazz = class$com$liferay$portal$kernel$deploy$auto$AutoDeployDir = AutoDeployDir.class("[Lcom.liferay.portal.kernel.deploy.auto.AutoDeployDir;", false);
        }
        _log = LogFactoryUtil.getLog(clazz);
    }
}

