/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.support;

import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import org.springframework.binding.expression.Expression;
import org.springframework.core.style.ToStringCreator;
import org.springframework.webflow.RequestContext;
import org.springframework.webflow.ViewSelection;
import org.springframework.webflow.ViewSelector;
import org.springframework.webflow.support.ExternalRedirect;

public class ExternalRedirectSelector
implements ViewSelector,
Serializable {
    private Expression urlExpression;

    public ExternalRedirectSelector(Expression urlExpression) {
        this.urlExpression = urlExpression;
    }

    protected Expression getUrlExpression() {
        return this.urlExpression;
    }

    public ViewSelection makeSelection(RequestContext context) {
        String url = (String)this.urlExpression.evaluateAgainst((Object)context, this.getEvaluationContext(context));
        return new ExternalRedirect(url, false);
    }

    protected Map getEvaluationContext(RequestContext context) {
        return Collections.EMPTY_MAP;
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("urlExpression", (Object)this.urlExpression).toString();
    }
}

