/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.support;

import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.binding.expression.Expression;
import org.springframework.binding.expression.ExpressionParser;
import org.springframework.binding.expression.PropertyExpression;
import org.springframework.binding.mapping.DefaultAttributeMapper;
import org.springframework.binding.mapping.Mapping;
import org.springframework.binding.mapping.MappingBuilder;
import org.springframework.core.style.ToStringCreator;
import org.springframework.webflow.AttributeMap;
import org.springframework.webflow.FlowAttributeMapper;
import org.springframework.webflow.RequestContext;
import org.springframework.webflow.UnmodifiableAttributeMap;
import org.springframework.webflow.support.DefaultExpressionParserFactory;
import org.springframework.webflow.support.FlowScopeExpression;

public class DefaultFlowAttributeMapper
implements FlowAttributeMapper,
Serializable {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private ExpressionParser expressionParser = new DefaultExpressionParserFactory().getExpressionParser();
    private DefaultAttributeMapper inputMapper = new DefaultAttributeMapper();
    private DefaultAttributeMapper outputMapper = new DefaultAttributeMapper();

    public void addInputMapping(Mapping inputMapping) {
        this.inputMapper.addMapping(inputMapping);
    }

    public void addInputMappings(Mapping[] inputMappings) {
        this.inputMapper.addMappings(inputMappings);
    }

    public void addInputAttribute(String inputAttributeName) {
        PropertyExpression expr = this.expressionParser.parsePropertyExpression(inputAttributeName);
        this.inputMapper.addMapping(new Mapping((Expression)new FlowScopeExpression((Expression)expr), expr, null));
    }

    public void addInputAttributes(String[] inputAttributeNames) {
        if (inputAttributeNames == null) {
            return;
        }
        for (int i = 0; i < inputAttributeNames.length; ++i) {
            this.addInputAttribute(inputAttributeNames[i]);
        }
    }

    public void addOutputMapping(Mapping outputMapping) {
        this.outputMapper.addMapping(outputMapping);
    }

    public void addOutputMappings(Mapping[] outputMappings) {
        this.outputMapper.addMappings(outputMappings);
    }

    public void addOutputAttribute(String outputAttributeName) {
        this.outputMapper.addMapping(this.mapping().source(outputAttributeName).value());
    }

    public void addOutputAttributes(String[] outputAttributeNames) {
        if (outputAttributeNames == null) {
            return;
        }
        for (int i = 0; i < outputAttributeNames.length; ++i) {
            this.addOutputAttribute(outputAttributeNames[i]);
        }
    }

    public Mapping[] getInputMappings() {
        return this.inputMapper.getMappings();
    }

    public Mapping[] getOutputMappings() {
        return this.outputMapper.getMappings();
    }

    public AttributeMap createSubflowInput(RequestContext context) {
        if (this.inputMapper != null) {
            AttributeMap input = new AttributeMap();
            this.inputMapper.map((Object)context, (Object)input, this.getMappingContext(context));
            return input;
        }
        return new AttributeMap();
    }

    public void mapSubflowOutput(UnmodifiableAttributeMap subflowOutput, RequestContext context) {
        if (this.outputMapper != null && subflowOutput != null) {
            this.outputMapper.map((Object)subflowOutput, (Object)context.getFlowExecutionContext().getActiveSession().getScope(), this.getMappingContext(context));
        }
    }

    protected MappingBuilder mapping() {
        return new MappingBuilder(this.expressionParser);
    }

    protected Map getMappingContext(RequestContext context) {
        return Collections.EMPTY_MAP;
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("inputMapper", (Object)this.inputMapper).append("outputMapper", (Object)this.outputMapper).toString();
    }
}

